<script src="<?php echo base_url('assets/plugins/sweetalert2/sweetalert2.all.min.js') ?>"></script>
<script>
    $(document).ready(function() {

        $('#table_lots').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });
    });

    function lots_delete(_id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar este registro, una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Eliminar!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>lots/api/lots/id/" +
                        _id,  
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })
    }

    $(document).ready(function() {
        $(".lots_form").validate({
            rules: {
                name_lots: "required",
                date_lots: "required",
                provider: "required",
                no_animals: "required",
                total_weight: "required",
                average_weight: "required",
            },
            messages: {
                name_lots: "Campo requerido.",
                date_lots: "Campo requerido.",
                provider: "Campo requerido.",
                no_animals: "Campo requerido.",
                total_weight: "Campo requerido.",
                average_weight: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });
   
    <?php if (@$births_details) { ?>

       
        $(document).ready(function() {
            $("#add_births").modal('show');
        });

        $(document).on("submit", "#birthsUpdate_form", function(event) {

            

            event.preventDefault();
            $("#btn-save1").html('<button class="btn btn-sm btn-primary" type="button" disabled>' +
                '<span class = "spinner-border spinner-border-sm" role="status" aria-hidden="true"> </span>' +
                'Guardando...</button>');
            $.ajax({
                url: "<?= API_URL . 'births/api/births/id/' . $births_details->id_births ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;

                    $('#add_animals').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Parto actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {


                    response = JSON.stringify(error.responseText);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
            });
        });

    <?php } ?>
</script>