<script src="<?php echo base_url('assets/plugins/sweetalert2/sweetalert2.all.min.js') ?>"></script>
<script>
    $(document).ready(function() {

        $('#user_table').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });
    });

    function delete_user(_id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡De desactivar a este usuario, no podra ingresar a la plataforma!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Desactivar!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>user/api/user/id/" +
                        _id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })
    }

    $(document).ready(function() {
        $("#user_form").validate({
            rules: {
                nombre_usuario: "required",
                apellido_paterno: "required",
                telefono_usuario: "required",
                email: "required",
                password: "required",

            },
            messages: {
                nombre_usuario: "Campo requerido.",
                apellido_paterno: "Campo requerido.",
                telefono_usuario: "Campo requerido.",
                email: "Campo requerido.",
                password: "Campo requerido.",

            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });




    $(document).on("submit", "#user_form", function(event) {
        event.preventDefault();

        $.ajax({
            url: "<?= API_URL ?>user/api/user/",
            method: "POST",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,

            // data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;

                // $('#add_animals').modal('hide')
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Parto actualizado con exito',
                    showConfirmButton: false,
                    timer: 2500,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
            error: function(error) {


                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
        });



    });


    <?php if (@$usuario_info) { ?>
        $(document).ready(function() {
            $("#add_user").modal('show');
        });

        $(document).on("submit", "#userUpdate_form", function(event) {
            event.preventDefault();
            $.ajax({
                url: "<?= API_URL . 'user/api/user/id/' . $usuario_info->id_usuario ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;

                    $('#add_mortality').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Usuario actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {


                    response = JSON.stringify(error.responseText);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
            });
        });

    <?php } ?>
</script>