<script src="<?php echo base_url('assets/plugins/sweetalert2/sweetalert2.all.min.js') ?>"></script>

<script>
    $(document).ready(function() {
        $('#weanings_table').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });
    });
    $(document).ready(function() {
        $(".weaning_form").validate({
            rules: {
                animal: "required",
                date: "required",
                weaning_weight: "required",
                weaning_age: "required",
                gdp: "required",
            },
            messages: {
                animal: "Campo requerido.",
                date: "Campo requerido.",
                weaning_weight: "Campo requerido.",
                weaning_age: "Campo requerido.",
                gdp: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });

    $(document).on("submit", "#weaning_form ", function(event) {
        event.preventDefault();
        $("#btn-save").html('<button class="btn btn-sm btn-primary" type="button" disabled>' +
            '<span class = "spinner-border spinner-border-sm" role="status" aria-hidden="true"> </span>' +
            'Guardando...</button>');
        $.ajax({
            url: "<?= API_URL ?>weanings/api/weanings/",
            method: "POST",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                $('#weaning_modal').modal('hide')
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Destete registrado con exito',
                    showConfirmButton: false,
                    timer: 2500,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }


                })
                earring_ = _response.data.earring;
                var settings = {
                    "url": "<?= API_URL ?>animals/api/animalWeaning/earring/" + 'OVI' + earring_,
                    "method": "DELETE",
                    "timeout": 0,
                    "headers": {
                        "x-api-key": "QroSystem%21#"
                    },
                };

                $.ajax(settings).done(function(response) {
                    console.log(response);
                });


            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: response.message,
                    showConfirmButton: true,
                    onAfterClose: () => {
                        /*   window.location.reload();
                          show_loading(); */
                    }
                })
            },
        });
    });


    function delete_weaning(id) {
        event.preventDefault();

        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar el registro una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminar!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>weanings/api/weanings/id/" +
                        id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                    show_loading();
                                }
                            })
                        } else {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Destete eliminado con exito',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();
                                    show_loading();
                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                show_loading();
                            }
                        })
                    },
                });
            }
        })
    }
    <?php if (@$weaning_details) { ?> $(document).ready(function() {
            $("#weaning_modal").modal('show');
        });
        $(document).on("submit", "#weaningUpdate_form ", function(event) {
            event.preventDefault();
            $("#btn-save").html('<button class="btn btn-sm btn-primary" type="button" disabled>' +
                '<span class = "spinner-border spinner-border-sm" role="status" aria-hidden="true"> </span>' +
                'Guardando...</button>');
            $.ajax({
                url: "<?= API_URL . 'weanings/api/weanings/id/' . $weaning_details->id_weaning ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;
                    $('#weaning_modal').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Destete actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseText);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: response.message,
                        showConfirmButton: true,
                    })
                },
            });
        });

    <?php } ?>


    $("#earring").change(function() {
        $("#spiner_add").html(' <div class="lds-spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>');
        $("#spacies").html("");
        $("#gender").html("");
        $("#mother_earring").html("");
        $("#race").html("");
        $("#birth_date").html("");
        $("#father_earring").html("");
        id = $(this).val();
        var settings = {
            "url": "<?= API_URL; ?>animals/api/animalsByEarring/earring/" + 'OVI' + id,
            "method": "GET",
            "timeout": 0,
            "headers": {
                "x-api-key": "QroSystem%21#"
            },
        };
        $.ajax(settings).done(function(response) {
            if (response.data) {
                $("#spiner_add").html('')
                spacies = response.data.specie;
                gender = response.data.gender;
                mother = response.data.mother_earring;
                race = response.data.race;
                birth_date = response.data.birth_date;
                father = response.data.father_earring;
                $("#spacies").html("<td>" + spacies + "</td>");
                $("#gender").html("<td>" + gender + "</td>");
                $("#mother_earring").html("<td>" + mother + "</td>");
                $("#race").html("<td>" + race + "</td>");
                $("#birth_date").html("<td>" + birth_date + "</td>");
                $("#father_earring").html("<td>" + father + "</td>");
                $("#test").val(birth_date);
                $("#btn_addWeaning").removeAttr('disabled')
            } else {
                document.getElementById("btn_addWeaning").setAttribute('disabled', "true");
                $("#spiner_add").html('')
                $("#earring").val("");
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'No se encuentra este animal!',
                })
            }
        });
    });

    $("#date_weaning").change(function() {
        date_weaning = $(this).val();
        birth_date = $("#test").val();
        let fecha1 = new Date(birth_date);
        let fecha2 = new Date(date_weaning)
        let resta = fecha2.getTime() - fecha1.getTime()
        daysRes = Math.round(resta / (1000 * 60 * 60 * 24));
        $("#weaning_age").val(daysRes);

    });
    $("#reportPdf").on('click', function() {
        document.getElementById("reportWeanings_form").setAttribute('action', '<?= base_url("index.php/weaning/weaning_report") ?>')
        $("#reportWeanings_form").submit();
    });
    $("#reportExcel").on('click', function() {
        document.getElementById("reportWeanings_form").setAttribute('action', '<?= base_url("index.php/weaning/weaning_excel") ?>')
        $("#reportWeanings_form").submit();
        /*   $("#pdf_modal").modal('hide'); */
    });
</script>