<script type="text/javascript">
    $(document).ready(function() {

        $('#weight_table').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });
    });

    $(document).ready(function() {
        $("#gdp_form").validate({
            rules: {
                earring: "required",
                date_weighing: "required",
                weight: "required",
            },
            messages: {
                earring: "Campo requerido.",
                date_weighing: "Campo requerido.",
                weight: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });


    $(document).on("submit", "#GDP_form ", function(event) {
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL ?>weight_gain/api/weight_gain",
            method: "POST",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,

            // data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                $('#treatment_modal').modal('hide')
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'GDP registrado con exito',
                    showConfirmButton: false,
                    timer: 2500,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
        });
    });
    // $(document).on("submit", "#weight_form ", function(event) {
    //     event.preventDefault();
    //     $("#btn-save").html('<button class="btn btn-sm btn-primary" type="button" disabled>' +
    //         '<span class = "spinner-border spinner-border-sm" role="status" aria-hidden="true"> </span>' +
    //         'Guardando...</button>');
    //     $.ajax({
    //         url: "<?= API_URL ?>weight_gain/api/weight_gain/",
    //         method: "POST",
    //         headers: {
    //             "X-API-KEY": "QroSystem%21#",
    //         },
    //         data: $(document).find(this).serialize(),
    //         success: function(_response) {
    //             response = _response.message;
    //             $('#weight_modal').modal('hide')
    //             Swal.fire({
    //                 position: 'center',
    //                 icon: 'success',
    //                 title: 'GDP registrado con exito',
    //                 showConfirmButton: false,
    //                 timer: 2500,
    //                 onAfterClose: () => {
    //                     window.location.reload();
    //                     show_loading();
    //                 }
    //             })
    //         },
    //         error: function(error) {
    //             response = JSON.stringify(error.responseText);
    //             Swal.fire({
    //                 position: 'center',
    //                 icon: 'error',
    //                 title: 'Ha ocurrido un error interno',
    //                 text: response.message,
    //                 showConfirmButton: true,
    //                 onAfterClose: () => {
    //                     window.location.reload();
    //                     show_loading();
    //                 }
    //             })
    //         },
    //     });
    // });
    <?php if (@$weight_details) { ?>
        $(document).ready(function() {
            $("#weight_modal").modal('show');
        });
        $(document).on("submit", "#GDPUpdate_form ", function(event) {

            $.ajax({
                url: "<?= API_URL . 'weight_gain/api/weight_gain/id/' . $weight_details->weightGain_id; ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;
                    $('#weight_modal').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'GDP actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseText);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: response.message,
                        showConfirmButton: true,
                    })
                },
            });
        });

    <?php } ?>

    function delete_weight(id) {
        event.preventDefault();
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar el registro una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminar!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>weight_gain/api/weight_gain/id/" +
                        id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                    show_loading();
                                }
                            })
                        } else {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'GDP eliminado con exito',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();
                                    show_loading();
                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                show_loading();
                            }
                        })
                    },
                });
            }
        })
    }


    $("#earring").change(function() {
        $("#spiner_add").html(' <div class="lds-spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>');
        $("#spacies").html("");
        $("#gender").html("");
        $("#mother_earring").html("");
        $("#race").html("");
        $("#birth_date").html("");
        $("#father_earring").html("");
        id = $(this).val();
        var settings = {
            "url": "<?= API_URL; ?>animals/api/animalsByEarring/earring/" + id,
            "method": "GET",
            "timeout": 0,
            "headers": {
                "x-api-key": "QroSystem%21#"
            },
        };
        $.ajax(settings).done(function(response) {

            if (response.data) {
                $("#spiner_add").html('')
                spacies = response.data.specie;
                gender = response.data.gender;
                mother = response.data.mother_earring;
                race = response.data.race;
                birth_date = response.data.birth_date;
                father = response.data.father_earring;
                category_name = response.data.category_name;
                rodeo_name = response.data.rodeo_name;
                $("#cat_ani").html("<td>" + category_name + "</td>");
                $("#rodeo_n").html("<td>" + rodeo_name + "</td>");
                $("#spacies").html("<td>" + spacies + "</td>");
                $("#gender").html("<td>" + gender + "</td>");
                $("#mother_earring").html("<td>" + mother + "</td>");
                $("#race").html("<td>" + race + "</td>");
                $("#test").val(birth_date);
                $("#birth_date").html("<td>" + birth_date + "</td>");
                $("#father_earring").html("<td>" + father + "</td>");
                $("#btn_addMortality").removeAttr('disabled')




            } else {
                document.getElementById("btn_addMortality").setAttribute('disabled', "true");
                $("#spiner_add").html('')
                $("#earring").val("");
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'No se encuentra este animal!',
                })
            }

            var settings = {
                "url": "<?= API_URL; ?>animal_weighing/api/animalForearring/earring/" + id,
                "method": "GET",
                "timeout": 0,
                "headers": {
                    "x-api-key": "QroSystem%21#"
                },
            };

            $.ajax(settings).done(function(response) {
                if (response.data) {
                    $("#lastWeihging").html('<div class="col-md-6"><table><tr><th>Arete:</th><td align="left">' + response.data.earring + '</td></tr><tr><th>Ultimo pesaje:</th><td  align="left">' + response.data.date + '</td>' +
                        '</tr></table></div>' +
                        '<div class="col-md-6"><table><tr><th>Peso:</th><td  align="left">' + response.data.weight + ' kg</td></tr><tr><th>Comentarios:</th><td  align="left">' + response.data.observation + '</td>' +
                        '</table></div>');
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'No se encuentraron registros anteriores!',
                    })
                }
            });
        });

    });
    $("#date_weighing").change(function() {
        date_weaning = $(this).val();
        birth_date = $("#test").val();
        let fecha1 = new Date(birth_date);
        let fecha2 = new Date(date_weaning)
        let resta = fecha2.getTime() - fecha1.getTime()
        daysRes = Math.round(resta / (1000 * 60 * 60 * 24));
        console.log(daysRes);

        if (daysRes >= 1) {
            $("#age").val(daysRes + " Dias");

        } else {
            $("#age").val(0 + " Dias");

        }


    });
</script>