<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends CI_Controller
{


	public function __construct()
	{
		parent::__construct();

		$this->load->model("home_model");
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
	public function index()
	{

		$balancePez = 0;
		$balanceBorre = 0;
		for ($i = 1; $i <= date('j'); $i++) {

			$date = date('Y') . "-" . date('m') . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
			$dates[] = $date;
			$ventasDia = $this->home_model->get_ventas_pez($date);
			$ventasOvinos = $this->home_model->get_venta_borre($date);
			if ($ventasDia->total == null) {
				$total = 0;
			} else {
				$total = $ventasDia->total;
			}
			$ventaas[] = $total;

			if ($ventasOvinos->total == null) {
				$totalborre = 0;
			} else {
				$totalborre = $ventasOvinos->total;
			}
			$totalborreventa[] = $totalborre;

			$balancePez = $balancePez + $total;
			$balanceBorre = $balanceBorre + $totalborre;
		}	
	    
	    $data['clientesFrecuentesPorTotal']=$this->obtenerClientesFrecuentesPorTotalCompras();
		$data['totalVentasGeneral']=$this->obtenerTotalVentasPorMesGeneral();
		$data['clientesFrecuentes'] = $this->obtenerClientesFrecuentes();
		$data['productos'] = $this->obtenerProductosVentas();
		$data['clientes']=$this->obtenerClientes();
		$data['totalVentasPorProductos'] = $this->obtenerTotalVentaPorProducto();
		$data['widgets'] = $this->getTotalWidgets();
		$data['categorias'] = $this->obtenerCategorias();
		$data['years'] = $this->getYears();
		$data['page'] = 'dashboard';
		$data['dates'] = $dates;
		$data['ventas_dia'] = $ventaas;
		$data['balancePez'] = $balancePez;
		$data['balanceBorre'] = $balanceBorre;
		$data['ventas_ovinos'] = $totalborreventa;
			$data['products'] = $this->get_products();
		$data['precioPorVentasPescado'] = $this->obtenerMercadoPrecioComparativo()->salesPrice[0];
		$data['precioMercadoPescado'] = $this->obtenerMercadoPrecioComparativo()->marketPrice[0];
		$data['body'] = 'dashboard/view';
		$this->load->view('layout/main', $data);
	}
	
		public function obtenerClientes()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'clientes/api/clientes',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$clients = json_decode($response);
		return $clients->data;
	}
	
	
	
	public function get_products()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'productos/api/productos',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));
		$response = curl_exec($curl);

		curl_close($curl);
		$products = json_decode($response);
		return $products->data;
	}
	

	function getTotalWidgets()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/count_entities",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	function obtenerCategorias()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "categorias/api/categorias",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}

	function getYears()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/years_list",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}

	function obtenerProductosPorCategoria($categoria_id)
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "productos/api/getProductByCategory/id/{$categoria_id}",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_encode($response);
			echo $result;
		}
	}
	function obtenerTotalVentaPorProducto()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/totalVentasPorProductos",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	function obtenerProductosVentas()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/productosVentas",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}

	function obtenerClientesFrecuentes()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/clientesFrecuentes",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}

	function obtenerClientesFrecuentesPorTotalCompras(){
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/clientesFrecuentesPorCantidadMonetaria",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	function obtenerTotalVentasPorMesGeneral()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/totalVentasPorMesGeneral",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	
	
	function obtenerMercadoPrecioComparativo()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "dashboard/api/getMarketPriceFishByYear",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	
	
	
	function customComparative()
	{
		$idP = $_POST['idP'];


		$result = $this->getCustomDataLoggerGeneral($idP);


		$data = array(
			'is_by_day' => false,
			'label_name' => 'Fecha',
			// 'labels' => $labels,
			'data' => $result
		);
		//
		echo json_encode($data);

		

	}


	function getCustomDataLoggerGeneral($id)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL.'dashboard/api/getMarketPriceFishByYearProduct/id/'.$id,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		$Products = json_decode($response);
		return $Products->data;
		// echo $response;
	}
	
}
