<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Otros extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        //Do your magic here
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }

    public function clientes_desactivados()
    {
        $data['page'] = 'clientes_desactivados';
        $data['clientes'] = $this->get_clients();
        $data['body'] = 'otros/clientes';
        $this->load->view('layout/main', $data);
    }

    public function get_clients()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'clientes/api/clientes_inactivos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $clients = json_decode($response);
        return $clients->data;
    }

    public function productos_desactivados()
    {
        $data['page'] = 'productos_desactivados';
        $data['products'] = $this->get_products();
        $data['body'] = 'otros/productos';
        $this->load->view('layout/main', $data);
    }

    public function get_products()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'productos/api/productos_inactivos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $products = json_decode($response);
        return $products->data;
    }

    public function categorias_desactivadas()
    {
        $data['page'] = 'categorias_desactivadas';
        $data['categorias'] = $this->get_categories();
        $data['body'] = 'otros/categorias';
        $this->load->view('layout/main', $data);
    }

    public function get_categories()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'categorias/api/categorias_inactivas',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $categories = json_decode($response);
        return $categories->data;
    }

    public function pedidos_cancelados()
    {
        $data['page'] = 'pedidos_cancelados';
        $data['orders'] = $this->get_orders();
        $data['clientes'] = $this->get_clients_1();
        $data['products'] = $this->get_products_1();
        $data['body'] = 'otros/pedidos';
        $this->load->view('layout/main', $data);
    }
    public function get_orders()
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'pedidos/api/pedidos_cancelados',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $orders = json_decode($response);
        return $orders->data;
    }

    public function get_clients_1()
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'clientes/api/clientes',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $clients = json_decode($response);
        return $clients->data;
    }

    public function get_products_1()
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'productos/api/productos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL',
                'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);
        $products = json_decode($response);
        return $products->data;
    }
}
        
    /* End of file  otros.php */
