<?php
defined('BASEPATH') or exit('No direct script access allowed');

class PreciosMercado extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }
    public function index()
    {
        $data['page'] = 'preciosMercado';
        $data['body'] = 'mercado/view';
        $data['preciosMercado'] = $this->get_precios();
        $data['products'] = $this->get_products();
        $this->load->view('layout/main', $data);
    }

	public function get_products()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'productos/api/productos',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));
		$response = curl_exec($curl);

		curl_close($curl);
		$products = json_decode($response);
		return $products->data;
	}

    function get_precios()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'precios_mercado/api/precios_mercado',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $precios = json_decode($response);
        return $precios->data;
    }

/* 
    function get_price_by_id($priceId)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'precios_mercado/api/precios_mercado/id/' . $priceId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $price = json_decode($response);

        $this->session->set_flashdata('mercado_info', array('data' => $price->data));
        redirect('preciosMercado');
    } */
}
