<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Productos extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
	public function index()
	{
		$data['page'] = 'productos';
		$data['body'] = 'productos/view';
		$data['products'] = $this->get_products();
		$data['categories'] = $this->get_categories();
		$this->load->view('layout/main', $data);
	}

	public function get_products()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'productos/api/productos/',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$products = json_decode($response);
		return $products->data;
	}

	public function get_categories()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'categorias/api/categorias/',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$categories = json_decode($response);
		return $categories->data;
	}
}
