<?php
defined('BASEPATH') or exit('No direct script access allowed');
/* require_once('vendor/autoload.php'); */

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Recibo_ventas extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        //Do your magic here
        if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
    }

    function index()
    {
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
        $header = $this->load->view('ventas/recibo_ventas/header', [], true);
        $mpdf->SetHTMLHeader($header);
        $footer = $this->load->view('ventas/recibo_ventas/footer', [], true);
        $mpdf->SetHTMLFooter($footer);
        $html = $this->load->view('ventas/recibo_ventas/body', [], true);
        $css = file_get_contents('assets/pdf-recipie.css');
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');

        $mpdf->Output();

        /* $this->load->view('ventas/recibo_ventas'); */
    }

    function imprimir_recibo($sale_id)
    {
        $sale = $this->get_sale_by_id($sale_id);
        $this->db->where(array('id_venta'=>$sale_id, 'status'=>1));
        $products_sale = $this->db->get('vw_ver')->result();
        $product = $products_sale[0]->nombre_producto;
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
        $header = $this->load->view('ventas/recibo_ventas/header', array('sale' => $sale[0]), true);
        $mpdf->SetHTMLHeader($header);
        $footer = $this->load->view('ventas/recibo_ventas/footer', [], true);
        $mpdf->SetHTMLFooter($footer);
        $html = $this->load->view('ventas/recibo_ventas/body', array('products_sale' => $products_sale, 'product' => $product), true);
        $css = file_get_contents('assets/pdf-recipie.css');
        $mpdf->SetTitle('Recibo de venta ' . $sale[0]->folio_venta);
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');

        $mpdf->Output('RECIBO-' . $sale[0]->folio_venta . '.pdf', 'I');
        $mpdf->WriteHTML('Section 1');
        $mpdf->WriteHTML('');

        exit;
        $mpdf->Output();
        /*  echo var_dump($sale[0]->tipo_venta); */
    }

    function descargar_recibo_excel($sale_id)
    {
        setlocale(LC_ALL, "es_MX.utf8");

        $sale = $this->get_sale_by_id($sale_id)[0];
        $client = $this->db->query("select*From clientes where id_cliente=" . $sale->id_cliente)->row();
        $this->db->where(array('id_venta'=>$sale_id, 'status'=>1));
        $products_sale = $this->db->get('vw_ver')->result();
        $product = $products_sale[0]->nombre_producto;

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png'); // put your path and image here
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);

        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(8);
        $sheet->mergeCells('A1:K4');
        $sheet->mergeCells('A5:G6');
        $sheet->mergeCells('H5:K5');
        $sheet->mergeCells('H6:K6');
        $sheet->mergeCells('A7:K7');
        $sheet->mergeCells('A8:K8');
        $sheet->mergeCells('A9:K9');
        $sheet->mergeCells('A10:K10');


        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

   /*      $sheet->getColumnDimension('A1')->setHeight(10); */
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A12:K12')->getAlignment()->setHorizontal('center');

        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A12:K12")->getFont()->setBold(true);
        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('D12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('E12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('F12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('G12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('H12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('I12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('J12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('K12')->applyFromArray($styleArray);

        $sheet->setCellValue('A1', 'Recibo de venta');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->setCellValue('H5', 'Fecha: ' . strftime("%d-%b-%Y", strtotime($sale->fecha)));
        $sheet->setCellValue('H6', 'Folio: ' . $sale->folio_venta);
        $sheet->setCellValue('A7', 'Vendido a: ' . $sale->nombre_completo);
        if ($client->telefono_cliente == '' || $client->telefono_cliente == null || $client->telefono_cliente == 0 || $client->telefono_cliente == '9999999999') {
            $telefono = '---';
        } else {
            $telefono = $client->telefono_cliente;
        }
        if ($client->email_cliente == '' || $client->email_cliente == null) {
            $email = '---';
        } else {
            $email = $client->email_cliente;
        }


        $sheet->setCellValue('A8', 'Télefono: ' . $telefono);
        $sheet->setCellValue('A9', 'Email: ' . $email);
        $sheet->setCellValue('A10', 'Método de pago: Efectivo');
        if ($product == 'Borrego') {
            /* $sheet->mergeCells('A12:B12'); */
            $sheet->mergeCells('B12:D12');
            $sheet->mergeCells('H12:I12');
            $sheet->mergeCells('J12:K12');
            $sheet->setCellValue('A12', 'N.°');
            $sheet->setCellValue('B12', 'Descripción');
            $sheet->setCellValue('E12', 'Arete');
            $sheet->setCellValue('F12', 'Grapa');
            $sheet->setCellValue('G12', 'Peso');
            $sheet->setCellValue('H12', 'Precio por kilo');
            $sheet->setCellValue('J12', 'Subtotal de línea');
            $cellNumber = 12;
            $total = 0;
            foreach ($products_sale as $i => $ps) {
                $total = $total + $ps->subtotal;
                $cellNumber = $cellNumber + 1;
                $i = $i + 1;
                if ($ps->arete == 0) {
                    $arete = '---';
                } else {
                    $arete = $ps->arete;
                }
                if ($ps->grapa == 0) {
                    $grapa = '---';
                } else {
                    $grapa = $ps->grapa;
                }

                $sheet->getStyle("A{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
                /* $sheet->mergeCells("A{$cellNumber}:B{$cellNumber}"); */
                $sheet->mergeCells("B{$cellNumber}:D{$cellNumber}");
                $sheet->mergeCells("H{$cellNumber}:I{$cellNumber}");
                $sheet->mergeCells("J{$cellNumber}:K{$cellNumber}");
                /*    $spreadsheet->getActiveSheet()->getStyle("A{$cellNumber}")->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle("C{$cellNumber}")->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle("E{$cellNumber}")->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle("F{$cellNumber}")->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle("G{$cellNumber}")->applyFromArray($styleArray);
            $spreadsheet->getActiveSheet()->getStyle("I{$cellNumber}")->applyFromArray($styleArray); */
                $sheet->setCellValue("A{$cellNumber}", $i);
                $sheet->setCellValue("B{$cellNumber}", $ps->nombre_producto.' '.$ps->raza);
                $sheet->setCellValue("E{$cellNumber}", $arete);
                $sheet->setCellValue("F{$cellNumber}", $grapa);
                $sheet->setCellValue("G{$cellNumber}", $ps->cantidad);
                $sheet->setCellValue("H{$cellNumber}", $ps->precio);
                $sheet->setCellValue("J{$cellNumber}", $ps->subtotal);
            }
            $cellNumber = $cellNumber + 1;
            $sheet->getStyle("H{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
            $sheet->mergeCells("H{$cellNumber}:I{$cellNumber}");
            $sheet->mergeCells("J{$cellNumber}:K{$cellNumber}");
            $spreadsheet->getActiveSheet()->getStyle("H{$cellNumber}")->getFont()->setBold(true);
            $sheet->setCellValue("H{$cellNumber}", 'Total: ');
            $sheet->setCellValue("J{$cellNumber}", $total);
        } else if ($product == 'Mojarra') {
            /* $sheet->mergeCells('A12:B12'); */
            $sheet->mergeCells('B12:E12');
            $sheet->mergeCells('F12:G12');
            $sheet->mergeCells('H12:I12');
            $sheet->mergeCells('J12:K12');
            $sheet->setCellValue('A12', 'N.°');
            $sheet->setCellValue('B12', 'Descripción');
            $sheet->setCellValue('F12', 'Cantidad');
            $sheet->setCellValue('H12', 'Precio por kilo');
            $sheet->setCellValue('J12', 'Subtotal de línea');
            $cellNumber = 12;
            $total = 0;
            foreach ($products_sale as $i => $ps) {
                $total = $total + $ps->subtotal;
                $cellNumber = $cellNumber + 1;
                $i = $i + 1;
                if ($ps->arete == 0) {
                    $arete = '---';
                } else {
                    $arete = $ps->arete;
                }
                if ($ps->grapa == 0) {
                    $grapa = '---';
                } else {
                    $grapa = $ps->grapa;
                }

                $sheet->getStyle("A{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
                /* $sheet->mergeCells("A{$cellNumber}:B{$cellNumber}"); */
                $sheet->mergeCells("B{$cellNumber}:E{$cellNumber}");
                $sheet->mergeCells("F{$cellNumber}:G{$cellNumber}");
                $sheet->mergeCells("H{$cellNumber}:I{$cellNumber}");
                $sheet->mergeCells("J{$cellNumber}:K{$cellNumber}");

                $sheet->setCellValue("A{$cellNumber}", $i);
                $sheet->setCellValue("B{$cellNumber}", $ps->nombre_producto.' '.$ps->raza);
                $sheet->setCellValue("F{$cellNumber}", $ps->cantidad);
                $sheet->setCellValue("H{$cellNumber}", $ps->precio);
                $sheet->setCellValue("J{$cellNumber}", $ps->subtotal);
            }
            $cellNumber = $cellNumber + 1;
            $sheet->getStyle("H{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
            $sheet->mergeCells("H{$cellNumber}:I{$cellNumber}");
            $sheet->mergeCells("J{$cellNumber}:K{$cellNumber}");
            $spreadsheet->getActiveSheet()->getStyle("H{$cellNumber}")->getFont()->setBold(true);
            $sheet->setCellValue("H{$cellNumber}", 'Total: ');
            $sheet->setCellValue("J{$cellNumber}", $total);
        }else if ($product == 'Huevo') {
            /* $sheet->mergeCells('A12:B12'); */
            $sheet->mergeCells('B12:E12');
            $sheet->mergeCells('F12:G12');
            $sheet->mergeCells('H12:I12');
            $sheet->mergeCells('J12:K12');
            $sheet->setCellValue('A12', 'N.°');
            $sheet->setCellValue('B12', 'Descripción');
            $sheet->setCellValue('F12', 'Cantidad');
            $sheet->setCellValue('H12', 'Precio por cono');
            $sheet->setCellValue('J12', 'Subtotal de línea');
            $cellNumber = 12;
            $total = 0;
            foreach ($products_sale as $i => $ps) {
                $total = $total + $ps->subtotal;
                $cellNumber = $cellNumber + 1;
                $i = $i + 1;
                if ($ps->arete == 0) {
                    $arete = '---';
                } else {
                    $arete = $ps->arete;
                }
                if ($ps->grapa == 0) {
                    $grapa = '---';
                } else {
                    $grapa = $ps->grapa;
                }

                $sheet->getStyle("A{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
                /* $sheet->mergeCells("A{$cellNumber}:B{$cellNumber}"); */
                $sheet->mergeCells("B{$cellNumber}:E{$cellNumber}");
                $sheet->mergeCells("F{$cellNumber}:G{$cellNumber}");
                $sheet->mergeCells("H{$cellNumber}:I{$cellNumber}");
                $sheet->mergeCells("J{$cellNumber}:K{$cellNumber}");

                $sheet->setCellValue("A{$cellNumber}", $i);
                $sheet->setCellValue("B{$cellNumber}", $ps->nombre_producto . ' ' . $ps->raza);
                $sheet->setCellValue("F{$cellNumber}", $ps->cantidad);
                $sheet->setCellValue("H{$cellNumber}", $ps->precio);
                $sheet->setCellValue("J{$cellNumber}", $ps->subtotal);
            }
            $cellNumber = $cellNumber + 1;
            $sheet->getStyle("H{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
            $sheet->mergeCells("H{$cellNumber}:I{$cellNumber}");
            $sheet->mergeCells("J{$cellNumber}:K{$cellNumber}");
            $spreadsheet->getActiveSheet()->getStyle("H{$cellNumber}")->getFont()->setBold(true);
            $sheet->setCellValue("H{$cellNumber}", 'Total: ');
            $sheet->setCellValue("J{$cellNumber}", $total);
        }
        $writer = new Xlsx($spreadsheet);


        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename=RECIBO-' . $sale->folio_venta  . '.xlsx');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }

    function descargar_reporte_excel($sale_id)
    {
        setlocale(LC_ALL, "es_MX.utf8");

        $sale = $this->get_sale_by_id($sale_id)[0];
        $client = $this->db->query("select*From clientes where id_cliente=" . $sale->id_cliente)->row();
        $this->db->where(array('id_venta' => $sale_id, 'status' => 1));
        $products_sale = $this->db->get('vw_ver')->result();
       /*  $product = $products_sale[0]->nombre_producto; */

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png'); // put your path and image here
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);

        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(8);
        $sheet->mergeCells('A1:K4');
        $sheet->mergeCells('A5:G6');
        $sheet->mergeCells('H5:K5');
        $sheet->mergeCells('H6:K6');
        $sheet->mergeCells('A7:K7');
        $sheet->mergeCells('A8:K8');
        $sheet->mergeCells('A9:K9');
        $sheet->mergeCells('A10:K10');


        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A12:K12')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A12:K12")->getFont()->setBold(true);
        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('D12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('E12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('F12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('G12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('H12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('I12')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('J12')->applyFromArray($styleArray);
/*         $spreadsheet->getActiveSheet()->getStyle('K12')->applyFromArray($styleArray); */

        $sheet->setCellValue('A1', 'Reporte de venta');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->setCellValue('H5', 'Fecha: ' . strftime("%d-%b-%Y", strtotime($sale->fecha)));
        $sheet->setCellValue('H6', 'Folio: ' . $sale->folio_venta);
        $sheet->setCellValue('A7', 'Vendido a: ' . $sale->nombre_completo);
        if ($client->telefono_cliente == '' || $client->telefono_cliente == null || $client->telefono_cliente == 0 || $client->telefono_cliente == '9999999999') {
            $telefono = '---';
        } else {
            $telefono = $client->telefono_cliente;
        }
        if ($client->email_cliente == '' || $client->email_cliente == null) {
            $email = '---';
        } else {
            $email = $client->email_cliente;
        }


        $sheet->setCellValue('A8', 'Télefono: ' . $telefono);
        $sheet->setCellValue('A9', 'Email: ' . $email);
        $sheet->setCellValue('A10', 'Método de pago: Efectivo');

        $sheet->mergeCells('A12:B12');
        $sheet->mergeCells('C12:E12');
        $sheet->mergeCells('I12:J12');
        $sheet->setCellValue('A12', 'N.°');
        $sheet->setCellValue('C12', 'Descripción');
        $sheet->setCellValue('F12', 'Arete');
        $sheet->setCellValue('G12', 'Grapa');
        $sheet->setCellValue('H12', 'Peso');
        $sheet->setCellValue('I12', 'Corral');

        $cellNumber = 12;
        $total = 0;
        foreach ($products_sale as $i => $ps) {
            $total = $total + $ps->subtotal;
            $cellNumber = $cellNumber + 1;
            $i = $i + 1;
            if ($ps->arete == 0) {
                $arete = '---';
            } else {
                $arete = $ps->arete;
            }
            if ($ps->grapa == 0) {
                $grapa = '---';
            } else {
                $grapa = $ps->grapa;
            }

            $sheet->getStyle("A{$cellNumber}:K{$cellNumber}")->getAlignment()->setHorizontal('center');
            $sheet->mergeCells("A{$cellNumber}:B{$cellNumber}");
            $sheet->mergeCells("C{$cellNumber}:E{$cellNumber}");
            $sheet->mergeCells("I{$cellNumber}:J{$cellNumber}");
            

            $sheet->setCellValue("A{$cellNumber}", $i);
            $sheet->setCellValue("C{$cellNumber}", $ps->nombre_producto.' '.$ps->raza);
            $sheet->setCellValue("F{$cellNumber}", $arete);
            $sheet->setCellValue("G{$cellNumber}", $grapa);
            $sheet->setCellValue("H{$cellNumber}", $ps->cantidad);
            $sheet->setCellValue("I{$cellNumber}", $ps->corral);

        }

        $writer = new Xlsx($spreadsheet);


        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename=REPORTE-' . $sale->folio_venta  . '.xlsx');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }

    function get_sale_by_id($sale_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'ventas/api/ventas/id/' . $sale_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: REARNL',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $sales = json_decode($response);
        return $sales->data;
    }
}
