<?php

defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Reportes extends CI_Controller
{


    public function __construct()
    {
        parent::__construct();
        //Do your magic here
        $this->load->model("reportes_model");
        if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
    }

    public function index()
    {
    }

    public function ventas()
    {
        $data['page'] = 'reporte_ventas';
        $data['categorias'] = $this->reportes_model->get_categorias();
        $data['clientes'] = $this->reportes_model->get_clientes();
        $data['body'] = 'reportes/ventas';
        $this->load->view('layout/main', $data);
    }

    public function generar_reporte($categoria_reporte)
    {
        if ($categoria_reporte == 'ventas') {
            $categorias = $this->input->post('categoria');
            $cliente = $this->input->post('cliente');
            $desde = $this->input->post('desde');
            $hasta = $this->input->post('hasta');
            $tipo_venta = $this->input->post('tipo_venta');
            setlocale(LC_ALL, "es_MX.utf8");
            $desde1 = strftime('%d-%b-%y', strtotime($_POST['desde']));
            $hasta1 = strftime('%d-%b-%y', strtotime($_POST['hasta']));

            $ventaInt = $this->reportes_model->get_ventas($desde, $hasta, $categorias, $cliente, $tipo_venta);
            $test = $this->reportes_model->get_ventas($desde, $hasta, $categorias, $cliente, $tipo_venta);
            if ($tipo_venta == "todos") {
                $titulo = "Reporte de ventas";
            } else if ($tipo_venta == 1) {
                $titulo = "Reporte de ventas externas";
            } else if ($tipo_venta == 2) {
                $titulo = "Reporte de ventas internas";
            }
            $mpdf = new \Mpdf\Mpdf();
            $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
            $headerInfo = array(
                'titulo'=>$titulo,
                'desde'=>$desde1,
                'hasta'=>$hasta1
            );
            $header = $this->load->view('reportes/pdf/header', array('headerInfo' => $headerInfo), true);
            $mpdf->SetHTMLHeader($header);
            $footer = $this->load->view('reportes/pdf/footer', [], true);
            $mpdf->SetHTMLFooter($footer);
            $html = $this->load->view('reportes/pdf/body', array('ventas' => $ventaInt,'categoria' => $test), true);
            $css = file_get_contents('assets/pdf-reports.css');
            $mpdf->SetTitle('Reporte de todas las ventas');
            $mpdf->WriteHTML('<body>');
            $mpdf->writeHTML($css, 1);
            $mpdf->WriteHTML($html);
            $mpdf->WriteHTML('</body>');
            $mpdf->Output('Reporte_ventas_Rancho_el_arenal.pdf', 'I');
            $mpdf->setFooter('{PAGENO}');
            $mpdf->WriteHTML('Section 1');
            $mpdf->WriteHTML('');

            exit;
            $mpdf->Output();
        }
    }
    function generar_reporteExcelVentas()
    {
        $categorias = $this->input->post('categoria');
        $cliente = $this->input->post('cliente');
        $desde = $this->input->post('desde');
        $hasta = $this->input->post('hasta');
        $tipo_venta = $this->input->post('tipo_venta');
        setlocale(LC_ALL, "es_MX.utf8");
        $desde1 = strftime('%d-%b-%y', strtotime($_POST['desde']));
        $hasta1 = strftime('%d-%b-%y', strtotime($_POST['hasta']));

        $ventaInt = $this->reportes_model->get_ventas($desde, $hasta, $categorias, $cliente, $tipo_venta);
        if ($tipo_venta == "todos") {
            $titulo = "Reporte de ventas";
        } else if ($tipo_venta == 1) {
            $titulo = "Reporte de ventas externas";
        } else if ($tipo_venta == 2) {
            $titulo = "Reporte de ventas internas";
        }
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png'); // put your path and image here
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);

        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
        $sheet->mergeCells('A1:O4');
        $sheet->mergeCells('A5:K6');
        $sheet->mergeCells('L5:O5');
        $sheet->mergeCells('L6:O6');
        $sheet->mergeCells('B8:C8');
        $sheet->mergeCells('D8:F8');
        $sheet->mergeCells('H8:J8');
   /*      $sheet->mergeCells('J8:K8'); */

        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

        /*      $sheet->getColumnDimension('A1')->setHeight(10); */
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A8:O8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L5')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L6')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A8:O8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("L5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("L6")->getFont()->setBold(true);
        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('K8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('L8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('M8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('N8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('O8')->applyFromArray($styleArray);


        $sheet->setCellValue('A1', $titulo);
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->setCellValue('L5', 'Desde: '.$desde1);
        $sheet->setCellValue('L6', 'Hasta: '.$hasta1);

        $sheet->setCellValue('A8', 'N.°');
        $sheet->setCellValue('B8', 'Folio');
        $sheet->setCellValue('D8', 'Cliente');
        $sheet->setCellValue('G8', 'Fecha');
        $sheet->setCellValue('H8', 'Producto');
        $sheet->setCellValue('K8', 'Arete');
        $sheet->setCellValue('L8', 'Grapa');
        $sheet->setCellValue('M8', 'Kg');
        $sheet->setCellValue('N8', 'Precio');
        $sheet->setCellValue('O8', 'Subtotal');

        $cellNumber=8;
        $total=0;
        foreach ($ventaInt as $i => $ventaInt) {
            $cellNumber = $cellNumber + 1;
            $i = $i + 1;
            $sub = $ventaInt->subtotal;
            $total = $total + $sub;
            if ($ventaInt->arete == '' || $ventaInt->arete == NULL || $ventaInt->arete == 1 || $ventaInt->arete == 0) {
                $arete = '---';
            } else {
                $arete = $ventaInt->arete;
            }

            if ($ventaInt->grapa == '' || $ventaInt->grapa == NULL || $ventaInt->grapa == 1 || $ventaInt->grapa == 0) {
                $grapa = '---';
            } else {
                $grapa = $ventaInt->grapa;
            }
            
            setlocale(LC_ALL, "es_MX.utf8");
            $fechaT = strftime('%d-%b-%y', strtotime($ventaInt->fecha_venta));

            $sheet->getStyle("A{$cellNumber}:O{$cellNumber}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("D{$cellNumber}")->getAlignment()->setHorizontal('left');
            $sheet->mergeCells("B{$cellNumber}:C{$cellNumber}");
            $sheet->mergeCells("D{$cellNumber}:F{$cellNumber}");
            $sheet->mergeCells("H{$cellNumber}:J{$cellNumber}");

            $sheet->setCellValue("A{$cellNumber}", $i);
            $sheet->setCellValue("B{$cellNumber}", $ventaInt->folio_venta);
            $sheet->setCellValue("D{$cellNumber}", strtoupper($ventaInt->nombre_cliente . ' ' . $ventaInt->apellido_paterno_cliente . ' ' . $ventaInt->apellido_materno_cliente));
            $sheet->setCellValue("G{$cellNumber}", $fechaT);
            $sheet->setCellValue("H{$cellNumber}", $ventaInt->nombre_producto.' '.$ventaInt->raza);
            $sheet->setCellValue("K{$cellNumber}", $arete);
            $sheet->setCellValue("L{$cellNumber}", $grapa);
            $sheet->setCellValue("M{$cellNumber}", $ventaInt->cantidad);
            $sheet->setCellValue("N{$cellNumber}", $ventaInt->precio);
            $sheet->setCellValue("O{$cellNumber}", $ventaInt->subtotal);
        }
        $cellNumber = $cellNumber + 1;
        $sheet->getStyle("K{$cellNumber}:O{$cellNumber}")->getAlignment()->setHorizontal('center');
        $sheet->mergeCells("K{$cellNumber}:M{$cellNumber}");
        $sheet->mergeCells("N{$cellNumber}:O{$cellNumber}");
        $spreadsheet->getActiveSheet()->getStyle("K{$cellNumber}")->getFont()->setBold(true);
        $sheet->setCellValue("K{$cellNumber}", 'Total: ');
        $sheet->setCellValue("N{$cellNumber}", $total);
        $writer = new Xlsx($spreadsheet);


        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename=Reporte_ventas_Rancho_el_arenal-' . time()  . '.xlsx');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }
}
        
    /* End of file  reportes.php */
