<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class Ventas extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
	public function index()
	{
		$data['page'] = 'ventas';
		$data['sales'] = $this->get_sales();
		$data['clientes'] = $this->get_clients();
		$data['products'] = $this->get_products();
		$data['body'] = 'ventas/view';
		$this->load->view('layout/main', $data);
	}
	public function get_pagination_sales()
	{
		$opt = $_POST;
		$limit = $opt["length"];
		$offset = $opt["start"];
		$draw = $opt["draw"];
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . "ventas/api/ventas/limit/$limit/offset/$offset/draw/$draw",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$sales = json_decode($response);
		echo json_encode($sales->data);
	}
	public function get_sales()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'ventas/api/ventas',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$sales = json_decode($response);
		return $sales->data;
	}
    function send_receipt_by_email($ventaId)
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "ventas_internas/api/enviar_recibo_email/ventaId/{$ventaId}",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: REARNL",
				'Content-Type: application/json'
			],
		]);

		$response = curl_exec($curl);

		curl_close($curl);

		redirect('ventas');
	}

	public function get_clients()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'clientes/api/clientes',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$clients = json_decode($response);
		return $clients->data;
	}

	public function get_products()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'productos/api/productos',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL',
				'Content-Type: application/json'
			),
		));
		$response = curl_exec($curl);

		curl_close($curl);
		$products = json_decode($response);
		return $products->data;
	}

	function get_salesForID($id_)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL.'ventas_internas/api/ventas_internas/id/'. $id_,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL'
			),
		));
		$response = curl_exec($curl);
		curl_close($curl);
		$ventasForID = json_decode($response);
		$this->session->set_flashdata('sales_details', array('data' => $ventasForID->data));
		redirect('Ventas');
	}

	function get_productSalesForID($id_)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL.'ventas_internas/api/productSales/id/'. $id_,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL'
			),
		));

		$response = curl_exec($curl);
		curl_close($curl);
		$productSalesForID = json_decode($response);
		var_dump($productSalesForID);
		$id_venta_ = $productSalesForID->data->id_venta;
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL.'ventas_internas/api/ventas_internas/id/'. $id_venta_,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: REARNL'
			),
		));
		$response = curl_exec($curl);
		curl_close($curl);
		$detailsSales_ = json_decode($response);
		$this->session->set_flashdata('salesD_details', array('data' => $detailsSales_->data));
		 $this->session->set_flashdata('productosS_details', array('data' => $productSalesForID->data));
		redirect('Ventas');
	}


	public function exportRegisterExcel()
	{
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
		$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
		$drawing->setName('Logo');
		$drawing->setDescription('Logo');
		$drawing->setPath('assets/img/logo.png'); // put your path and image here
		$drawing->setCoordinates('A1');
		$drawing->setWidthAndHeight(75, 75);
		$drawing->getShadow()->setVisible(false);
		$drawing->getShadow()->setDirection(0);
		$drawing->setWorksheet($spreadsheet->getActiveSheet());
		$spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
		$spreadsheet->getDefaultStyle()->getFont()->setSize(7);
		$sheet->mergeCells('A1:G4');
		$sheet->mergeCells('A5:G6');
		$sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
		$spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
		$sheet->getStyle('A1')->getAlignment()->setVertical('center');
		$sheet->getStyle('P1')->getAlignment()->setVertical('center');
		$sheet->getStyle('M12')->getAlignment()->setVertical('center');
		$sheet->getStyle('P1')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('M11')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('M12')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('P2')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('P2')->getAlignment()->setVertical('center');
		$sheet->getStyle('P2:P6')->getAlignment()->setWrapText(true);
		$sheet->getStyle('M12:O15')->getAlignment()->setWrapText(true);
		$sheet->getStyle('A5')->getAlignment()->setVertical('center');
		$sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
		$sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
		$sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('L5')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('L6')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('Q7')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('U7')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('Q8')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('U8')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('R8')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('V8')->getAlignment()->setHorizontal('center');
		$spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("P1")->getFont()->setSize(14)->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("L5")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("M11")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("Q8")->getFont()->setBold(true);
		$spreadsheet->getActiveSheet()->getStyle("U8")->getFont()->setBold(true);
		$sheet->getStyle('L5:O6')->getAlignment()->setHorizontal('center');
		$sheet->getStyle('L5')->getAlignment()->setVertical('center');
		$styleArray = [
			'borders' => [
				'outline' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
					'color' => ['argb' => '#000'],
				],
				'right' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
					'color' => ['argb' => '#000'],
				],
				'left' => [
					'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
					'color' => ['argb' => '#000'],
				],
			],
		];
		$spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
		$spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
		$spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
		$spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
		$spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
		$spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
		$spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
		$sheet->setCellValue('A1', 'Formato de registro de ventas');
		$sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
		$sheet->getColumnDimension('A')->setWidth(25);
		$sheet->getColumnDimension('B')->setWidth(25);
		$sheet->getColumnDimension('C')->setWidth(25);
		$sheet->getColumnDimension('D')->setWidth(25);
		$sheet->getColumnDimension('E')->setWidth(25);
		$sheet->getColumnDimension('F')->setWidth(25);
		$sheet->getColumnDimension('G')->setWidth(25);
		$sheet->setCellValue('A8', 'N.°');
		$sheet->setCellValue('B8', 'Kilos totales');
		$sheet->setCellValue('C8', 'Precio');
		$sheet->setCellValue('D8', 'Arete');
		$sheet->setCellValue('E8', 'Grapa');
		$sheet->setCellValue('F8', 'Corral');
		$sheet->setCellValue('G8', 'Subtotal');
		$sheet->setCellValue('A9', 1);
		$writer = new Xlsx($spreadsheet);
		$filename = 'formato_registro_ovinos';
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="' . $filename .  date("Ymd") . '.xlsx"');
		header('Cache-Control: max-age=0');
		$writer->save('php://output');
	}



	function readDataSalesRegister($file)
	{
		$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
		$reader->setReadDataOnly(FALSE);
		$spreadsheet = $reader->load($file);
		$sheet = $spreadsheet->getSheet(0);
		$highestRow = $sheet->getHighestRow();

		for ($row = 9; $row <= $highestRow; $row++) {
			$cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
			if ($cellValue) {

				$cantidad = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
				if ($cantidad == 'N/A' || $cantidad == 'n/a') {
					$cantidad = '';
				}
				$precio = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
				if ($precio == 'N/A' || $precio == 'n/a') {
					$precio = '';
				}
				$arete = $spreadsheet->getActiveSheet()->getCell("D{$row}")->getValue();
				if ($arete == 'N/A' || $arete == 'n/a') {
					$corral = '';
				}
				$grapa = $spreadsheet->getActiveSheet()->getCell("E{$row}")->getValue();
				if ($grapa == 'N/A' || $grapa == 'n/a') {
					$grapa = '';
				}
				$corral = $spreadsheet->getActiveSheet()->getCell("F{$row}")->getValue();
				if ($corral == 'N/A' || $corral == 'n/a') {
					$corral = '';
				}
				$subtotal = $spreadsheet->getActiveSheet()->getCell("G{$row}")->getValue();
				if ($subtotal == 'N/A' || $subtotal == 'n/a') {
					$subtotal = '';
				}
				yield array(
					'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
					'cantidad' => $cantidad,
					'precio' => $precio,
					'arete' => $arete,
					'grapa' => $grapa,
					'corral' => $corral,
					'subtotal' => $subtotal
				);
			}
		}
	}
	function importRegisterFormatExcel()
	{
		$id_product_ =$this->input->post('id_prod_');
		$id_cliente = $this->input->post('id_cliente_');
		$fecha_ = $this->input->post('fecha_');
		
		$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

		if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
			$arr_file = explode('.', $_FILES['registerFormat']['name']);
			$extension = end($arr_file);
			$file = $_FILES['registerFormat']['tmp_name'];
			$dataSales = $this->readDataSalesRegister($file);
			$created_user = $this->session->userdata('user_admin_sess')->fullname;
			$data = [];

			foreach ($dataSales as $key => $value) {

				$data[] = array(
					'id_venta' => "Ovino",
					'arete' => $value['arete'],
					'grapa' => $value['grapa'],
					'corral' => $value['corral'],
					
					'cantidad' => $value['cantidad'],
					"precio" => $value['precio'],
					"subtotal" => $value['subtotal'],
				);

				$venta_ = array(
					'id_cliente' =>$id_cliente,
					'fecha' => $fecha_,
					'id_producto' => $id_product_,
					'productos' => $data
				);

			}

			$data_to_string = json_encode($venta_);

			var_dump($data_to_string);
			$curl_request = curl_init(API_URL . "ventas_internas/api/ventas_Excel1");

			curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
			curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json',
				'x-api-key: QroSystem%21#'
			));
			curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
			curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
			$response = curl_exec($curl_request);

			if (!$response) {
				$response = json_encode(array(
					"status" => "error",
					"message" => curl_errno($curl_request)
				));
				echo var_dump($response);
			}
			curl_close($curl_request);
			$response = json_decode($response);
		}

		if ($response->status == 'error') {
			var_dump($response->status);
			// $this->session->set_flashdata('error', array('message' => $response->message, 'validations' => $response->validations));
			// redirect('Ventas');
		} else {
			var_dump($response->status."no jala");
			// redirect('Ventas');
		}
	}



}
