<?php
if (@$this->session->flashdata('categoria_info')) {
    $categoria_info = $this->session->flashdata('categoria_info')['data'];
} ?>
<div class="content-wrapper">
    <div id="show_loading"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Categorias</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <button type="button" id="create_button" name="button" data-toggle="modal" data-target="#categoria_modal" class="btn btn-primary btn-sm"><i style="color:aliceblue" class="fas fa-plus-square"> </i> Nuevo</button>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <div class="table-responsive">
                                <table id="categorias_table" class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th><?php echo ('#') ?></th>
                                            <th><?php echo ('Nombre') ?></th>
                                            <th><?php echo ('Opciones') ?> </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($categories as $i => $category) { ?>
                                            <?php if ($category->status == 1) { ?>
                                                <tr>
                                                    <td><?= $i + 1 ?></td>
                                                    <td><?= $category->nombre_categoria; ?></td>
                                                    <td>
                                                        <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                                            Acción <span class="caret"></span>
                                                        </button>
                                                        <lu class="dropdown-menu dropdown-default pull-right" aria-labelledby="dropdownMenuLink">
                                                            <li>
                                                                <a type="button" class="dropdown-item btn-edit" href="<?= base_url('index.php/categorias/get_category_by_id/' . $category->id_categoria) ?>"><i class="fa fa-pen"></i> Editar</a>
                                                            </li>
                                                            <div class="dropdown-divider"></div>
                                                            <li>
                                                                <a type="button" class="dropdown-item" onclick="eliminar_categoria(<?= $category->id_categoria ?>)"><i class="fa fa-trash-alt"></i> Eliminar</a>
                                                            </li>
                                                        </lu>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
</div>
<!-- Modal -->
<?php include APPPATH . 'views/modals/categorias/nueva_categoria.php'; ?>
<?php include APPPATH . 'views/scripts/categorias.php'; ?>