<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Rancho el arenal | Ventas</title>

  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Tempusdominus Bbootstrap 4 -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- JQVMap -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/jqvmap/jqvmap.min.css">
  <!-- Theme style -->

  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/daterangepicker/daterangepicker.css">
  <!-- summernote -->
  <link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/summernote/summernote-bs4.css">
  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">


            <h1 class="m-0 text-dark">Dashboard</h1>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-secondary">
              <div class="inner">
                <h3><?= $widgets->total_pedidos ?></h3>
                <p>Pedidos</p>
              </div>
              <div class="icon">
                <i class="fas fa-shipping-fast"></i>
              </div>
              <a href="<?php echo site_url('pedidos'); ?>" class="small-box-footer">Más información <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                <h3><?= $widgets->total_ventas ?></h3>
                <p>Ventas</p>
              </div>
              <div class="icon">
                <i class="fas fa-file-invoice-dollar"></i>
              </div>
              <a href="<?php echo site_url('ventas'); ?>" class="small-box-footer">Más información <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-primary">
              <div class="inner">
                <h3><?= $widgets->total_clientes ?></h3>
                <p>Clientes</p>
              </div>
              <div class="icon">
                <i class="fas fa-user-friends"></i>
              </div>
              <a href="<?php echo site_url('clientes'); ?>" class="small-box-footer">Más información <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3><?= $widgets->total_productos ?></h3>
                <p>Productos</p>
              </div>
              <div class="icon">
                <i class="fas fa-cart-arrow-down"></i>
              </div>
              <a href="<?php echo site_url('productos'); ?>" class="small-box-footer">Más información <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>

          <!-- /.col -->
        </div>
        <div class="d-flex justify-content-center mb-2 ">
          <div class="form-row">
            <div class="form-group col-md-auto">
              <label for="year_field">Año</label>
              <select name="year_field" id="year_field" class="form-control">
                <option value="all" selected>Todo</option>
                <?php foreach ($years as $year) { ?>
                  <option value="<?= $year->year ?>"><?= $year->year ?></option>
                <?php } ?>
              </select>
            </div>
            <div class="form-group col-md-auto">
              <label for="month_field">Mes</label>
              <select name="month_field" id="month_field" class="form-control">
                <option value="all" selected>Todo</option>
                <option value="1">Enero</option>
                <option value="2">Febrero</option>
                <option value="3">Marzo</option>
                <option value="4">Abril</option>
                <option value="5">Mayo</option>
                <option value="6">Junio</option>
                <option value="7">Julio</option>
                <option value="8">Agosto</option>
                <option value="9">Septiembre</option>
                <option value="10">Octubre</option>
                <option value="11">Noviembre</option>
                <option value="12">Diciembre</option>
              </select>
            </div>
            <div class="form-group col-md-auto">
              <label for="category_field">Categorias</label>
              <select name="category_field" id="category_field" class="form-control">
                <option value="all" selected>Todo</option>
                <?php foreach ($categorias as $categoria) { ?>
                  <option value="<?= $categoria->id_categoria; ?>"><?= $categoria->nombre_categoria ?></option>
                <?php } ?>
              </select>
            </div>
            <div class="form-group col-md-auto" id="productoTag">
              <label for="product_field">Productos</label>
              <select name="product_field" id="product_field" class="form-control">
                <option value="all" selected>Todo</option>
              </select>
            </div>
            <div class="form-group col-md-auto">
              <label for="client_field">Cliente</label>
              <select name="client_field" id="client_field" class="form-control">
                <option value="all" selected>Todo</option>
                <?php foreach ($clientes as $cliente) { ?>
                  <option value="<?= $cliente->id_cliente1; ?>"><?= $cliente->nombre_completo ?></option>
                <?php } ?>
              </select>
            </div>
            <div class="col-md-auto align-self-center mt-3">
              <button type="button" class="btn btn-outline-primary btn-sm" id="btn-filter"><i class="bi bi-search"></i></button>
              <button type="button" class="btn btn-outline-danger btn-sm" id="btn-cancel" style="display: none;"><i class="fas fa-redo"></i></button>
              <img style="width:80px; display: none;" id="loader" src="<?php echo base_url('assets/img/loader.gif') ?>" />
            </div>
          </div>


        </div>
        <div class="d-flex justify-content-center">

          <div class="d-flex justify-content-center">
            <div class="row text-center" id="cards-products-sales">
              <!--      <div id="cards-products-sales"> -->
              <?php $total = 0;
              foreach ($totalVentasPorProductos as $venta) {
                $total = $total + $venta->total_venta; ?>
                <div class="col-md-auto">
                  <div class="info-box mb-3 bg-gray">
                    <span class="info-box-icon"><i class="bi bi-currency-dollar"></i></span>
                    <div class="info-box-content">
                      <span class="info-box-text text-uppercase"><?= $venta->nombre_producto ?></span>
                      <span class="info-box-number"><?= number_format($venta->total_venta, 2, '.', ',') ?></span>
                    </div>
                  </div>
                </div>
              <?php } ?>
              <!--  </div> -->
              <div class="col-md-auto">
                <div class="info-box mb-3 bg-primary">
                  <span class="info-box-icon"><i class="bi bi-cash-coin"></i></span>
                  <div class="info-box-content">
                    <span class="info-box-text text-uppercase"><b>Total venta</b></span>
                    <span class="info-box-number" id="total-sale"><?= number_format($total, 2, '.', ',') ?></span>
                  </div>
                </div>
                <!-- /.info-box-content -->
              </div>
            </div>

          </div>

        </div>
        <div class="row">
          <section class="col-md-8 connectedSortable">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title">
                  <i class="fas fa-chart-line mr-1"></i>
                  Ventas
                </h3>

                <div class="card-tools">
                  <button type="button" class="btn bg-light btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>

                </div>
              </div>
              <div class="card-body">
                <!-- Aqui grafico -->
                <div id="salesChart"></div>
              </div>
            </div>
          </section>
          <section class="col-md-4 connectedSortable">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title">
                  <i class="fas fa-chart-pie mr-1"></i>
                  Ventas por producto
                </h3>

                <div class="card-tools">
                  <button type="button" class="btn bg-light btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>

                </div>
              </div>
              <div class="card-body">
                <!-- Aqui grafico -->
                <div id="salesByProductChart"></div>
              </div>
            </div>
          </section>
        </div>
        <div class="row">
          <section class="col-md-6 connectedSortable">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title"> <i class="fas fa-clipboard-list mr-1"></i>Productos</h3>
                <div class="card-tools">
                  <button type="button" class="btn bg-light btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>

                </div>
              </div>
              <div class="card-body table-responsive p-0">
                <table class="table table-striped table-valign-middle">
                  <thead>
                    <tr>
                      <th>Categoria</th>
                      <th>Producto</th>
                      <th>Total</th>
                      <th>Ventas</th>
                    </tr>
                  </thead>
                  <tbody id="products-sales-table">
                    <?php foreach ($productos as $producto) { ?>
                      <tr>
                        <td><?= $producto->categoria ?></td>
                        <td>
                          <img src="<?= API_DOCS_URL . $producto->imagen ?>" alt="Producto 1" style="width:32px; height:32px" class="img-circle img-size-32 mr-2">
                          <?= $producto->nombre_producto . ' ' . $producto->raza ?>
                        </td>
                        <td>$<?= number_format($producto->total_venta, '2', '.', ',') ?> MXN</td>
                        <td>
                          <small class="text-success mr-1">
                            <i class="fas fa-arrow-up"></i>
                          </small>
                          <?= number_format($producto->numero_ventas, 0, '.', ',') ?> Vendidos
                        </td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          </section>
          <section class="col-md-6 connectedSortable">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title"> <i class="fas fa-users mr-1"></i>Clientes frecuentes</h3>
                <div class="card-tools">
                  <div class="btn-group">
                    <button type="button" class="btn btn-light btn-sm dropdown-toggle" data-toggle="dropdown" data-offset="-52" aria-expanded="false">
                      <i class="fas fa-bars"></i></button>
                    <div class="dropdown-menu" role="menu">
                      <a onclick="verClientesFrecuentesPorCantidad()" class="dropdown-item"><i class="bi bi-cash-coin"></i> Por cantidad </a>
                      <a onclick="verClientesFrecuentes()" class="dropdown-item"><i class="bi bi-calendar2-check"></i> Por N° veces</a>
                    </div>
                  </div>
                  <button type="button" class="btn bg-light btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>

                </div>
              </div>
              <div class="card-body table-responsive p-0">
                <!-- clientesFrecuentesPorTotal -->
                <table class="table table-striped table-valign-middle" style="display: none" id="cli-frec-cant-mon-table">
                  <thead>
                    <tr>
                      <th>Nombre</th>
                      <th>Total de compra</th>
                      <th>Producto</th>
                    </tr>
                  </thead>
                  <tbody id="frequent-clients-by-cash">
                    <?php foreach ($clientesFrecuentesPorTotal as $cliente) { ?>
                      <tr>
                        <td>
                          <img src="<?= base_url() ?>assets/img/cliente.png" alt="Producto 1" class="img-circle img-size-32 mr-2">
                          <?= $cliente->cliente; ?>
                        </td>
                        <td>
                          $<?= number_format($cliente->total_compra, 0, '.', ',') ?> MXN
                        </td>
                        <td><?= $cliente->nombre_producto . ' ' . $cliente->raza ?></td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
                <table class="table table-striped table-valign-middle" id="cli-frec-table">
                  <thead>
                    <tr>
                      <th>Nombre</th>
                      <th>Compras</th>
                      <th>Producto</th>
                    </tr>
                  </thead>
                  <tbody id="frequent-clients-by-qty">
                    <?php foreach ($clientesFrecuentes as $cliente) { ?>
                      <tr>
                        <td>
                          <img src="<?= base_url() ?>assets/img/cliente.png" alt="Producto 1" class="img-circle img-size-32 mr-2">
                          <?= $cliente->cliente; ?>
                        </td>
                        <td>
                          <?= number_format($cliente->numero_compras, 0, '.', ',') ?> Compras
                        </td>
                        <td><?= $cliente->nombre_producto . ' ' . $cliente->raza ?></td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          </section>
        </div>
         <div class="row">
          <section class="col-md-12 connectedSortable">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title">
                  <i class="fas fa-chart-line mr-1"></i>
                  Grafico comparativo de precios en el mercado
                </h3>

                <div class="card-tools">
                  <button type="button" class="btn bg-light btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>

                </div>
              </div>
              
               <div class="text-center">
                  <small><b>Busqueda avanzada</b></small>
                </div>
                <div class="form-row">
                  <div class="form-group col-md-4">
                  </div>
                  <div class="form-group col-md-3">
                    <label for="">Mostrar por</label>
                    <select name="products" id="products" class="form-control form-control-sm">
                      <option value="" disabled selected>-- Producto --</option>
                      <?php foreach ($products as $product) { ?>
                        <option value="<?= $product->id_producto; ?>"><?= $product->nombre_producto; ?></option>
                      <?php } ?>
                    </select>
                  </div>
                </div>
              <div class="card-body">
                <!-- Aqui grafico -->
                <!--    <div id="salesChart"></div> -->
                <div id="comparingPricesFishChart"></div>
              </div>
            </div>
          </section>
        </div>
        <div class="row">
          <section class="col-md-12 connectedSortable">
            <!-- Custom tabs (Charts with tabs)-->
            <div class="card">
              <div class="card-header border-0">
                <h3 class="card-title">
                  <i class="fas fa-th mr-1"></i>
                  Ventas Realizadas
                </h3>

                <div class="card-tools">
                  <button type="button" class="btn bg-light btn-sm" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                  </button>

                </div>
              </div>
              <div class="card-body">
                <canvas class="chart" id="line-chart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
              </div>
              <div class="card-footer">
                <div class="row">
                  <div class="col-sm-6 col-6">
                    <div class="description-block border-right">
                      <!--   <span class="description-percentage text-success"><i class="fas fa-caret-up"></i> 17%</span> -->
                      <h5 class="description-header">$ <?= number_format($balancePez, 2, '.', ',') ?></h5>
                      <span class="description-text">VENTAS PESCADO </span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-6 col-6">
                    <div class="description-block border-right">
                      <!-- <span class="description-percentage text-warning"><i class="fas fa-caret-left"></i> 0%</span> -->
                      <h5 class="description-header">$ <?= number_format($balanceBorre, 2, '.', ','); ?></h5>
                      <span class="description-text">VENTAS BORREGO </span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->

                  <!-- /.col -->

                </div>
                <!-- /.row -->
              </div>

            </div>
          </section>
        </div>
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>

  <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>
  <!-- jQuery UI 1.11.4 -->
  <!-- <script src="<?= base_url(); ?>assets/plugins/jquery-ui/jquery-ui.min.js"></script> -->
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->


  <!-- Bootstrap 4 -->

  <!-- ChartJS -->
  <script src="<?= base_url(); ?>assets/plugins/chart.js/Chart.min.js"></script>
  <!-- Sparkline -->
  <script src="<?= base_url(); ?>assets/plugins/sparklines/sparkline.js"></script>
  <!-- JQVMap -->
  <script src="<?= base_url(); ?>assets/plugins/jqvmap/jquery.vmap.min.js"></script>
  <script src="<?= base_url(); ?>assets/plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
  <!-- jQuery Knob Chart -->
  <script src="<?= base_url(); ?>assets/plugins/jquery-knob/jquery.knob.min.js"></script>
  <!-- daterangepicker -->
  <script src="<?= base_url(); ?>assets/plugins/moment/moment.min.js"></script>
  <script src="https://momentjs.com/downloads/moment-with-locales.min.js"></script>
  <script src="<?= base_url(); ?>assets/plugins/daterangepicker/daterangepicker.js"></script>
  <!-- Tempusdominus Bootstrap 4 -->
  <script src="<?= base_url(); ?>assets/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
  <!-- Summernote -->
  <script src="<?= base_url(); ?>assets/plugins/summernote/summernote-bs4.min.js"></script>
  <!-- overlayScrollbars -->
  <script src="<?= base_url(); ?>assets/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
  <!-- AdminLTE App -->
  <script src="<?= base_url(); ?>assets/dist/js/adminlte.js"></script>
  <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
  <!-- <script src="<?= base_url(); ?>assets/dist/js/pages/dashboard.js"></script> -->
  <!-- AdminLTE for demo purposes -->
  <script src="<?= base_url(); ?>assets/dist/js/demo.js"></script>

  <script>
    $("#btn-cancel").click(function(e) {
      e.preventDefault();
      location.reload();
      $("#loader").show();
    });
    $("#btn-filter").click(function(e) {
      e.preventDefault();
      $("#loader").show();
      _year = $("#year_field").val();
      _month = $("#month_field").val();
      _category = $("#category_field").val();
      _product = $("#product_field").val();
      _client = $("#client_field").val();

      if (_year == 'all' && _month == 'all' && _category == 'all' && _product == 'all' && _client == 'all') {
        location.reload();
      } else {
        $.ajax({
          method: "GET",
          url: "<?= API_URL ?>dashboard/api/customQuerySales1/year/" + _year + "/month/" + _month + "/category/" + _category + "/product/" + _product + "/client/" + _client,
          headers: {
            "X-API-KEY": "REARNL"
          },
          success: function(response) {
            $("#loader").hide();
            $("#btn-cancel").show();
            const sales = [
              ['label', 'Ene.', 'Feb.', 'Mar.', 'Abr.', 'May.', 'Jun.', 'Jul.', 'Ago.', 'Sept.', 'Oct.', 'Nov.', 'Dic.']
            ]
            const salesByProduct = []
            $.each(response.data.sales, function(i, venta) {
              sales.push([venta.year, venta.total_enero, venta.total_febrero,
                venta.total_marzo, venta.total_abril, venta.total_mayo,
                venta.total_junio, venta.total_julio, venta.total_agosto,
                venta.total_septiembre, venta.total_octubre, venta.total_noviembre,
                venta.total_diciembre
              ])
            labelsForm= "'"+venta.year+"'";  
            })
            $.each(response.data.salesByProduct, function(i, value) {
              salesByProduct.push([value.nombre_producto, value.total_venta])

            })
            salesCustomChart(sales,labelsForm);
            salesByProductCustomChart(salesByProduct);
            productsSalesCustomTable(response.data.productsSales);
            totalCashByProductsCustomCards(response.data.salesByProduct);
            frequentClientsByCashCustomTable(response.data.frecuentCustomersByQtyCash);
            frequentClientsByQtyCustomTable(response.data.frecuentCustomers)
          }
        });

      }

    });

    function frequentClientsByQtyCustomTable(sales) {

      $("#frequent-clients-by-qty").html('')
      $.each(sales, function(i, value) {
        $("#frequent-clients-by-qty").append('<tr><td>' +
          '<img src="<?= base_url() ?>assets/img/cliente.png" alt="Producto 1" class="img-circle img-size-32 mr-2">' +
          value.cliente + '</td><td>' + value.numero_compras + ' Compras</td>' +
          '<td>' + value.nombre_producto + ' ' + value.raza + '</td></tr>');
      })
    }

    function frequentClientsByCashCustomTable(sales) {
      $("#frequent-clients-by-cash").html('')
      $.each(sales, function(i, value) {
        $("#frequent-clients-by-cash").append('<tr><td>' +
          '<img src="<?= base_url() ?>assets/img/cliente.png" alt="Producto 1" class="img-circle img-size-32 mr-2">' +
          value.cliente + '</td><td>$' + new Intl.NumberFormat().format(value.total_compra) + ' MXN</td>' +
          '<td>' + value.nombre_producto + ' ' + value.raza + '</td></tr>');
      })
    }

    function totalCashByProductsCustomCards(sales) {
      $("#cards-products-sales").html('');
      totalSales = 0.00
      $.each(sales, function(i, value) {
        totalSales += parseFloat(value.total_venta);
        $("#cards-products-sales").append('<div class="col-md-auto">' +
          '<div class="info-box mb-3 bg-gray">' +
          '<span class="info-box-icon"><i class="bi bi-currency-dollar"></i></span>' +
          '<div class="info-box-content">' +
          '<span class="info-box-text text-uppercase">' + value.nombre_producto + '</span>' +
          '<span class="info-box-number">' + new Intl.NumberFormat().format(value.total_venta) + '</span>' +
          '</div>' +
          '</div>' +
          '</div>')
      })
      $("#cards-products-sales").append('<div class="col-md-auto">' +
        '<div class="info-box mb-3 bg-primary">' +
        '<span class="info-box-icon"><i class="bi bi-cash-coin"></i></span>' +
        '<div class="info-box-content">' +
        '<span class="info-box-text text-uppercase"><b>Total venta</b></span>' +
        '<span class="info-box-number" id="total-sale">' + new Intl.NumberFormat().format(totalSales) + '</span>' +
        '</div>' +
        '</div>' +
        '</div>')
    }

    function productsSalesCustomTable(products) {
      $("#products-sales-table").html('');
      $.each(products, function(i, value) {
        $("#products-sales-table").append('<tr>' +
          '<td>' + value.categoria + '</td>' +
          '<td><img src="<?= API_DOCS_URL ?>' + value.imagen + '" style="width:32px; height:32px" class="img-circle img-size-32 mr-2">' +
          value.nombre_producto + ' ' + value.raza + '</td>' +
          '<td>$' + new Intl.NumberFormat().format(value.total_venta) + ' MXN</td>' +
          '<td><small class="text-success mr-1"><i class="fas fa-arrow-up"></i></small>' +
          value.numero_ventas + ' Vendidos</td></tr>')
      })
    }

    function salesByProductCustomChart(sales) {
      c3.generate({
        bindto: "#salesByProductChart",
        data: {
          columns: sales,
          type: 'donut',
          onclick: function(d, i) {
            /* console.log("onclick", d, i); */
          },
          onmouseover: function(d, i) {
            /* console.log("onmouseover", d, i); */
          },
          onmouseout: function(d, i) {
            /*  console.log("onmouseout", d, i); */
          }
        }
      })
    }

    function salesCustomChart(sales, labelsConf) {
      c3.generate({
        bindto: "#salesChart",
        data: {
            labels: {
                labelsConf: d3.format("$,")
          },
          x: 'label',
          columns: sales
        },
        axis: {
          y: {
            show: true,
            label: {
              text: 'Total $',
              position: 'outer-middle'
            },
            tick: {
              format: d3.format("$,")
            }
          },
          x: {
            show: true,
            type: 'category',
            label: {
              text: 'Mes',
              position: 'inner-center'
            }
          }
        },
        grid: {
          x: {
            show: true
          },
          y: {
            show: false
          }
        }
      });
    }

    function verClientesFrecuentesPorCantidad() {
      $("#cli-frec-cant-mon-table").show();
      $("#cli-frec-table").hide();
    }

    function verClientesFrecuentes() {
      $("#cli-frec-cant-mon-table").hide();
      $("#cli-frec-table").show();
    }
    $(document).ready(function() {
        showSalesChart();
        showMarketPriceFishChart();
      function showSalesChart() {
        c3.generate({
          bindto: "#salesChart",
          data: {
               labels: {
              format: { 
                <?php foreach ($totalVentasGeneral as $venta) { ?>
                  '<?= $venta->year ?>' : d3.format("$,"),
              <?php } ?>
                
              }
            },
            x: 'label',
            columns: [
              ['label', 'Ene.', 'Feb.', 'Mar.', 'Abr.', 'May.', 'Jun.', 'Jul.', 'Ago.', 'Sept.', 'Oct.', 'Nov.', 'Dic.'],
              <?php foreach ($totalVentasGeneral as $venta) { ?>['<?= $venta->year ?>', <?= $venta->total_enero ?>, <?= $venta->total_febrero ?>,
                  <?= $venta->total_marzo ?>, <?= $venta->total_abril ?>, <?= $venta->total_mayo ?>,
                  <?= $venta->total_junio ?>, <?= $venta->total_julio ?>, <?= $venta->total_agosto ?>,
                  <?= $venta->total_septiembre ?>, <?= $venta->total_octubre ?>, <?= $venta->total_noviembre ?>,
                  <?= $venta->total_diciembre ?>],
              <?php } ?>
            ]
          },
          axis: {
            y: {
              show: true,
              label: {
                text: 'Total $',
                position: 'outer-middle'
              },
              tick: {
                format: d3.format("$,")
              }
            },
            x: {
              show: true,
              type: 'category',
              label: {
                text: 'Mes',
                position: 'inner-center'
              }
            }
          },
          grid: {
            x: {
              show: true
            },
            y: {
              show: false
            }
          }
        });
      }
          function showMarketPriceFishChart() {
        c3.generate({
          bindto: "#comparingPricesFishChart",
          data: {
            x: 'label',
            columns: [
              ['label', 'Ene.', 'Feb.', 'Mar.', 'Abr.', 'May.', 'Jun.', 'Jul.', 'Ago.', 'Sept.', 'Oct.', 'Nov.', 'Dic.'],
              ['Precio promedio en venta', <?= ($precioPorVentasPescado->total_enero) ? round($precioPorVentasPescado->total_enero) : 0  ?>, <?= ($precioPorVentasPescado->total_febrero) ? round($precioPorVentasPescado->total_febrero) : 0 ?>,
                <?= ($precioPorVentasPescado->total_marzo) ? round($precioPorVentasPescado->total_marzo) : 0 ?>, <?= ($precioPorVentasPescado->total_abril) ? round($precioPorVentasPescado->total_abril) : 0 ?>, <?= ($precioPorVentasPescado->total_mayo) ? round($precioPorVentasPescado->total_mayo) : 0 ?>,
                <?= ($precioPorVentasPescado->total_junio) ? round($precioPorVentasPescado->total_junio) : 0 ?>, <?= ($precioPorVentasPescado->total_julio) ? round($precioPorVentasPescado->total_julio) : 0 ?>, <?= ($precioPorVentasPescado->total_agosto) ? round($precioPorVentasPescado->total_agosto) : 0 ?>,
                <?= ($precioPorVentasPescado->total_septiembre) ? round($precioPorVentasPescado->total_septiembre) : 0 ?>, <?= ($precioPorVentasPescado->total_octubre) ? round($precioPorVentasPescado->total_octubre) : 0 ?>, <?= ($precioPorVentasPescado->total_noviembre) ? round($precioPorVentasPescado->total_noviembre) : 0 ?>,
                <?= ($precioPorVentasPescado->total_diciembre) ? round($precioPorVentasPescado->total_diciembre) : 0 ?>
              ],
              ['Precio promedio en el mercado', <?= ($precioMercadoPescado->total_enero) ? round($precioMercadoPescado->total_enero) : 0  ?>, <?= ($precioMercadoPescado->total_febrero) ? round($precioMercadoPescado->total_febrero) : 0 ?>,
                <?= ($precioMercadoPescado->total_marzo) ? round($precioMercadoPescado->total_marzo) : 0 ?>, <?= ($precioMercadoPescado->total_abril) ? round($precioMercadoPescado->total_abril) : 0 ?>, <?= ($precioMercadoPescado->total_mayo) ? round($precioMercadoPescado->total_mayo) : 0 ?>,
                <?= ($precioMercadoPescado->total_junio) ? round($precioMercadoPescado->total_junio) : 0 ?>, <?= ($precioMercadoPescado->total_julio) ? round($precioMercadoPescado->total_julio) : 0 ?>, <?= ($precioMercadoPescado->total_agosto) ? round($precioMercadoPescado->total_agosto) : 0 ?>,
                <?= ($precioMercadoPescado->total_septiembre) ? round($precioMercadoPescado->total_septiembre) : 0 ?>, <?= ($precioMercadoPescado->total_octubre) ? round($precioMercadoPescado->total_octubre) : 0 ?>, <?= ($precioMercadoPescado->total_noviembre) ? round($precioMercadoPescado->total_noviembre) : 0 ?>,
                <?= ($precioMercadoPescado->total_diciembre) ? round($precioMercadoPescado->total_diciembre) : 0 ?>
              ]

            ],
            colors: {
            'Precio promedio en venta': '#1925F5',
            'Precio promedio en el mercado': '#ff0000'
        }
          },
          axis: {
            y: {
              show: true,
              label: {
                text: 'Precios de venta $',
                position: 'outer-middle'
              },
              tick: {
                format: d3.format("$,")
              }
            },
            x: {
              show: true,
              type: 'category',
              label: {
                text: 'Mes',
                position: 'inner-center'
              }
            }
          },
          grid: {
            x: {
              show: true
            },
            y: {
              show: true
            }
          }
        });
      }

      c3.generate({
        bindto: "#salesByProductChart",
        data: {
          // iris data from R
          columns: [
            <?php foreach ($totalVentasPorProductos as $venta) { ?>["<?= $venta->nombre_producto ?>", <?= $venta->total_venta; ?>],
            <?php } ?>
          ],
          type: 'donut',
          onclick: function(d, i) {
            /*  console.log("onclick", d, i); */
          },
          onmouseover: function(d, i) {
            /* console.log("onmouseover", d, i); */
          },
          onmouseout: function(d, i) {
            /* console.log("onmouseout", d, i); */
          }
        }
      });



      $("#category_field").on("change", function() {
        $("#productoTag")
        var ajax_load = '<img style="width:80px;" src="<?php echo base_url('assets/img/loader.gif') ?>"/>';
        $('#productoTag').html(ajax_load);
        categoria = $(this).val();
        if (categoria == 'all') {
          $("#productoTag").html('<label for="product_field">Productos</label><select name="product_field" id="product_field" class="form-control">' +
            '<option value="all" selected>Todo</option> </select>');
        } else {
          $.ajax({
            method: "POST",
            url: "<?= base_url(); ?>index.php/home/obtenerProductosPorCategoria/" + categoria,
            dataType: "JSON",
            success: function(response) {
              response = JSON.parse(response);
              console.log(response.data)

              $("#productoTag").html('<label for="product_field">Productos</label><select name="product_field" id="product_field" class="form-control">' +
                '<option value="all" selected>Todo</option> </select>');
              $.each(response.data, function(i, value) {
                $("#product_field").append('<option value="' + value.id_producto + '">' + value.nombre_producto + ' ' + value.raza + '</option>')
              });
            }
          });
        }

      })
    });
    $(function() {


      moment.locale('es-mx');
      month = moment().format('MMMM');
      $("#month").html(month)
      var newDate = (days) => {
        return moment().add(days, 'd').toDate();
      }
      counterDays = moment().daysInMonth();
      const startOfMonth = moment().clone().startOf('month').format();
      var currDate = moment();
      var dateToTest = moment(startOfMonth);
      var result = currDate.diff(dateToTest, 'days') + 1
      const days = [];
      const dataNum = []
      for (let i = 1; i <= result; i++) {
        x = i - result
        y = i + 5;
        /*  console.log(moment(newDate(x)).format('ddd DD')) */
        days.push(moment(newDate(x)).format('ddd DD'))
        dataNum.push(y)
      }

      const totales = []
      <?php foreach ($ventas_dia as $ventas_dia) { ?>
        totales.push(<?= $ventas_dia ?>);
      <?php } ?>

      const totalesborre = []
      <?php foreach ($ventas_ovinos as $ventas_ovinos) { ?>
        totalesborre.push(<?= $ventas_ovinos ?>);
      <?php } ?>

      /*  console.log(totalesborre); */



      var salesGraphChartCanvas = $('#line-chart').get(0).getContext('2d');
      var salesGraphChartData = {
        labels: days,
        datasets: [{
            label: 'Ventas pescado',
            fill: false,
            borderWidth: 2,
            lineTension: 0,
            spanGaps: true,
            borderColor: '#d2d6de',
            pointRadius: 3,
            pointHoverRadius: 7,
            pointColor: '#000',
            pointBackgroundColor: '#000',
            data: totales
          },
          {
            label: 'Ventas borregos',
            fill: false,
            borderWidth: 2,
            lineTension: 0,
            spanGaps: true,
            borderColor: '#4f98c3',
            pointRadius: 3,
            pointHoverRadius: 7,
            pointColor: '#517BFF',
            pointBackgroundColor: '#517BFF',
            data: totalesborre
          }

        ]
      }
      var salesGraphChartOptions = {
        maintainAspectRatio: false,
        responsive: true,
        tooltips: {
          callbacks: {
            label: function(tooltipItem, data) {
              var label = data.datasets[tooltipItem.datasetIndex].label || '';
              if (label) {
                label += ': $';
              }
              label += new Intl.NumberFormat().format(tooltipItem.value);
              return label
            }
          }
        },
        legend: {
          display: true,
          labels: {
            fontColor: 'rgb(255, 99, 132)'
          }
        },
        scales: {
          xAxes: [{
            ticks: {
              /*     fontColor: '#000', */
            },
            gridLines: {
              display: true,
              position: 'bottom',
              /*       color: '#000', */
              drawBorder: false,
            }
          }],
          yAxes: [{
            ticks: {
              beginAtZero: true,
              min: 0,
              suggestedMin: 0,
              callback: function(value, index, values) {
                return '$' + new Intl.NumberFormat().format(value);
              },
              stepSize: 0
            },
            gridLines: {
              display: true,
              position: 'bottom',
              /* color: '#000', */
              drawBorder: false,
            }
          }]
        }
      }
      var salesGraphChartOptions = {
        maintainAspectRatio: false,
        responsive: true,
        tooltips: {
          callbacks: {
            label: function(tooltipItem, data) {
              var label = data.datasets[tooltipItem.datasetIndex].label || '';
              if (label) {
                label += ': $';
              }
              label += new Intl.NumberFormat().format(tooltipItem.value);
              return label
            }
          }
        },

        legend: {
          display: true
        },
        scales: {
          xAxes: [{
            gridLines: {
              display: false,
              drawBorder: true,
            }
          }],
          yAxes: [{
            ticks: {
              beginAtZero: true,
              min: 0,
              suggestedMin: 0,
              callback: function(value, index, values) {
                return '$' + new Intl.NumberFormat().format(value);
              },
              stepSize: 0,
            },
            gridLines: {
              display: true,
              drawBorder: false,
            }
          }]
        }
      }

      var salesGraphChart = new Chart(salesGraphChartCanvas, {
        type: 'line',
        data: salesGraphChartData,
        options: salesGraphChartOptions
      });

    });
    
    
    
      $("#products").on("change", function() {
      idP = $("#products").val();
      $.ajax({
        method: "POST",
        url: "<?= base_url() ?>index.php/Home/customComparative",
        data: {
          'idP': idP,
        },
        dataType: "JSON",
        success: function(response) {
          data = response['data']
           const marketPrice = ['Precio promedio en el mercado ']
          const salesPrice = ['Precio promedio en venta']
          for (const i in data.marketPrice[0]) {
            if (data.marketPrice[0][i] == null) {
              marketPrice.push(0)
            } else {
              marketPrice.push(new Intl.NumberFormat('en-IN', {maximumSignificantDigits: 2}).format(data.marketPrice[0][i]))
            }

          }
          for (const i in data.salesPrice[0]) {
            if (data.salesPrice[0][i] == null) {
              salesPrice.push(0)
            } else {
              salesPrice.push(new Intl.NumberFormat('en-IN', {maximumSignificantDigits: 2}).format(data.salesPrice[0][i]))
            }

          }
          c3.generate({
            bindto: "#comparingPricesFishChart",
            data: {
              x: 'label',
              columns: [
                ['label', 'Ene.', 'Feb.', 'Mar.', 'Abr.', 'May.', 'Jun.', 'Jul.', 'Ago.', 'Sept.', 'Oct.', 'Nov.', 'Dic.'],
                marketPrice,
                salesPrice

              ],
              colors: {
                 'Precio promedio en el mercado ': '#1925F5',
                'Precio promedio en venta': '#ff0000'
              }
            },
            axis: {
              y: {
                show: true,
                label: {
                  text: 'Precios de venta $',
                  position: 'outer-middle'
                },
                tick: {
                  format: d3.format("$,")
                }
              },
              x: {
                show: true,
                type: 'category',
                label: {
                  text: 'Mes',
                  position: 'inner-center'
                }
              }
            },
            grid: {
              x: {
                show: true
              },
              y: {
                show: true
              }
            }
          });


        }
      });
    });
  </script>
</body>

</html>