<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Rancho el arenal | Login</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/dist/css/adminlte.min.css">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .loading {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(5, 4, 45, .2);
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 9999;
      transition: 1s all;
      opacity: 0;
    }

    .loading.show {
      opacity: 1;
    }

    .loading .spin {
      border: 6px solid gray;
      border-top-color: #000;
      border-radius: 50%;
      width: 3em;
      height: 3em;
      animation: spin 1s linear infinite;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }
  </style>
</head>

<body class="hold-transition login-page">
  <div id="showLoading"></div>
  <div class="login-box">
    <div class="login-logo">
      <a href="../../index2.html"><b>Rancho el arenal </b>ADMIN</a>
    </div>
    <!-- /.login-logo -->
    <div class="card">
      <div class="card-body login-card-body">
        <div class="text-center">
          <img src="<?= base_url(); ?>assets/img/logo.jpg" alt="..." width="200" height="200">
        </div>
        <p class="login-box-msg">Iniciar sesión</p>
        <div id="error-login"></div>
        <form id="loginForm">
          <div class="input-group mb-3">
          <div class="input-group-prepend">
              <div class="input-group-text">
                <span class="fas fa-envelope"></span>
              </div>
            </div>
            <input type="email" class="form-control" name="email" id="email" placeholder="Correo electrónico">
            <div class="input-group-append">
              <div class="input-group-text">

              </div>
            </div>
          </div>
          <div class="input-group mb-3">
          <div class="input-group-prepend">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
            <input type="password" class="form-control" name="password" id="password" placeholder="Contraseña">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-eye" id="showPsw" onclick="showPassword();" title="Ver contraseña"></span>
                <span class="fas fa-eye-slash" id="hidePsw" onclick="hidePassword();" title="Ocultar contraseña" style="display: none;"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-8">
              <div class="icheck-primary">
                <input type="checkbox" id="remember">
                <label for="remember">
                  Recuerdame
                </label>
              </div>
            </div>
            <!-- /.col -->
            <div class="col-4">
              <button type="submit" class="btn btn-primary btn-block">Ingresar</button>
            </div>
            <!-- /.col -->
          </div>
        </form>
        <a href="#">¿Olvidaste tu contraseña?</a>
      </div>
      <!-- /.login-card-body -->
    </div>
  </div>
  <!-- /.login-box -->

  <!-- jQuery -->
  <script src="<?= base_url() ?>assets/plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="<?= base_url() ?>assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE App -->
  <script src="<?= base_url() ?>assets/dist/js/adminlte.min.js"></script>
  <script>
    function showPassword() {
      document.getElementById('password').type = 'text';
      document.getElementById('hidePsw').style.display = 'inline';
      document.getElementById('showPsw').style.display = 'none';
    }

    function hidePassword() {
      document.getElementById('password').type = 'password';
      document.getElementById('hidePsw').style.display = 'none';
      document.getElementById('showPsw').style.display = 'inline';
    }
    $(document).on('submit', '#loginForm', function(e) {
      e.preventDefault();
      $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
      $.ajax({
        method: "POST",
        url: "<?= base_url(); ?>index.php/login/log_in",
        data: $(this).serialize(),
        success: function(response) {
          if (response == "success") {
            window.location.href = "<?= base_url(); ?>index.php/home";
          } else {
            <?php if (!@$this->session->userdata('user_sess')) { ?>
              $("#showLoading").html('');
              $("#error-login").html(response);
            <?php } ?>
          }


        }
      });

    });
  </script>
</body>

</html>