<?php
if (@$this->session->flashdata('mercado_info')) {
    $mercado_info = $this->session->flashdata('mercado_info')['data'];
} ?>
<div class="content-wrapper">
    <div id="show_loading"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Precios de Mercado</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <button type="button" id="create_button" name="button" data-toggle="modal" data-target="#mercado_modal" class="btn btn-primary btn-sm"><i style="color:aliceblue" class="fas fa-plus-square"> </i> Nuevo</button>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <div class="table-responsive">
                                <table id="mercado_table" class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th><?php echo ('#') ?></th>
                                            <th><?php echo ('Producto') ?></th>
                                            <th><?php echo ('Fecha') ?></th>
                                            <th><?php echo ('Precio') ?></th>
                                            <th><?php echo ('Opciones') ?> </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (@$preciosMercado) {
                                            foreach ($preciosMercado as $i => $row) { ?>
                                                <tr>
                                                    <td><?= $i + 1 ?></td>
                                                    <td><?= $row->producto; ?></td>
                                                    <td><?= $row->fecha; ?></td>
                                                    <td><?= $row->precio; ?></td>
                                                    <td>
                                                        <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                                            Acción <span class="caret"></span>
                                                        </button>
                                                        <lu class="dropdown-menu dropdown-default pull-right" aria-labelledby="dropdownMenuLink">
                                                            <li>
                                                                <a type="button" class="dropdown-item btn-edit" onclick="get_by_id('<?= $row->idPrecioMercado; ?>')"><i class="fa fa-pen"></i> Editar</a>
                                                            </li>
                                                            <div class="dropdown-divider"></div>
                                                            <li>
                                                                <a type="button" class="dropdown-item" onclick="eliminar_mercado(<?= $row->idPrecioMercado ?>)"><i class="fa fa-trash-alt"></i> Eliminar</a>
                                                            </li>
                                                        </lu>
                                                    </td>
                                                </tr>
                                        <?php }
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
</div>
</div>
<!-- Modal -->
<?php include APPPATH . 'views/modals/mercado/nuevo_registro.php'; ?>
<?php include APPPATH . 'views/scripts/mercado.php'; ?>