<div class="modal fade" id="formato_registro_excel" data-backdrop="static" tabindex="-1" style="overflow-y: scroll;" data-keyboard="false" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Exportar / Importar formato de registro de ventas</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="show_loading">
            </div>
            <div class="modal-body">
                <span class="text-danger" id="errorMsg"></span>

                <p>Campos requeridos (<span class="text-danger">*</span>)</p>
                <form role="form" method="post" id="importExportForm" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group row">
                        <div class="col-md-3">
                            <label>Tipo <span class="text-danger">*</span></label>
                            <select name="typeAction" id="typeAction" class="form-control">
                                <option value="export" selected>Exportar</option>
                                <option value="import">Importar</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label>Cliente <span class="text-danger">*</span></label>
                            <select class="form-control" name="id_cliente_" id="id_cliente_" required>
                                <option value="">-- Seleccione un cliente --</option>
                                <?php foreach ($clientes as $cliente) { ?>
                                    <option value="<?= $cliente->id_cliente1; ?>"><?= $cliente->nombre_completo; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Fecha <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" name="fecha_" id="fecha_" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="name" style="clear:both;">Producto<span class="text-danger">*</span></label>
                            <select class="form-control" name="id_prod_" id="id_prod_" required>
                                <option value="" disabled selected>-- Producto --</option>
                                <?php foreach ($products as $product) { ?>
                                    <option value="<?= $product->id_producto; ?>"><?= $product->nombre_producto; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row" id="fileTag" style="display: none">
                        <div class="col-md-12">
                            <label for="exampleInputFile">Formato de registro<span class="text-danger">*</span></label>
                            <input type="file" name="registerFormat" class="form-control" id="registerFormat">
                        </div>
                    </div>
                    <hr>
                    <br>
                    <div id="table_demo1">
                        <h5>Plantilla demo registro de ovinos:</h5>
                        <div class="table-responsive">

                            <table class="table table-bordered table-sm  text-center table-hover " width="100%" cellspacing="0" cellpadding="" style="font-size: 9px">

                                <thead class="thead-light">

                                    <th scope="col"></th>
                                    <th scope="col">A</th>
                                    <th scope="col">B</th>
                                    <th scope="col">C</th>
                                    <th scope="col">D</th>
                                    <th scope="col">E</th>
                                    <th scope="col">F</th>
                                    <th scope="col">G</th>


                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="background-color: #e9ecef">8</td>
                                        <th class="border border-dark">N°</th>
                                        <th class="border border-dark">Producto</th>
                                        <th class="border border-dark">Kilos totales</th>
                                        <th class="border border-dark">Precio Por kilo</th>
                                        <th class="border border-dark">Arete</th>
                                        <th class="border border-dark">Grapa</th>
                                        <th class="border border-dark">Subtotal</th>

                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">9</td>
                                        <td>1</td>
                                        <td>1</td>
                                        <td>36</td>
                                        <td>41</td>
                                        <td>021</td>
                                        <td>1</td>
                                        <td>1436</td>

                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">10</td>
                                        <td>2</td>
                                        <td>1</td>
                                        <td>40</td>
                                        <td>41</td>
                                        <td>096</td>
                                        <td>1</td>
                                        <td>1641</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">11</td>
                                        <td>3</td>
                                        <td>1</td>
                                        <td>36</td>
                                        <td>41</td>
                                        <td>158</td>
                                        <td>1</td>
                                        <td>1436</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div>
                            <strong>Descripción</strong>
                            <ol>
                                <li>Todos los campos deben ser llenados de forma correcta para que puedan ser registrados de manera <b>exitosa</b> y así evitar <b>errores</b></li>
                                <li>El <b>Subtotal</b>, <b>Kilos Totales</b> ó <b>Precio por kilo</b>, son campos requeridos</li>
                                <li>Todos los campos que no contengan información deben tener la siguiente abreviatura:
                                    <ul>
                                        <li><b>N/A</b> ó <b>n/a</b></li>
                                    </ul>
                                    <label style="background:#ffff00;"><b>Si no se usa la abreviatura se debe dejar el campo vacío</b></label>
                                </li>
                                <li>En el campo de Producto debe ingresar el <b>ID</b> del producto, en el formato se mostrara una tabla con el listado de productos con su id y nombre</li>

                            </ol>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Cancelar</button>

                <div id="btn-save">
                    <button type="submit" class="btn btn-primary btn-sm">Guardar</button>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>
<script>
    $("#typeAction").on('change', function() {
        val = $(this).val();
        specie = $("#specieName").val();
        if (val == 'import') {
            $("#fileTag").show();
            $("#table_demo1").show();
            document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/ventas/importRegisterFormatExcel") ?>')
        } else {
            $("#table_demo1").hide();
            $("#fileTag").hide();
            document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/ventas/exportRegisterExcel/") ?>')
        }

    })


    $(document).ready(function() {
        $("#importExportForm").validate({
            rules: {
                typeAction: "required",
                specieName: "required",
                registerFormat: "required",
            },
            messages: {
                typeAction: "Campo requerido.",
                specieName: "Campo requerido.",
                registerFormat: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                $("#formato_registro_excel").modal('hide');
                if ($("#typeAction").val() == 'import') {
                    showLoader();
                }
                form.submit();
            }
        });

    });

    function showLoader() {
        var timer = new Timer();
        timer.start();

        timer.addEventListener('secondsUpdated', function(e) {
            $('#watchTime').html(timer.getTimeValues().toString());
        });
        $("#loader_alert").modal('show');
    }

    $("#registerFormat").on('change', function() {
        var ext = $(this).val().split('.').pop();
        if ($(this).val() != '') {
            if (ext != "xlsx") {
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato xlsx',
                    icon: 'error'

                })
                $(this).val('');
            }
        }
    })
</script>