<!--  DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
<!-- Theme style -->
<style>
    .pdfobject-container {
        height: 40rem;
        border: 1rem solid rgba(0, 0, 0, .1);
    }
</style>
<div class="content-wrapper">
    <div id="showLoading"></div>

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Clientes Desactivados</h1>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="clients_table" class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th><?php echo ('#') ?></th>
                                            <th><?php echo ('Tipo de cliente') ?></th>
                                            <th><?php echo ('Nombre') ?></th>
                                            <th><?php echo ('Dirección') ?></th>
                                            <th><?php echo ('Telefono') ?></th>
                                            <th><?php echo ('Correo') ?></th>
                                            <th><?php echo ('CURP') ?></th>
                                            <th><?php echo ('Status') ?></th>
                                            <th><?php echo ('Opciones') ?></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($clientes as $i => $cliente) { ?>
                                            <tr>
                                                <td><?= $i + 1; ?></td>
                                                <td>
                                                    <?php if ($cliente->tipo_cliente == 2) {
                                                        echo 'Prioritario';
                                                    } else {
                                                        echo 'Normal';
                                                    } ?>
                                                </td>
                                                <td><?= $cliente->nombre_completo; ?></td>
                                                <td>
                                                    <?php if ($cliente->direccion_cliente == '' || $cliente->direccion_cliente == null) {
                                                        echo '---';
                                                    } else {
                                                        echo $cliente->direccion_cliente;
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php if ($cliente->telefono_cliente == '' || $cliente->telefono_cliente == null || $cliente->telefono_cliente == 0 || $cliente->telefono_cliente == '9999999999') {
                                                        echo '---';
                                                    } else {
                                                        echo $cliente->telefono_cliente;
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php if ($cliente->email_cliente == '' || $cliente->email_cliente == null) {
                                                        echo '---';
                                                    } else {
                                                        echo $cliente->email_cliente;
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php if ($cliente->curp_cliente == '' || $cliente->curp_cliente == null) {
                                                        echo '---';
                                                    } else {
                                                        echo $cliente->curp_cliente;
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php if ($cliente->status == 0) { ?>
                                                        <span class="badge bg-danger" style="color: #fff !important">Desactivado</span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <div class="btn-group ">
                                                        <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                                            Acción <span class="caret"></span>
                                                        </button>
                                                        <lu class="dropdown-menu dropdown-default pull-right" aria-labelledby="dropdownMenuLink">
                                                            <li>
                                                                <a type="button" class="dropdown-item" onclick="activar_cliente('<?= $cliente->id_cliente1; ?>')"><i class="fa fa-user-check"></i> Activar</a>
                                                            </li>
                                                            <div class="dropdown-divider"></div>
                                                            <li>
                                                                <a type="button" class="dropdown-item" onclick="eliminar_cliente('<?= $cliente->id_cliente1; ?>')"><i class="fa fa-trash-alt"></i> Eliminar</a>
                                                            </li>
                                                        </lu>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
</div>


<?php include APPPATH . 'views/scripts/otros.php'; ?>