  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <!-- Theme style -->
  <div class="content-wrapper">
      <div id="show_loading"></div>
      <!-- Content Header (Page header) -->
      <section class="content-header">
          <div class="container-fluid">
              <div class="row mb-2">
                  <div class="col-sm-6">
                      <h1>Pedidos Cancelados</h1>
                  </div>
              </div>
          </div><!-- /.container-fluid -->
      </section>
      <section class="content">
          <div class="container-fluid">
              <div class="row">
                  <div class="col-12">
                      <div class="card">
                          <div class="card-body">
                              <div class="table-responsive">
                                  <table id="pedidos_table" class="table table-bordered table-hover dt-responsive">
                                      <thead>
                                          <tr>
                                              <th class="all hidden-print" width="05%"><?php echo ('#') ?></th>
                                              <th><?php echo ('Tipo de pedido') ?></th>
                                              <th><?php echo ('Folio') ?></th>
                                              <th><?php echo ('Nombre cliente') ?></th>
                                              <th><?php echo ('Producto') ?></th>
                                              <th><?php echo ('Fecha de entrega') ?></th>
                                              <th><?php echo ('Hora de entrega') ?></th>
                                              <th><?php echo ('Status') ?></th>
                                              <th><?php echo ('Motivo de cancelación') ?></th>
                                              <th class="none"><?php echo ('Información de contacto') ?></th>
                                              <th class="none"><?php echo ('Detalles de pedido') ?> </th>
                                          </tr>
                                      </thead>
                                      <tbody>
                                          <?php setlocale(LC_ALL, "es_MX.utf8");
                                            foreach ($orders as $i => $order) {
                                                $product = $this->db->get_where('productos', array('id_producto' => $order->id_producto))->row();
                                            ?>
                                              <tr>
                                                  <td><?= $i + 1; ?></td>
                                                  <td><?php if ($order->tipo_venta == 2) { ?>
                                                          Pedido interno
                                                      <?php } else { ?>
                                                          Pedido normal
                                                      <?php } ?>
                                                  </td>
                                                  <td><?= $order->folio_venta; ?></td>
                                                  <td><?= $order->nombre_completo; ?></td>
                                                  <td><?= $product->nombre_producto ?></td>
                                                  <td><?= strftime("%d-%b-%Y", strtotime($order->fecha)); ?></td>
                                                  <td><?= $order->hora ?></td>
                                                  <td>
                                                      <span class="badge bg-danger">Cancelado</span>
                                                  </td>
                                                  <td>
                                                      <?php if ($order->comentario_cancelacion != '' || $order->comentario_cancelacion != null) { ?>
                                                          <?= $order->comentario_cancelacion; ?>
                                                      <?php } else { ?>
                                                          ---
                                                      <?php } ?>
                                                  </td>
                                                  <td>
                                                      <?php
                                                        $this->db->where('id_cliente', $order->id_cliente);
                                                        $client = $this->db->get('clientes')->row();
                                                        ?>
                                                      <table class="table">
                                                          <thead>
                                                              <tr>
                                                                  <th><?php echo ('Email') ?></th>
                                                                  <td>
                                                                      <?php if ($client->email_cliente == '' || $client->email_cliente == null) { ?>
                                                                          ---
                                                                      <?php } else { ?>
                                                                          <?= $client->email_cliente; ?>
                                                                      <?php } ?>
                                                                  </td>


                                                                  <th><?php echo ('Teléfono') ?></th>
                                                                  <td>
                                                                      <?php if ($client->telefono_cliente == '' || $client->telefono_cliente == null || $client->telefono_cliente == 0 || $client->telefono_cliente == '9999999999') { ?>
                                                                          ---
                                                                      <?php } else { ?>
                                                                          <?= $client->telefono_cliente; ?>
                                                                      <?php } ?>
                                                                  </td>
                                                                  <th><?php echo ('Dirección') ?></th>
                                                                  <td>
                                                                      <?php if ($client->direccion_cliente == '' || $client->direccion_cliente == null) { ?>
                                                                          ---
                                                                      <?php } else { ?>
                                                                          <?= $client->direccion_cliente; ?>
                                                                      <?php } ?>
                                                                  </td>
                                                              </tr>
                                                          </thead>
                                                      </table>
                                                  </td>
                                                  <td colspan="6">
                                                      <table class="table" style="width:100%">
                                                          <thead class="thead-dark">
                                                              <tr>
                                                                  <th><?php echo ('Producto') ?></th>
                                                                  <th><?php echo ('Cantidad') ?></th>
                                                                  <th><?php echo ('Tipo de unidad') ?></th>
                                                              </tr>
                                                          </thead>
                                                          <tbody>
                                                              <tr>
                                                                  <td><?= $product->nombre_producto ?></td>
                                                                  <td><?= $order->cantidad_pedido ?></td>
                                                                  <td><?= $order->tipo_unidad ?></td>
                                                              </tr>
                                                          </tbody>


                                                      </table>
                                                  </td>
                                              </tr>
                                          <?php } ?>
                                      </tbody>

                                  </table>
                              </div>
                          </div>
                          <!-- /.card-body -->
                      </div>

                  </div>
                  <!-- /.col -->
              </div>
              <!-- /.row -->
          </div>
          <!-- /.container-fluid -->
      </section>
      <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  </div>
  </div>
  </div>
  <?php include APPPATH . 'views/scripts/otros.php'; ?>