  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <!-- Theme style -->
  <div id="show_loading"></div>
  <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <section class="content-header">
          <div class="container-fluid">
              <div class="row mb-2">
                  <div class="col-sm-6">
                      <h1>Productos desactivados</h1>
                  </div>
              </div>
          </div><!-- /.container-fluid -->
      </section>

      <!-- Main content -->
      <section class="content">
          <div class="container-fluid">
              <div class="row">
                  <div class="col-12">
                      <div class="card">
                          <!-- /.card-header -->
                          <div class="card-body">
                              <div class="table-responsive">
                                  <table id="productos_table" class="table table-bordered table-hover ">
                                      <thead>
                                          <tr>
                                              <th><?php echo ('#') ?></th>
                                              <th><?php echo ('Imagen') ?></th>
                                              <th><?php echo ('Nombre producto') ?></th>
                                              <th><?php echo ('Descripcion') ?></th>
                                              <th><?php echo ('Precio x kilo') ?></th>
                                              <th><?php echo ('Stock') ?></th>
                                              <th><?php echo ('Categoria') ?></th>
                                              <th><?php echo ('Raza') ?> </th>
                                              <th><?php echo ('Status') ?></th>
                                              <th><?php echo ('Opciones') ?> </th>
                                          </tr>
                                      </thead>
                                      <tbody>
                                          <?php foreach ($products as $i => $product) { ?>
                                              <tr>
                                                  <td><?= $i + 1; ?></td>
                                                  <td><img alt="" width="100" height="100" src="<?= API_DOCS_URL . $product->imagen; ?>" /></td>
                                                  <td><?= $product->nombre_producto; ?></td>
                                                  <td>
                                                      <?php if ($product->descripcion == '' || $product->descripcion == null) {
                                                            echo '---';
                                                        } else {
                                                            echo $product->descripcion;
                                                        } ?>
                                                  </td>
                                                  <td>$<?= number_format($product->precio, 2, '.', ','); ?></td>
                                                  <td><?= $product->inventario; ?></td>
                                                  <td><?= $product->nombre_categoria; ?></td>
                                                  <td><?= $product->raza; ?></td>
                                                  <td><span class="badge bg-danger" style="color: #fff !important">Desactivado</span></td>
                                                  <td>
                                                      <div class="btn-group ">
                                                          <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                                              Acción <span class="caret"></span>
                                                          </button>

                                                          <lu class="dropdown-menu dropdown-default pull-right" aria-labelledby="dropdownMenuLink">
                                                              <li>
                                                                  <a type="button" class="dropdown-item" onclick="activar_producto('<?= $product->id_producto; ?>')"><i class="fa fa-clipboard-check"></i> Activar</a>
                                                              </li>
                                                              <div class="dropdown-divider"></div>
                                                              <li>
                                                                  <a type="button" class="dropdown-item" onclick="eliminar_producto('<?= $product->id_producto ?>')"><i class="fa fa-trash-alt"></i> Eliminar</a>
                                                              </li>
                                                          </lu>
                                                      </div>
                                                  </td>
                                              </tr>
                                          <?php } ?>
                                      </tbody>
                                  </table>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </section>
  </div>
  </div>

  <!-- Modal -->

  <?php include APPPATH . 'views/scripts/otros.php'; ?>