  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <!-- Theme style -->
  <div class="content-wrapper">
    <div id="show_loading"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Pedidos</h1>
          </div>
          <div class="col-sm-6" align="right">
            <a type="button" id="create_button" name="button" data-toggle="modal" data-target="#pedido_modal" style="color:#fff" class="btn btn-primary btn-sm"><i style="color:aliceblue" class="fas fa-plus-square"> </i> Nuevo</a>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-body">
                <div class="table-responsive">
                  <table id="pedidos_table" class="table table-bordered table-hover dt-responsive">
                    <thead>
                      <tr>
                        <th id="idx" class="all hidden-print" width="05%"><?php echo ('#') ?></th>
                        <th id="tipo_venta"><?php echo ('Tipo de pedido') ?></th>
                        <th id="folio"><?php echo ('Folio') ?></th>
                        <th id="cliente_nombre"><?php echo ('Nombre cliente') ?></th>
                        <th id="producto"><?php echo ('Producto') ?></th>
                        <th id="fecha_venta"><?php echo ('Fecha de entrega') ?></th>
                        <th id="hora_venta"><?php echo ('Hora de entrega') ?></th>
                        <th id="status_ventas"><?php echo ('Estatus') ?></th>
                        <th id="nota_ventas"><?php echo ('Notas') ?></th>
                        <th id="contacto_info" class="none"><?php echo ('Información de contacto') ?></th>
                        <th id="extra_detalles" class="none"><?php echo ('Detalles extra') ?></th>
                        <th id="detalles_venta" class="none"><?php echo ('Detalles de pedido') ?> </th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php setlocale(LC_ALL, "es_MX.utf8");
                      foreach ($orders as $i => $order) {
                        $product = $this->db->get_where('productos', array('id_producto' => $order->id_producto))->row();
                      ?>
                        <tr>
                          <td><?= $i + 1; ?></td>
                          <td><?php if ($order->tipo_venta == 2) { ?>
                              Pedido interno
                            <?php } else { ?>
                              Pedido normal
                            <?php } ?>
                          </td>
                          <td><?= $order->folio_venta; ?></td>
                          <td><?= $order->nombre_completo; ?></td>
                          <td><?= $product->nombre_producto ?></td>
                          <td><?= strftime("%d-%b-%Y", strtotime($order->fecha)); ?></td>
                          <td><?= $order->hora ?></td>
                          <td>
                            <?php if ($order->status == 1) { ?>
                              <span class="badge bg-warning" style="color: #fff !important">Pendiente</span>
                            <?php } else if ($order->status == 2) { ?>
                              <span class="badge bg-info">Aprobado</span>
                            <?php } else if ($order->status == 5) { ?>
                              <span class="badge bg-danger">Cancelado</span>
                            <?php } ?>
                          </td>
                          <td>

                            <?php if ($order->notas_venta != '' || $order->notas_venta != null) { ?>
                              <?= $order->notas_venta; ?>
                            <?php } else { ?>
                              ---
                            <?php } ?>
                          </td>
                          <td>
                            <?php
                            $this->db->where('id_cliente', $order->id_cliente);
                            $client = $this->db->get('clientes')->row();
                            ?>
                            <table class="table">
                              <thead>
                                <tr>
                                  <th><?php echo ('Email') ?></th>
                                  <td>
                                    <?php if ($client->email_cliente == '' || $client->email_cliente == null) { ?>
                                      ---
                                    <?php } else { ?>
                                      <?= $client->email_cliente; ?>
                                    <?php } ?>
                                  </td>


                                  <th><?php echo ('Teléfono') ?></th>
                                  <td>
                                    <?php if ($client->telefono_cliente == '' || $client->telefono_cliente == null || $client->telefono_cliente == 0 || $client->telefono_cliente == '9999999999') { ?>
                                      ---
                                    <?php } else { ?>
                                      <?= $client->telefono_cliente; ?>
                                    <?php } ?>
                                  </td>
                                  <th><?php echo ('Dirección') ?></th>
                                  <td>
                                    <?php if ($client->direccion_cliente == '' || $client->direccion_cliente == null) { ?>
                                      ---
                                    <?php } else { ?>
                                      <?= $client->direccion_cliente; ?>
                                    <?php } ?>
                                  </td>
                                </tr>
                              </thead>
                            </table>
                          </td>
                          <td>

                            <?php if ($order->status == 5) { ?>

                              <table class="table">
                                <thead>
                                  <tr>
                                    <th><?php echo ('Motivo de cancelación') ?></th>
                                    <td>
                                      <?php echo $order->comentario_cancelacion; ?>
                                    </td>
                                  </tr>
                                </thead>
                              </table>
                            <?php } else {
                              echo '---';
                            } ?>
                          </td>
                          <td colspan="6">
                            <table class="table" style="width:100%">
                              <thead class="thead-dark">
                                <tr>
                                  <th><?php echo ('Producto') ?></th>
                                  <th><?php echo ('Cantidad') ?></th>
                                  <th><?php echo ('Tipo de unidad') ?></th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                  <td><?= $product->nombre_producto ?></td>
                                  <td><?= $order->cantidad_pedido ?></td>
                                  <td><?= $order->tipo_unidad ?></td>
                                </tr>
                              </tbody>


                            </table>
                            <hr>
                            <?php if ($order->status == 1) { ?>
                              <div class="col-md-12" align="right">
                                <a type="button" onclick="get_order_by_id(<?= $order->id_venta ?>)" style="color: #fff;" class="btn btn-success  btn-sm"><i style="color:aliceblue" class="fas fa-clipboard-check"> </i> Aprobar</a>
                                <a type="button" class="btn btn-danger btn-sm" onclick="cancel_order(<?= $order->id_venta ?>)" style="color: #fff;"><i style="color:aliceblue" class="fas fa-window-close"> </i> Cancelar</a>
                              </div>
                            <?php } ?>
                          </td>
                        </tr>
                      <?php } ?>
                    </tbody>

                  </table>
                </div>
              </div>
              <!-- /.card-body -->
            </div>

          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->


  <?php include APPPATH . 'views/modals/pedidos/nuevo_pedido.php'; ?>

  <?php include APPPATH . 'views/scripts/pedidos.php'; ?>

  </div>
  </div>
  </div>
  <?php include APPPATH . 'views/modals/pedidos/surtir_pedido.php'; ?>