<script>
    $(document).on("submit", "#categoriaForm ", function(event) {

        event.preventDefault();
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL ?>categorias/api/categorias/",
            method: "POST",
            headers: {
                "X-API-KEY": "REARNL",
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                response = _response.message;
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Categoria registrada con exito',
                    showConfirmButton: false,
                    timer: 1500,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
        });
    });
    $(document).ready(function() {
        $('#categorias_table').DataTable({
            ordering: false,
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            }

        })
    });

    $(document).ready(function() {
        $("#categoriaForm").validate({
            rules: {
                nombre: {
                    required: true
                }
            },
            messages: {
                nombre: {
                    required: 'Campo requerido.'
                }
            },
            errorElement: 'spam',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.field').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });
    });

    function eliminar_categoria(_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar la categoria una vez sea eliminada!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminarla!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>categorias/api/categorias/id/" +
                        _id,

                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        // window.location.reload();
                        response = _response.message;
                        if (_response.status == "error") {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                    $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                                }
                            })
                        } else {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Categoria eliminada con exito',
                                showConfirmButton: false,
                                timer: 1500,
                                onAfterClose: () => {
                                    window.location.reload();
                                    $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                                }
                            })
                        }
                    },
                    error: function() {
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })


    }
    $(".btn-edit").on('click', function() {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
    })
    <?php if (@$categoria_info) { ?>
        $(document).ready(function() {
            $("#categoria_modal").modal('show');
        });
        $(document).on("submit", "#categoriaUpdateForm ", function(event) {

            event.preventDefault();
            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
            $.ajax({
                url: "<?= API_URL ?>categorias/api/categorias/id/<?= @$categoria_info->id_categoria ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "REARNL",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    /*  window.location.reload(); */
                    response = _response.message;
                    $("#show_loading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Categoria actualizada con exito',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseText);
                    $("#show_loading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                },
            });
        });
    <?php } ?>
</script>