<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.2.4/pdfobject.min.js" integrity="sha512-mW7siBAOOJTkMl77cTke1Krn+Wz8DJrjMzlKaorrGeGecq0DPUq28KgMrX060xQQOGjcl7MSSep+/1FOprNltw==" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.2.4/pdfobject.js" integrity="sha512-pOkH5W0iYlsujt/wd8KQwGJlc76bfVQ+gN3wNj2jE671otBKfTqSU17mdb74MdGqU2G7ScJqH9BqQ8UvWL0hdg==" crossorigin="anonymous"></script>
<script src="https://mozilla.github.io/pdf.js/build/pdf.js" type="text/javascript"></script>

<script>
    //Insertar  cliente prioritario
    $(document).on('submit', '#clientes_form', function(event) {
        event.preventDefault();
        $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL; ?>clientes_prioritarios/api/clientes_prioritarios",
            method: "POST",
            headers: {
                'X-API-KEY': 'REARNL'
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                if (_response.status == 'success') {
                    $("#showLoading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Se ha registrado un nuevo cliente exitosamente',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })

                } else if (_response.status == 'error') {
                    $("#showLoading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + _response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                }
            },
            error: function(error) {

                response = JSON.stringify(error.responseText);
                $("#showLoading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
        });
    });

    $(document).ready(function() {
        $('#clients_table').DataTable({
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            },

        })
    });

    $(document).ready(function() {
        $("#clientes_form").validate({
            rules: {
                nombre_cliente: {
                    required: true,
                    minlength: 3,
                    maxlength: 100
                },
                apellido_paterno_cliente: {
                    required: true,
                    minlength: 3,
                    maxlength: 100
                },
                telefono_cliente: {
                    digits: true
                },
                email_cliente: {
                    email: true
                }
            },
            messages: {
                nombre_cliente: {
                    required: 'Campo requerido.',
                    minlength: 'Por favor ingresa minimo 3 caracteres.',
                    maxlength: 'Por favor ingresa maximo 100 caracteres.'
                },
                apellido_paterno_cliente: {
                    required: 'Campo requerido.',
                    minlength: 'Por favor ingresa minimo 3 caracteres.',
                    maxlength: 'Por favor ingresa maximo 100 caracteres.'
                },
                telefono_cliente: {
                    digits: 'Por favor ingrese únicamente digitos.'
                },
                email_cliente: {
                    email: 'Por favor ingrese un correo valido.'
                }
            },
            errorElement: 'spam',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.field').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });
    });

    function mayus(e) {
        e.value = e.value.toUpperCase();
    }

    $('.btn-client').on('click', function() {
        $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
    })

    <?php
    if (@$cliente_info) { ?>
        $(document).ready(function() {
            $("#modal_cliente").modal("show");
        });

        function ver_documento_id() {
            $(".showLoading").html('<div class="loading show"><div class="spin"></div></div>');
            _doc = "<?= $cliente_info->identificacion_cliente; ?>";
            var ext = _doc.split('.').pop();
            if (ext == 'pdf') {
                var options = {
                    fallbackLink: "<p>Este navegador no soporta PDF en linea. Por favor descarga el PDF para poder visualizarlo <a href='[url]'>Descargar PDF</a></p>"
                };
                PDFObject.embed('<?= API_DOCS_URL; ?>' + _doc, "#documento_ver", options);
                $('.showLoading').html('');
                $("#modal_cliente").modal("hide");
                $("#identificacion_modal").modal("show");
            } else {
                let preview_image = document.getElementById('documento_ver'),
                    image = document.createElement('img');
                image.src = '<?= API_DOCS_URL; ?>' + _doc;
                image.style.height = "17rem";
                preview_image.append(image);
                $('.showLoading').html('');
                $("#modal_cliente").modal("hide");
                $("#identificacion_modal").modal("show");
            }

        }
        $('.close-modal').on('click', function() {
            $("#documento_ver").html('');
            $("#modal_cliente").modal("show");
        })
        $('.close-address-modal').on('click', function() {
            $("#agregar_direccion_modal").modal('hide');
            $("#modal_cliente").modal("show");
        })

        function agregar_documento_id() {
            $("#modal_cliente").modal("hide");
            $("#documento_ver").html('<div class="show_loading"></div><form id="docForm" method="POST"><div class="form-group col-md-12">' +
                '<label for="">Documento de identificación oficial</label>' +
                '<input type="file" class="form-control" id="doc_identificacion_cliente" onchange="ver_miniatura_doc_id()" name="doc_identificacion_cliente" required>' +
                '<p class="text-danger">Puede subir imagen o documento pdf (INE, licencia de conducir o otro). El documento debe ser visible.</p>' +
                '</div><div id="field_file" class="col-md-12"></div><div align="right"><button type="submit" class="btn btn-primary btn-sm">Guardar</button></div></form>');
            $(document).ready(function() {
                $("#docForm").validate({
                    rules: {
                        doc_identificacion_cliente: {
                            required: true,
                        }
                    },
                    messages: {
                        doc_identificacion_cliente: {
                            required: 'Campo requerido.',
                        }
                    },
                    errorElement: 'spam',
                    errorPlacement: function(error, element) {
                        error.addClass('invalid-feedback');
                        element.closest('.field').append(error);
                    },
                    highlight: function(element, errorClass, validClass) {
                        $(element).addClass('is-invalid');
                    },
                    unhighlight: function(element, errorClass, validClass) {
                        $(element).removeClass('is-invalid');
                    },
                });

            });
            $("#identificacion_modal").modal("show");
        }

        function agregar_direccion(id) {
            $("#modal_cliente").modal("hide");
            $("#agregar_direccion_modal").modal("show");
            $(document).ready(function() {
                $("#agregar_direccion_form").validate({
                    rules: {
                        cp: {
                            required: true,
                        },
                        estado: {
                            required: true,
                        },
                        municipio: {
                            required: true,
                        },
                        colonia: {
                            required: true,
                        },
                        calle: {
                            required: true,
                        },
                        indicaciones: {
                            required: true,
                        }
                    },
                    messages: {
                        cp: {
                            required: 'Campo requerido.',
                        },
                        estado: {
                            required: 'Campo requerido.',
                        },
                        municipio: {
                            required: 'Campo requerido.',
                        },
                        colonia: {
                            required: 'Campo requerido.',
                        },
                        calle: {
                            required: 'Campo requerido.',
                        },
                        indicaciones: {
                            required: 'Campo requerido.',
                        }
                    },
                    errorElement: 'spam',
                    errorPlacement: function(error, element) {
                        error.addClass('invalid-feedback');
                        element.closest('.field').append(error);
                    },
                    highlight: function(element, errorClass, validClass) {
                        $(element).addClass('is-invalid');
                    },
                    unhighlight: function(element, errorClass, validClass) {
                        $(element).removeClass('is-invalid');
                    },
                });
            });
            $(document).on('submit', '#agregar_direccion_form', function(event) {
                event.preventDefault();
                $(".show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>direccion/api/direccion/",
                    method: "POST",
                    headers: {
                        'X-API-KEY': 'REARNL'
                    },
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(_response) {
                        $(".show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'Se ha registrado la dirección exitosamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    }
                });
            });


        }

        $(document).on('submit', '#docForm', function(event) {
            event.preventDefault();
            $(".show_loading").html('<div class="loading show"><div class="spin"></div></div>');
            $.ajax({
                url: "<?= API_URL; ?>clientes/api/identificacion_cliente/id/<?= $cliente_info->id_cliente1; ?>",
                method: "POST",
                headers: {
                    'X-API-KEY': 'REARNL'
                },
                data: new FormData(this),
                processData: false,
                contentType: false,
                cache: false,
                async: false,
                success: function(_response) {
                    $(".show_loading").html('');
                    if (_response.status == 'success') {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'Se ha actualizado el documento de identificacion de manera exitosa',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    } else if (_response.status == 'error') {

                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + _response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    }
                },
                error: function(error) {

                    response = JSON.stringify(error.responseText);
                    $("#showLoading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                },
            });
        });


    <?php }
    ?>
    


    <?php
    if (@$cliente_info1) { ?>
        $(document).ready(function() {
            $("#cliente_modal").modal("show");
        });
        $(document).on("submit", "#clientesUpdateForm21", function(event) {

            event.preventDefault();

            $.ajax({
                  url: "<?= API_URL ?>clientes_prioritarios/api/clientes_prioritarios/id/<?= $cliente_info1->id_cliente1 ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "REARNL",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;
                    $("#show_loading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Cliente actualizado con exito',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                             window.location.reload();

                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseText);
                    $("#show_loading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                             window.location.reload();
                        }
                    })
                },
            });
        });


    <?php }
    ?>

    //se crea un atajo para acceder a PDF.js exports
    var pdfjsLib = window['pdfjs-dist/build/pdf'];
    //la propiedad de recurso d trabajo (workerSrc) es especificado
    pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://mozilla.github.io/pdf.js/build/pdf.worker.js';
    //funcion para obtenr el documento en miniatura
    function ver_miniatura_doc_id(e) {

        //guardamos la extensión del archivo
        var ext = $("#doc_identificacion_cliente").val().split('.').pop();
        //verificamos si existe el elemento con el id pdfViewer 
        if ($("#pdfViewer").length > 0) {
            //eliminamos el elemento
            $("#pdfViewer").remove();
        }
        //verificamos si existe el elemento con el id previewImage 
        if ($("#previewImage").length > 0) {
            //eliminamos elemento
            $("#previewImage").remove();
        }
        //cambiamos el tamaño del input del archivo, para ajustar la miniatura del documento
        /* $("#campo_file").removeClass("col-md-6").addClass("col-md-5"); */
        //si el campo contiene valor
        if ($("#doc_identificacion_cliente").val() != '') {
            //si ees un documento en formato PDF 
            if (ext == "pdf") {
                //creamos una varible llamadaa canvas y almacenamos una etiqueta div y canvas
                //para adjustar la miniatura del archivo
                canvas = '<div class="col-md-1"><canvas id="pdfViewer"></canvas></div>';
                //insertamos el elemento despues del div que corrsponde al input del archivo
                $("#field_file").after(canvas);
                const file = document.getElementById('doc_identificacion_cliente').files[0];
                /* var file = e.target.files[0] */
                //si el archivo es pdf
                if (file.type == "application/pdf") {
                    //creamos objcto de tipo filereader
                    var fileReader = new FileReader();
                    //accedemos al metodo onload para cargar el archivo
                    fileReader.onload = function() {
                        var pdfData = new Uint8Array(this.result);
                        //usamos DocumntInitParmeters objeto para cargar los datos binarios
                        var loadingTask = pdfjsLib.getDocument({
                            data: pdfData
                        });
                        loadingTask.promise.then(function(pdf) {
                            console.log('PDF loaded');

                            // Cargamos la primera pagina
                            var pageNumber = 1;
                            pdf.getPage(pageNumber).then(function(page) {
                                //console.log('Page loaded');
                                //pagina cargada
                                var scale = 0.2;
                                var viewport = page.getViewport({
                                    scale: scale
                                });

                                // Prepaara  el canvas usando las dimensiones de la pagina del PDF
                                var canvas = $("#pdfViewer")[0];
                                var context = canvas.getContext('2d');
                                canvas.height = viewport.height;
                                canvas.width = viewport.width;

                                // Renderiza la pagin del PDF dentro del contexto del canvas
                                var renderContext = {
                                    canvasContext: context,
                                    viewport: viewport
                                };
                                var renderTask = page.render(renderContext);
                                renderTask.promise.then(function() {
                                    //console.log('Page rendered');
                                    //Pagina rendrizadaa
                                });
                            });
                        }, function(reason) {
                            // En caso de error
                            console.error(reason);
                        });
                    };
                    fileReader.readAsArrayBuffer(file);
                }
            } else if (ext == "jpeg" || ext == "jpg" || ext == "png") {
                //si el usuario esta subiendo una imagen
                //console.log("Image");
                //etiquet div para mostrar imagen
                div = '<div class="col-md-5"><div id="previewImage"></div></div>';
                $("#field_file").after(div);
                //creamos un objecto filereader
                let reader = new FileReader();
                //cargarmos la imagen
                reader.onload = function() {
                    //obtenemos el elemento donde se visualizara la imagen en miniatura
                    let preview = document.getElementById('previewImage'),
                        //creamos el elemento imagen
                        image = document.createElement('img');

                    image.src = reader.result;
                    image.height = "150";
                    image.width = "200";
                    preview.innerHTML = '';
                    //insertamos la imagen en la etiqueta en la cual se visualizara
                    preview.append(image);
                };

                reader.readAsDataURL(document.getElementById('doc_identificacion_cliente').files[0]);
            } else {
                //Si el archivo es incorrecto o no permitido
                $("#doc_identificacion_cliente").val('');
                //alert("Archivo no permitido, " + 'debe subir un archivo en formato PDF o en Imagen');
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato PDF o en Imagen',
                    icon: 'error'

                })
            }
        }
    }

    function bloquear_cliente(cliente_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea bloquear a este cliente?',
            text: "¡El cliente no podra realizar compras mientras este bloqueado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Bloquearlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>clientes/api/bloquear/id/" + cliente_id,
                    method: "PUT",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El cliente se ha bloqueado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })
    }

    function desbloquear_cliente(cliente_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea desbloquear a este cliente?',
            text: "¡El cliente podrá realizar compras!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Desbloquearlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>clientes/api/desbloquear/id/" + cliente_id,
                    method: "PUT",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El cliente se ha desbloqueado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })
    }

    function eliminar_cliente(cliente_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea eliminar a este cliente?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminarlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>clientes/api/eliminar/id/" + cliente_id,
                    method: "PUT",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        $("#showLoading").html('');
                        response = JSON.stringify(_response.message);
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El cliente se ha eliminado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })
    }
</script>