<script>
    $(document).on("submit", "#personalInfoForm ", function(event) {

        event.preventDefault();
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL ?>usuarios/api/usuarios_personal_info/id/<?= @$user->id_usuario ?>",
            method: "PUT",
            headers: {
                "X-API-KEY": "REARNL",
            },
            data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Datos personales actualizados con exito',
                    showConfirmButton: false,
                    timer: 1500,
                    onAfterClose: () => {
                        /* location.href = "<?= base_url(); ?>index.php/configuracion/modify_session_data/<?= @$user->id_usuario ?>"; */
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
        });
    });

    $(document).on("submit", "#cuentaInfoForm ", function(event) {

        event.preventDefault();
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL ?>usuarios/api/usuarios_cuenta_info/id/<?= @$user->id_usuario ?>",
            method: "POST",
            headers: {
                "X-API-KEY": "REARNL",
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                response = _response.message;
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Datos de cuenta actualizados con exito',
                    showConfirmButton: false,
                    timer: 1500,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
        });
    });
</script>