<script>
    function get_by_id(id) {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        var recordId = id;
        $.ajax({
            url: "<?= API_URL; ?>precios_mercado/api/precios_mercado/id/" +
                recordId,
            method: "GET",
            headers: {
                "X-API-KEY": "REARNL",
            },
            success: function(_response) {
                $(document).find("#idPrecioMercado	").remove();
                $(".btns").text("");
                $("#myModalLabel").text("");
                $("#myModalLabel").append("Editar Registro");
                $("#create_button").trigger("click");
                $("#productoId").val(_response.data.productoId);
                $("#fecha").val(_response.data.fecha);
                $("#precio").val(_response.data.precio);

                $(".btns").append(
                    '<button type="button" onclick="editar(' +
                    _response.data.idPrecioMercado +
                    ')" class="btn btn-primary btn-sm" style="color: #fff !important;">Actualizar</button>' +
                    '<button type="button" class="btn btn-secondary btn-sm close_modal" data-dismiss="modal">Cancelar</button>'
                );
                $("#show_loading").html('');
            },
            error: function(error) {},
        });
    }
    $(document).on("submit", "#mercadoForm ", function(event) {
        event.preventDefault();
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL ?>precios_mercado/api/precios_mercado/",
            method: "POST",
            headers: {
                "X-API-KEY": "REARNL",
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                response = _response.message;
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Precio de mercado registrado con exito',
                    showConfirmButton: false,
                    timer: 1500,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
        });
    });
    $(document).ready(function() {
        $('#mercado_table').DataTable({
            ordering: false,
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            }

        })
    });

    $(document).ready(function() {
        $("#mercadoForm").validate({
            rules: {
                productoId: {
                    required: true
                },
                fecha: {
                    required: true
                },
                precio: {
                    required: true
                }
            },
            messages: {
                productoId: {
                    required: 'Campo requerido.'
                },
                fecha: {
                    required: 'Campo requerido.'
                },
                precio: {
                    required: 'Campo requerido.'
                }
            },
            errorElement: 'spam',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.field').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });
    });

    function eliminar_mercado(_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar el registro una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminar!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>precios_mercado/api/precios_mercado/id/" +
                        _id,

                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        // window.location.reload();
                        response = _response.message;
                        if (_response.status == "error") {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                    $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                                }
                            })
                        } else {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminada con exito',
                                showConfirmButton: false,
                                timer: 1500,
                                onAfterClose: () => {
                                    window.location.reload();
                                    $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                                }
                            })
                        }
                    },
                    error: function() {
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })


    }
    $(".btn-edit").on('click', function() {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
    })

    function editar(id) {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL ?>precios_mercado/api/precios_mercado/id/" + id,
            method: "PUT",
            headers: {
                "X-API-KEY": "REARNL",
            },
            data: $(document).find("#mercadoForm").serialize(),
            success: function(_response) {
                response = _response.message;
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Precio actualizado con exito',
                    showConfirmButton: false,
                    timer: 1500,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                    }
                })
            },
        });
    }
</script>