<script>
    $(document).ready(function() {
        $('#clients_table').DataTable({
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            },

        })
    });

    function activar_cliente(cliente_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea activar a este cliente?',
            text: "¡El cliente podrá realizar compras!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Activarlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>clientes/api/activar/id/" + cliente_id,
                    method: "PUT",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El cliente se ha activado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })
    }

    function eliminar_cliente(cliente_id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea eliminar a este cliente?',
            text: "¡No podrá recuperar el cliente eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminarlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>clientes/api/eliminar_cliente/id/" + cliente_id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El cliente se ha eliminado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = error.responseJSON.message;
                        $("#showLoading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: response,
                            showConfirmButton: true,
                        })
                    },
                });
            }
        })
    }
    $(document).ready(function() {
        $('#productos_table').DataTable({
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            },

        })
    });

    function activar_producto(id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea activar a este producto?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Activarlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>productos/api/activar/id/" + id,
                    method: "PUT",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El producto se ha activado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })
    }

    function eliminar_producto(id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea eliminar a este producto?',
            text: "¡No podrá recuperar el producto eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminarlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>productos/api/eliminar_producto/id/" + id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'El producto se ha eliminado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = error.responseJSON.message;
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: response,
                            showConfirmButton: true,
                        })
                    },
                });
            }
        })
    }

    $(document).ready(function() {
        $('#categorias_table').DataTable({
            ordering: false,
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            }

        })
    });

    function activar_categoria(id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea activar esta categoria?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Activar!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>categorias/api/activar/id/" + id,
                    method: "PUT",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'La categoria se ha activado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = JSON.stringify(error.responseText);
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: "'" + response.message + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#showLoading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })
                    },
                });
            }
        })
    }

    function eliminar_categoria(id) {
        event.preventDefault();
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro que desea eliminar esta categoria?',
            text: "¡No podrá recuperar la categoria eliminada!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminar!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>categorias/api/eliminar_categoria/id/" + id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = JSON.stringify(_response.message);
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'La categoria se ha eliminado correctamente',
                            showConfirmButton: false,
                            timer: 1500,
                            onAfterClose: () => {
                                window.location.reload();
                                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                            }
                        })

                    },
                    error: function(error) {
                        response = error.responseJSON.message;
                        $("#show_loading").html('');
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            text: response,
                            showConfirmButton: true,
                        })
                    },
                });
            }
        })
    }

    $(document).ready(function() {
        /*    sortSelect('id_cliente'); */
        $('#pedidos_table').DataTable({
            ordering: false,
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            }
        })
    });
</script>