<script>
    $(document).ready(function() {
        $('#productos_table').DataTable({
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            },

        })
    });

    $(document).ready(function() {
        $("#productos_form").validate({
            rules: {
                nombre: {
                    required: true,
                    minlength: 3,
                    maxlength: 100
                },
                precio: {
                    required: true,
                    number: true
                },
                inventario: {
                    required: true,
                    digits: true
                },
                categoria: {
                    required: true
                },
                raza: {
                    required: true
                }
            },
            messages: {
                nombre: {
                    required: 'Campo requerido.',
                    minlength: 'Por favor ingresa minimo 3 caracteres.',
                    maxlength: 'Por favor ingresa maximo 100 caracteres.'
                },
                precio: {
                    required: 'Campo requerido.',
                    number: 'Por favor ingresa un precio valido',
                },
                inventario: {
                    required: 'Campo requerido.',
                    digits: 'Por favor ingrese únicamente digitos.'
                },
                categoria: {
                    required: 'Campo requerido.',
                },
                raza: {
                    required: 'Campo requerido.',
                }
            },
            errorElement: 'spam',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.field').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });
    });

    $(document).ready(function() {
        $("#updatePhotoForm").validate({
            rules: {
                imagen: {
                    required: true
                }
            },
            messages: {
                imagen: {
                    required: 'Campo requerido.',
                }
            },
            errorElement: 'spam',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.field').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });
    });

    /* Función para resetear formulario de registro de pedido al cerrar modal */
    $('.close_modal').on('click', function(e) {
        e.preventDefault();
        document.getElementById('productos_form').reset();
    })

    function areyousure(_id) {
        //configuración de alerta
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar el registro de este animal  una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminarlo!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                $.ajax({
                    url: "<?= API_URL; ?>productos/api/productos/id/" +
                        _id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        $("#show_loading").html('');
                        if (_response.status == 'success') {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Producto eliminado con exito',
                                showConfirmButton: false,
                                timer: 1500,
                                onAfterClose: () => {
                                    window.location.reload();
                                    $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                                }
                            })
                        } else if (_response.status == 'error') {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Error interno',
                                text: "'" + _response.message + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        }
                    },
                    error: function(error) {
                        response = error.message;
                        $("#show_loading").html('');
                        response = JSON.stringify(error.responseText);
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            title: 'Error interno',
                            text: "'" + response + "'",
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                            }
                        })
                    },
                });
            }
        })
    }
    //obtiene categorias por id
    function get_by_id(id) {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        var id_producto = id;
        $.ajax({
            url: "<?= API_URL; ?>productos/api/productos/id/" +
                id_producto,
            method: "GET",
            headers: {
                "X-API-KEY": "REARNL",
            },
            success: function(_response) {
                $(document).find("#id_producto").remove();
                $(".btns").text("");
                $("#myModalLabel").text("");
                $("#myModalLabel").append("Editar Producto");
                $("#create_button").trigger("click");
                $("#nombre").val(_response.data.nombre_producto);
                $("#descripcion").val(_response.data.descripcion);
                $("#precio").val(_response.data.precio);
                $("#inventario").val(_response.data.inventario);
                $("#categoria").val(_response.data.id_categoria);
                $("#raza").val(_response.data.raza);
                $(".btns").append(
                    '<button type="button" onclick="editar(' +
                    _response.data.id_producto +
                    ')" class="btn btn-primary btn-sm" style="color: #fff !important;">Actualizar</button>' +
                    '<button type="button" class="btn btn-secondary btn-sm close_modal" data-dismiss="modal">Cancelar</button>'
                );
                $("#show_loading").html('');
            },
            error: function(error) {},
        });
    }
    //funcion para editar un producto
    function editar(id) {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL; ?>productos/api/productos/id/" +
                id,
            method: "PUT",
            headers: {
                "X-API-KEY": "REARNL",
            },
            data: $(document).find("#productos_form").serialize(),
            success: function(_response) {
                $("#show_loading").html('');
                if (_response.status == 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Producto actualizado con exito',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                } else if (_response.status == 'error') {
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Error interno',
                        text: "'" + _response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                        }
                    })
                }
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Error interno',
                    text: "'" + response + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                    }
                })
            },
        });
    }
    //Insertar producto
    $(document).on('submit', '#productos_form', function(event) {
        event.preventDefault();
        $("#producto_modal").modal('hide');
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            url: "<?= API_URL; ?>productos/api/productos/",
            method: "POST",
            headers: {
                'X-API-KEY': 'REARNL'
            },
            // data: $('#productosForm').serialize(),
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                $("#show_loading").html('');
                if (_response.status == 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Producto registrado con exito',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                } else if (_response.status == 'error') {
                    $("#producto_modal").modal('show');
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Error interno',
                        text: "'" + _response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                        }
                    })
                }
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                $("#producto_modal").modal('show');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                    }
                })
            }
        });
    });

    function updatePhoto(id) {
        //alert(id)
        $("#updatePhotoModal").modal("show");
        $("#product_id").val(id);

    }
    $(document).on('submit', '#updatePhotoForm', function(event) {
        event.preventDefault();
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        id = $("#product_id").val();
        $.ajax({
            url: "<?= API_URL; ?>productos/api/actualizar_foto/id/" +
                id,
            method: "POST",
            headers: {
                'X-API-KEY': 'REARNL'
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                $("#show_loading").html('');
                if (_response.status == 'success') {
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Producto actualizado con exito',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                } else if (_response.status == 'error') {

                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Error interno',
                        text: "'" + _response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                        }
                    })
                }

            },
            error: function(error) {

                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Error interno',
                    text: "'" + response + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                    }
                })
            },
        });
    });
</script>