<script>
    /* Función para ordenar el select de clientes de manera alfabetica */
    function sortSelect(component_id) {
        var selectToSort = jQuery('#' + component_id);
        var currentOption = selectToSort.val();
        selectToSort.html(selectToSort.children('option').sort(function(a, b) {
            return a.text === b.text ? 0 : a.text < b.text ? -1 : 1;
        })).val(currentOption);
    }

    function cambiar_valor_positivo(input) {
        value = input.value;
        val = value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');
        $("#" + input.id).val(val)
    }
    function price_formatter(num) {
        const formatter = new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: 'USD',
            minimumFractionDigits: 2
        })
        return formatter.format(num)
    }

    function date_formatter(date) {
        const dateArr = date.split('-');
        var dateObject = new Date(+dateArr[0], dateArr[1] - 1, +dateArr[2]); 

         var event = new Date(dateObject);
         var options = {
             year: 'numeric',
             month: 'short',
             day: 'numeric'
         };
         _date = event.toLocaleDateString('es-MX', options)
         
         return  _date.replaceAll(' ', '-') ;
    }

    /* Función para cargar buscadores en la tabla y poner encabezados y pies de pagina en español  */
    $(document).ready(function() {
        sortSelect('id_cliente');
        var table = $('#sales_table').DataTable({
            ordering: false,
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            },
            stateSave: true,
            processing: true,
            serverSide: true,
            ajax: {
                url: '<?= base_url('index.php/ventas/get_pagination_sales') ?>',
                type: 'POST',
                datatype: "JSON",
            },
            dataSrc: function(jsonString) {
                var jsonData = JSON.parse(jsonString);
                //console.log(jsonData)
                return jsonData.data;
            },
            columns: [{
                    data: '',
                    render: function(data, type, row, meta) {

                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: "tipo_venta",
                    render: function(data, type, row, meta) {

                        return ((row.tipo_venta == 2) ? 'Venta interna' :
                            'Venta interna');

                    }
                },
                {
                    data: "folio_venta"
                },
                {
                    data: "nombre_completo"
                },
                {
                    data: "total",
                    render: function(data, type, row, meta) {
                        var _total = (price_formatter(data))
                        return (_total)
                    }
                },
                {
                    data: "fecha",
                    render: function(data, type, row, meta) {
                        var _fecha = (date_formatter(data))
                        return (_fecha)
                    }
                },
                {
                    data: "status",
                    render: function(data, type, row, meta) {
                        if (data == 1) {
                            _status = '<span class="badge bg-warning">Pendiente</span>'
                        } else if (data == 2) {
                            _status = '<span class="badge bg-info">Aprobada</span>'
                        } else if (data == 3) {
                            _status = '<span class="badge bg-success">Exitosa</span>'
                        }
                        return (_status)
                    }
                },
                {
                    data: "status_envio_recibo",
                    render: function(data, type, row, meta) {

                        return ((data == 0) ? '<span class="badge bg-danger"><i class="fas fa-comment-slash"></i>No enviado</span>' :
                            '<span class="badge bg-success"><i class="fas fa-envelope-open-text"></i>Enviado</span>')
                    }
                },
                {
                    data: "id_venta",
                    render: function(data, type, row, meta) {
                        _opt = ""
                        _opt += '<div class="btn-group ">'
                        _opt += '<button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">'
                        _opt += 'Acción <span class="caret"></span>'
                        _opt += '</button>'
                        _opt += '<lu class="dropdown-menu dropdown-default pull-right" aria-labelledby="dropdownMenuLink">'
                        _opt += '<li>'
                        _opt += '<a class="dropdown-item" href="<?= base_url(); ?>index.php/Ventas/get_salesForID/' + data + '"><i class="fa fa-edit"></i> Editar datos venta</a>'
                        _opt += '<a target="_blank" class="dropdown-item" href="<?= base_url(); ?>index.php/recibo_ventas/imprimir_recibo/' + data + '"><i class="fa fa-file-pdf"></i> Descargar recibo en PDF</a>'
                        _opt += '<a class="dropdown-item" href="<?= base_url(); ?>index.php/recibo_ventas/descargar_recibo_excel/' + data + '"><i class="fa fa-file-excel"></i> Descargar recibo en EXCEL</a>'
                        _opt += '<div class="dropdown-divider"></div>'
                        _opt += '<a class="dropdown-item" href="<?= base_url(); ?>index.php/recibo_ventas/descargar_reporte_excel/' + data + '"><i class="fa fa-file-excel"></i> Descargar reporte en EXCEL</a>'

                        if (row.status_envio_recibo == 0) {
                            _opt += '<div class="dropdown-divider"></div>'
                            _opt += '<a class="dropdown-item" onclick="sendReceiptByEmail(' + data + ')"><i class="far fa-envelope"></i> Enviar recibo por correo</a>'
                        }

                        _opt += '</li>'
                        _opt += '</lu>'
                        _opt += '</div>'
                        return _opt;
                    }
                },
                {
                    data: "notas_venta",
                    render: function(data, type, row, meta) {
                        if (data != '' || data != null) {
                            _notas = data;
                        } else {
                            _notas = '---'
                        }
                        return _notas;
                    }
                },
                {
                    data: "clienteInfo",
                    render: function(data, type, row, meta) {
                        if (data.email_cliente == '' || data.email_cliente == null) {
                            email_cliente = '---'
                        } else {
                            email_cliente = data.email_cliente;
                        }
                        if (data.telefono_cliente == '' || data.telefono_cliente == null ||
                            data.telefono_cliente == 0 || data.telefono_cliente == '9999999999') {
                            telefono_cliente = '---'
                        } else {
                            telefono_cliente = data.telefono_cliente;
                        }
                        if (data.direccion_cliente == '' || data.direccion_cliente == null) {
                            direccion_cliente = '---'
                        } else {
                            direccion_cliente = data.direccion_cliente;
                        }
                        _cliente = ''
                        _cliente += '<table class="table">'
                        _cliente += '<thead>'
                        _cliente += '<tr>'
                        _cliente += '<th width="20%">Correo electrónico</th>'
                        _cliente += '<td>' + email_cliente + '</td></tr>'
                        _cliente += '<tr>'
                        _cliente += '<th width="20%">Teléfono</th>'
                        _cliente += '<td>' + telefono_cliente + '</td></tr>'
                        _cliente += '<tr>'
                        _cliente += '<th>Dirección</th>'
                        _cliente += '<td>' + direccion_cliente + '</td></tr>'
                        _cliente += '</thead>'
                        _cliente += '</table>'
                        return _cliente;
                    }
                },

                {
                    data: "productosVenta",
                    render: function(data, type, row, meta) {
                        let total = 0;
                        let legend = '';
                        _productosTable = ''
                        _productosTable += '<table class="table" style="width:100%">'
                        _productosTable += '<thead class="thead-dark">'
                        _productosTable += '<tr>'
                        _productosTable += '<th>#</th>'
                        _productosTable += '<th>Producto</th>'
                        _productosTable += '<th>Raza</th>'
                        _productosTable += '<th>Arete</th>'
                        _productosTable += '<th>Precio U.</th>'
                        _productosTable += '<th>Cantidad</th>'
                        _productosTable += '<th>Subtotal</th>'
                        _productosTable += '<th>Acciónes</th>'
                        _productosTable += '</tr>'
                        _productosTable += '</thead>'
                        _productosTable += '<tbody>'
                        i = 0;
                        data.forEach(function(pv) {
                            total = total + parseInt(pv.subtotal);
                            if (pv.productoVenta_update == pv.productoVenta_create) {} else {
                                datess = (pv.productoVenta_update);
                                legend = '<label>El precio se actualizo el dia  </label>' + '  ' + datess;
                            }
                            if (pv.arete == 0 || pv.arete == null || pv.arete == '') {
                                aretep = 'NA'
                            } else {
                                aretep = pv.arete
                            }
                            _productosTable += '<tr>'
                            _productosTable += '<td>' + (i + 1) + '</td>'
                            _productosTable += '<td>' + pv.nombre_producto + '</td>'
                            _productosTable += '<td>' + pv.raza + '</td>'
                            _productosTable += '<td>' + (aretep) + '</td>'
                            _productosTable += '<td>' + (price_formatter(pv.precio)) + '</td>'
                            if (pv.tipo == 'ud') {
                                _productosTable += '<td>' + (pv.cantidad + ' Piezas') + '</td>'

                            } else {
                                _productosTable += '<td>' + ((pv.nombre_producto == 'Huevo') ? pv.cantidad + ' Conos' : pv.cantidad + ' Kilos') + '</td>'
                            }
                            _productosTable += '<td>' + price_formatter(pv.subtotal) + '</td>'
                            _productosTable += '<td><a href="<?= base_url(); ?>index.php/Ventas/get_productSalesForID/' + pv.id_producto_venta + '" class="btn btn-outline-primary btn-sm"><i class="fa fa-edit"></i></a> '
                            _productosTable += '<a onclick="delete_productSales(' + pv.id_producto_venta + ',' + pv.id_venta + ',' + row.total + ',' + pv.subtotal + ')" class="btn btn-outline-danger btn-sm text-danger"><i class="fas fa-trash-alt"></i></a>'
                            _productosTable += '</td>'

                            _productosTable += '</tr>'
                        })
                        _productosTable += '</tbody>'
                        _productosTable += '</table>'
                        _productosTable += '<div class="col-md-12" align="right">'
                        _productosTable += '<label>Total a pagar</label>'
                        _productosTable += '<button type="button" id="total" margin-left:20px class="btn btn-outline-primary"> ' + price_formatter(total) + '</button> <br>'
                        _productosTable += '</div>'
                        _productosTable += '<div class="col-md-12" align="right">'
                        _productosTable += '<p name="id_venta" id="dates">' + legend + '</p>'
                        _productosTable += '</div>'
                        //console.log(total)
                        return _productosTable
                    }
                },
            ],
            initComplete: function() {
                this.api().columns().every(function() {
                    var column = this;

                    _id_column = column.header().id;
                    if (_id_column == 'idx' || _id_column == 'folio' || _id_column == 'nota_ventas' || _id_column == 'option' ||
                        _id_column == 'contacto_info' || _id_column == 'detalles_venta' || _id_column == 'status_envio') {

                    } else if (_id_column == 'status_ventas') {
                        var select = $('<select class="form-control"><option value="">Filtrar por: </option></select>')
                            .appendTo($(column.header()))
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + 'Aprobada' + '">' + 'Aprobada' + '</option><option value="' + 'Exitosa' +
                                '">' + 'Exitosa' + '</option><option value="' + 'Pendiente' + '">' + 'Pendiente' + '</option>')
                        });
                    } else if (_id_column == 'fecha_venta') {
                        var select = $('<br><input type="text" class="form-control" placeholder="Filtrar por:" />')
                            .appendTo($(column.header()))
                            .on('keyup change clear', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                if (column.search() !== val) {
                                    column
                                        .search(val ? '^' + val + '-' : '', true, false)
                                        .draw();
                                }
                            })
                    } else {
                        var select = $('<select class="form-control"><option value="">Filtrar por: </option></select>')
                            .appendTo($(column.header()))
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + d + '">' + d + '</option>')
                        });
                    }
                });
            },


        })
        table.on('xhr', function() {
            var json = table.ajax.json();
            var info = table.page.info();
            //console.log(json)

        });
    });

    /* Función para registrar una venta interna  */
    $(document).on('submit', '#venta_int', function(event) {

        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $("#ventaInt_modal").modal('hide');
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL; ?>ventas_internas/api/ventas_internas/",
            method: "POST",
            headers: {
                'X-API-KEY': 'REARNL'
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {

                if (_response.status == 'success') {
                    $("#show_loading").html('');
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Venta registrada con exito',
                        showConfirmButton: false,
                        timer: 1500,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                } else if (_response.status == 'error') {
                    $("#show_loading").html('');
                    $("#ventaInt_modal").modal('show');
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Error interno',
                        text: "'" + _response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                        }
                    })
                }

            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $("#show_loading").html('');
                $("#ventaInt_modal").modal('show');
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Error interno',
                    text: "'" + response + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                    }
                })
            }
        });
    });

    // Example starter JavaScript for disabling form submissions if there are invalid fields
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.getElementsByClassName('needs-validation');
            // Loop over them and prevent submission
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
    /* Fragmento de código para clonar campos del formulario de surtir un pedido */
    var numCols = 1;
    /* Fragmento de código para clonar campos del formulario de surtir un pedido */
    $(document).ready(function() {

        var id = 1;


        // get item

        var item = $("#addparts");

        var before = $('#div_button');

        // initalize event click

        $('#addMore').on('click', function() {
            numCols = numCols + 1;
            //$("#numCol").html(numCols)
            $("#rowTotal").val(numCols);
            $(".rowTotal").html(numCols);
            // clone addparts
            var clone = item.clone(true);
            var btnrem = clone.children("#btnRemove");
            btnrem.html('<label style="color: #fff;">E</label><br><button type="button" class="btn btn-danger btn-sm btnRemove" onclick=removeRow(' + numCols + ') ><i style="color:aliceblue" class="fas fa-minus-square"> </i></button>');

            var kgTag = clone.children("#kg");
            kgTag.html('<label for="">Kilos totales <span class="text-danger">*</span></label>' +
                '<input type="text" class="form-control" placeholder="" onkeyup="get_subtotal(' + numCols + ')" name="kilos[]" id="kilos' + numCols + '" required ' +
                'oninput="cambiar_valor_positivo(this)">');
            var priceTag = clone.children("#price");
            priceTag.html('<label for="">Precio por Kg <span class="text-danger">*</span></label>' +
                '<input type="text" class="form-control" placeholder="$" name="precio[]" onkeyup="get_subtotal(' + numCols + ')"  id="precio' + numCols + '" required ' +
                'oninput="cambiar_valor_positivo(this)">');
            var subTag = clone.children("#subt");
            subTag.html('<label for="">Subtotal <span class="text-danger">*</span></label>' +
                '<input type="text" class="form-control" placeholder="$" name="total[]" id="subtotal' + numCols + '" readonly>' +
                '<input type="hidden" name="id_pago" value="1" readonly>')
            var numRowTag = clone.children("#numRow");
            var areteTag = clone.children("#arete");
            numRowTag.html('<label for="">#</label>' + '<input type="number" class="form-control" placeholder="" value="' + (numCols) + '" disabled>');
            areteTag.html('<label for="">Arete <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="" name="arete[]"  id="arete' + numCols + '" >');
            var grapaTag = clone.children("#grapa");
            grapaTag.html('<label for="">Grapa <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="" name="grapa[]"  id="grapa' + numCols + '" >');
            // remove id
            clone.attr('id', 'addparts' + numCols);
            // add class duplicate
            clone.attr('class', 'row');
            // insert duplicate before button div
            before.before(clone);


        });

    });
    /* Fragmento de código de función para eliminar una fila del formulario de surtir pedido de borregos */


    $("#id_prod").on('change', function() {
        producto = $(this).val();

        var settings = {
            "url": "<?= API_URL; ?>productos/api/productos/id/" + producto,
            "method": "GET",
            "timeout": 0,
            "headers": {
                "x-api-key": "REARNL"
            },
        };

        $.ajax(settings).done(function(response) {
            productName = response.data.nombre_producto;
            if (productName == "Huevo") {
                //console.log("ESte es " + productName)
                $("#arete").hide();
                $("#grapa").hide();
                $("#presentacion_").show();
                $("#text_kilos").html('Conos <span class="text-danger">*</span>');
                // Precio por 
                $("#txt_precio").html('Precio por cono <span class="text-danger">*</span>');

            } else if (productName == "Mojarra") {
                //console.log("ESte es " + productName)
                $("#arete").hide();
                $("#presentacion_").hide();
                $("#grapa").hide();
                $("#text_kilos").html('Kilos <span class="text-danger">*</span>');
                // Precio por 
                $("#txt_precio").html('Precio por Kilo <span class="text-danger">*</span>');

            } else if (productName == "Borrego") {
                //console.log("ESte es " + productName)
                $("#arete").show();
                $("#presentacion_").hide();
                $("#grapa").show();
                $("#text_kilos").html('Kilos <span class="text-danger">*</span>');
                // Precio por 
                $("#txt_precio").html('Precio por Kilo <span class="text-danger">*</span>');

            }

        });


    });

    function sendReceiptByEmail(idVenta) {
        Swal.fire({
            title: '¿Está seguro que desea enviar el recibo de venta mediante correo?',
            text: "El recibo de venta será enviado",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Enviar!'
        }).then((result) => {
            if (result.value) {
                $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
                window.location.href = "<?= base_url() ?>index.php/ventas/send_receipt_by_email/" + idVenta;

            }
        });
    }

    function removeRow(rowNum) {
        $("#addparts" + rowNum).remove();
        numCols = numCols - 1;
        $("#rowTotal").val(numCols);
        $(".rowTotal").html(numCols);
    }

    /* Fragmento de código de función para mostrar subtotal del pedido */
    function get_subtotal(numCol) {
        kilos = $("#kilos" + numCol).val();
        precio = $('#precio' + numCol).val();
        total = kilos * precio;
        $('#subtotal' + numCol).val(total.toFixed());
    }

    /* Fragmento de código de función para mostrar subtotal del pedido */
    function get_subtotal1() {
        kilos = $("#kilos").val();
        precio = $('#precio').val();
        total = kilos * precio;
        $('#subtotal').val(total.toFixed());
    }

    function get_subtotal_edit() {
        cantidad = $("#cantidad_edit").val();
        precio = $('#precio_edit').val();
        total = cantidad * precio;
        $('#subtotal_edit').val(total.toFixed());

    }


    <?php if (@$sales_details) { ?>
        $(document).ready(function() {
            $("#salesEdit_modal").modal('show');
        });
        $(document).on("submit", "#sales_edit", function(event) {
            event.preventDefault();
            $.ajax({
                url: "<?= API_URL . 'ventas_internas/api/ventas_internas/id/' . $sales_details->id_venta ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "REARNL",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;

                    $('#add_animals').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Registro actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseJSON);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
            });
        });

    <?php } ?>


    function delete_productSales(_id, idVenta, total, subtotal) {

       // console.log("id venta: " + idVenta + " TOtal :" + total);
        totalVenta = total - subtotal;

        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar este registro, una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Eliminar!'
        }).then((result) => {
            if (result.value) {

                var settings = {
                    "url": "<?= API_URL; ?>ventas_internas/api/updateTotal/id/" + idVenta,
                    "method": "PUT",
                    "timeout": 0,
                    "headers": {
                        "x-api-key": "REARNL",
                        "Content-Type": "application/json"
                    },
                    "data": JSON.stringify({
                        "total": totalVenta
                    }),
                };
                $.ajax(settings).done(function(response) {
                   // console.log(response);
                });

                $.ajax({
                    url: "<?= API_URL; ?>ventas_internas/api/productSales/id/" +
                        _id,

                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "REARNL",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })
    }

    // <?php if (@$productosS_details) { ?>
    //     $(document).ready(function() {
    //         $("#salesEdit_modal").modal('show');
    //     });


    //     $(document).on("submit", "#sales_edit", function(event) {
    //         event.preventDefault();
    //         $.ajax({
    //             url: "<?= API_URL . 'ventas_internas/api/ventas_internas/id/' . $productosS_details->id_producto_venta ?>",
    //             method: "PUT",
    //             headers: {
    //                 "X-API-KEY": "REARNL",
    //             },
    //             data: $(document).find(this).serialize(),
    //             success: function(_response) {
    //                 response = _response.message;

    //                 $('#add_animals').modal('hide')
    //                 Swal.fire({
    //                     position: 'center',
    //                     icon: 'success',
    //                     title: 'Registro actualizado con exito',
    //                     showConfirmButton: false,
    //                     timer: 2500,
    //                     onAfterClose: () => {
    //                         window.location.reload();
    //                         show_loading();
    //                     }
    //                 })
    //             },
    //             error: function(error) {
    //                 response = JSON.stringify(error.responseJSON);
    //                 Swal.fire({
    //                     position: 'center',
    //                     icon: 'error',
    //                     title: 'Ha ocurrido un error interno',
    //                     text: "'" + response.message + "'",
    //                     showConfirmButton: true,
    //                     onAfterClose: () => {
    //                         window.location.reload();
    //                         show_loading();
    //                     }
    //                 })
    //             },
    //         });
    //     });

    // <?php } ?>


    <?php if (@$productosS_details) { ?>
        $(document).ready(function() {
            $("#ProductsEdit_modal").modal('show');
        });
        $(document).on("submit", "#Productssales_edit", function(event) {
            event.preventDefault();
            $.ajax({
                url: "<?= API_URL . 'ventas_internas/api/product_sales/id/' . $productosS_details->id_producto_venta ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "REARNL",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;

                    $('#add_animals').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Registro actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseJSON);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
            });
        });

    <?php } ?>
</script>