<table class="table table-body" style="border: 1px solid #fff;  width: 100%;">
    <?php if ($product == 'Mojarra') { ?>
        <thead>
            <tr class="thead">
                <th scope="col">N.°</th>
                <th scope="col">Descripción</th>
                <th scope="col">Cantidad</th>
                <th scope="col">Precio por kilo</th>
                <th scope="col">Subtotal de línea</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $total = 0;
            foreach ($products_sale as $i => $ps) {
                $total = $total + $ps->subtotal;
            ?>
                <tr>
                    <td scope="row"><?= $i + 1 ?></td>
                    <td><?= $ps->nombre_producto . ' ' . $ps->raza; ?></td>
                    <td><?= $ps->cantidad . ' Kilos'; ?></td>
                    <td>$<?= number_format($ps->precio, '2', '.', ','); ?></td>
                    <td class="subtotal">$<?= number_format($ps->subtotal, '2', '.', ','); ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="4" style="text-align: right; font-weight: bold;">Total</td>
                <td class="subtotal">$<?= number_format($total, '2', '.', ','); ?></td>
            </tr>
        </tbody>
    <?php }  else if ($product == 'Huevo') { ?>
        <thead>
            <tr class="thead">
                <th scope="col">N.°</th>
                <th scope="col" style="width:130px">Descripción</th>
                <th scope="col">Cantidad</th>
                <th scope="col" style="width:100px">Presentación</th>
                <th scope="col" style="width:90px">Total unidades</th>
                <th scope="col" style="width:90px">Precio unitario</th>
                <th scope="col" style="width:80px">Precio</th>
                <th scope="col">Descuento</th>
                <th scope="col">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $total = 0;
            foreach ($products_sale as $i => $ps) {
                $total = $total + $ps->subtotal;
            ?>
                <tr>
                    <td scope="row"><?= $i + 1 ?></td>
                    <td><?= $ps->nombre_producto . ' ' . $ps->raza; ?></td>
                    <td><?= $ps->cantidad; ?></td>
                    <?php if($ps->presentacion){?>
                    <td><?= 'Cono ' . $ps->presentacion . ' piezas'; ?></td>
                    <td><?= $ps->presentacion * $ps->cantidad; ?></td>
                    <td>$<?= number_format($ps->precio / $ps->presentacion, '2', '.', ','); ?></td>
                    <?php } else{ ?>
                        <td><?= 'Cono 30 piezas'; ?></td>
                    <td><?= 30 * $ps->cantidad; ?></td>
                    <td>$<?= number_format($ps->precio / 30, '2', '.', ','); ?></td>
                   <?php } ?>
                    <td>$<?= number_format($ps->precio, '2', '.', ','); ?></td>
                    <td>$<?= number_format((@$ps->descuento ? $ps->descuento : 0 ), '2', '.', ','); ?></td>
                    <td class="subtotal">$<?= number_format($ps->subtotal, '2', '.', ','); ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="8" style="text-align: right; font-weight: bold;">Total</td>
                <td class="subtotal">$<?= number_format($total, '2', '.', ','); ?></td>
            </tr>
        </tbody>
    <?php } else if ($product == 'Borrego') { ?>
        <thead>
            <tr class="thead">
                <th scope="col">N.°</th>
                <th scope="col">Descripción</th>
                <th scope="col">Arete</th>
                <th scope="col">Grapa</th>
                <th scope="col">Peso</th>
                <th scope="col">Precio por kilo</th>
                <th scope="col">Subtotal de línea</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $total = 0;
            foreach ($products_sale as $i => $ps) {
                $total = $total + $ps->subtotal;
            ?>
                <tr>
                    <td scope="row"><?= $i + 1 ?></td>
                    <td><?= $ps->nombre_producto.' '.$ps->raza; ?></td>
                    <td>
                        <?php
                        if ($ps->arete == 0) {
                            echo '---';
                        } else {
                            echo $ps->arete;
                        }
                        ?>
                    </td>
                    <td>
                        <?php
                        if ($ps->grapa == 0) {
                            echo '---';
                        } else {
                            echo $ps->grapa;
                        }
                        ?>
                    </td>
                    <td><?= $ps->cantidad . ' Kilos'; ?></td>
                    <td>$<?= number_format($ps->precio, '2', '.', ','); ?></td>
                    <td class="subtotal">$<?= number_format($ps->subtotal, '2', '.', ','); ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td colspan="6" style="text-align: right; font-weight: bold;">Total</td>
                <td class="subtotal">$<?= number_format($total, '2', '.', ','); ?></td>
            </tr>
        </tbody>
    <?php } ?>
</table>