<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once('vendor/autoload.php');

class reporte_todasVentas extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model("reportes_model");
		
	}
	public function index()
	{
        $data['categorias'] = $this->reportes_model->get_categorias();
		$data['clientes'] = $this->reportes_model->get_clientes();
		$data['body']='reporte/todasVentas';
		$this->load->view('layout/main',$data);

    }
    public function view($id_venta = false){ 

		
		$data['body']='ventas/ver';
		$this->load->view('layout/main',$data);

	}


	public function todas(){

		$categorias=$this->input->post('categoria');
		$cliente=$this->input->post('cliente');
        $desde=$this->input->post('desde');
        $hasta=$this->input->post('hasta');

        $desde1 = strftime('%d-%b-%y', strtotime($_POST['desde']));
        $hasta1 = strftime('%d-%b-%y', strtotime($_POST['hasta']));
		
		/* $fechaT = strftime('%d-%b-%y', strtotime($ventaInt->fecha_venta)); */
        $area=$this->input->post('area_almacen');

		$ventaInt = $this->reportes_model->get_ventasInternas($desde,$hasta,$categorias,$cliente);
		
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->SetHTMLHeader('

        <table class="normal" width="100%">
        <tr>
            <td width="33%"> <img src="'.base_url().'assets/img/logo.jpg" width="95" height="95"> </td>
            <td width="33%" align="center"><h1>Rancho El Arenal</h1></td>
            <td width="33%" style="text-align: right;"><h4>Reporte todas las Ventas </h4> <h5>Desde '.$desde1.' Hasta '.$hasta1.' </h5> </td>
        </tr>
    </table>');
        $mpdf->SetHTMLFooter('
        <table class="normal" width="100%">
        <tr>
            <td width="33%"></td>
            <td width="33%" align="center">{PAGENO}/{nbpg}</td>
            <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
        </tr>
    </table>        ');
        $html = '	
        <table width="100%" class="table table-bordered">
             <thead>
                          <tr>
                          <th>N°</th>
                            <th>Folio</th>
                           
							<th>Cliente</th>
							<th width="12%" >Fecha venta</th>
                            <th>Producto</th>
                            <th>Raza</th>
							
							<th>Arete</th>
                            <th>Grapa</th>
							<th>Cantidad</th>
							<th>Precio Kg</th>
							<th>Subtotal</th>
                        </thead>                   
        ';
        $html .= '<tbody>';
        $total=0;
       
        foreach ($ventaInt as $i => $ventaInt) {

            $i = $i + 1;
           $sub=$ventaInt->subtotal;
                $total=$total+ $sub;
            
			/* setlocale(LC_TIME, "es_MX.UTF-8"); */
			setlocale(LC_TIME, 'spanish');
			$fechaT = strftime('%d-%b-%y', strtotime($ventaInt->fecha_venta));
		
            $html .= '<tr>'
				. '<td>' . $i . '</td>'
				. '<td>' . $ventaInt->folio_venta . '</td>'
				
				. '<td> ' . $ventaInt->nombre_cliente.''.$ventaInt->apellido_paterno_cliente . '</td>'
				. '<td>' . $fechaT . '</td>'
                . '<td>' . $ventaInt->nombre_producto . '</td>'
				. '<td>' . $ventaInt->raza . '</td>'
				. '<td>' . $ventaInt->arete . '</td>'
				. '<td>' . $ventaInt->grapa . '</td>'
               
				. '<td>' . $ventaInt->cantidad.' ' .$ventaInt->tipo . '</td>'
				. '<td> $' . $ventaInt->precio_producto. '</td>'
                . '<td> $ '.$ventaInt->subtotal . '</td>'
                ;
        }
        $html .= '<tr>
                </tr>
                </tbody> 
                <tfoot>

                <tr>
            
                  <th colspan="2">Grant. Total </th>
            
                  <td colspan="8"></td>
                  
				  <th colspan="1"> $ '.$total.'</th>
                  
            
                </tr>
            
              </tfoot>


                </table>
                ';
        $data = '';
        $data .= '
        <style>
            h1 {
            
            }
        </style>';
        $data .= '<img width = "10" src = "assets/img/logo.jpg>';
        $css = file_get_contents('assets/pdf.css');
        /* Impresion y salida del documento */
        $mpdf->WriteHTML($data);
      /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
        $mpdf->SetTitle('Reporte de todas las ventas');
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $mpdf->Output('Reporte_ventas_Rancho_el_arenal.pdf', 'I');
        $mpdf->setFooter('{PAGENO}');

        $mpdf->WriteHTML('Section 1');
        $mpdf->WriteHTML('');

        exit;
        $mpdf->Output();
    }

}

