<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Memento admin_model model
 *
 * This class handles admin_model management related functionality
 *
 * @package		Admin
 * @subpackage	admin_model
 * @author		propertyjar
 * @link		#
 */

class pedidos_model extends CI_Model 
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
	function import_data($save)
	{
		$this->db->insert_batch('ventas', $save); 
	}
	
	function save($save)
	{
		$this->db->insert('ventas',$save);
		return $this->db->insert_id(); 
	}
	
	function get_all()
	{
		$this->db->select('v.*,u.nombre nombre_usuario');
		$this->db->join('usuario u','u.id =v.id_usuario','LEFT');
		$this->db->where('status',1);
		return $this->db->get('ventas v')->result();

    }
   
	
	function get_all_precio()
	{
		$this->db->where('tamano',"kg");
		return $this->db->get('precios')->row();
	}


	function get_all_user()
	{
			return $this->db->get('usuario')->result();
	}
    
    function get_all_venta($id_venta)
	{
		$this->db->select('v.*,p.nombre nombre_producto');
		$this->db->join('productos p','p.id =v.id_producto','LEFT');
        $this->db->where('id_venta',$id_venta);
		return $this->db->get('productos_venta v')->result();
		/* return $this->db->get('productos_venta')->result(); */
    }


	function get_envio($id_venta)
	{
			   $this->db->where('id_venta',$id_venta);
		return $this->db->get('envios')->row();
	}



	function get_id($id_venta)
	{
		
			   $this->db->where('id_venta',$id_venta);
		return $this->db->get('ventas')->row();
	}
	

	
	function update($save,$id_venta)
	{
			   $this->db->where('id_venta',$id_venta);
		       $this->db->update('ventas',$save);
	}

	function update1($save,$id)
	{
			   $this->db->where('id',$id);
		       $this->db->update('productos_venta',$save);
	}

	function update2($save,$id_venta)
	{
			   $this->db->where('id_venta',$id_venta);
		       $this->db->update('ventas',$save);
	}
	
	function delete($id)//delte contact
	{
			   $this->db->where('id',$id);
		       $this->db->delete('ventas');
	}
}