  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <!-- Theme style -->

  <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <section class="content-header">
          <div class="container-fluid">
              <div class="row mb-2">
                  <div class="col-sm-6">
                      <h1>Categorias</h1>
                  </div>
                  <div class="col-sm-6">
                      <ol class="breadcrumb float-sm-right">
                          <button type="button" id="create_button" name="button" data-toggle="modal" data-target="#categoria_modal" class="btn btn-primary">Agregar nuevo</button>
                      </ol>
                  </div>
              </div>
          </div><!-- /.container-fluid -->
      </section>

      <!-- Main content -->
      <section class="content">
          <div class="container-fluid">
              <div class="row">
                  <div class="col-12">
                      <div class="card">
                          <div class="card-header">
                              <h3 class="card-title">Lista de categorias</h3>
                          </div>
                          <div class="card-body">
                              <div class="table-responsive">
                                  <table id="categorias_table" class="table table-bordered table-hover">
                                      <thead>
                                          <tr>
                                               <th><?php echo ('#') ?></th>
                                              
                                              <th><?php echo ('Nombre') ?></th>
                                              <th><?php echo ('Imagen') ?></th>
                                              <th><?php echo ('Acciones') ?> </th>
                                          </tr>
                                      </thead>
                                      <tbody>
                                      </tbody>
                                  </table>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </section>
      <!-- /.content -->
  </div>
  </div>
  <!-- Modal -->
  <div class="modal fade" id="categoria_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h4 class="modal-title" id="myModalLabel"> Agregar categoria</h4>
              </div>
              <form id="categoriaForm" autocomplete="off" class="needs-validation" novalidate>
                  <div class="modal-body">
                  <p>(<span class="text-danger">*</span>) Campos requeridos.</p>
                      <div class="form-group">
                          <div class="col-md-13">
                              <label for="name" style="clear:both;">Nombre<span class="text-danger">*</span></label>
                              <input type="text" name="nombre" id="nombre" placeholder="Nombre de la categoria" class="form-control" required>
                          </div>
                          <div class="form-group col-md-6">
                                  <label for="">Fotografia</label>
                                  <input type="file"  class="form-control-file" name="imagen" required>
                              </div>
                      </div>
                  </div>
                  <div class="modal-footer btns">
                      <button type="submit" class="btn btn-primary">Guardar</button>
                  </div>
              </form>
          </div>
      </div>
  </div>
  <script src="<?= base_url(); ?>/assets/plugins/jquery/jquery.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
  <script src="<?php echo base_url('assets/js/plugins/iCheck/icheck.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo base_url('assets/js/plugins/sweetalert2/dist/sweetalert2.all.min.js') ?>"></script>
  <script src="<?= base_url('assets/scripts/categorias.js') ?>"></script>


  </body>


  <script>
    // Example starter JavaScript for disabling form submissions if there are invalid fields
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.getElementsByClassName('needs-validation');
            // Loop over them and prevent submission
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
</script>
  </html>