<?php
if (!isset($_SESSION)) {
    session_start();
}
?>
<!--   <!-- DataTables -->
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
<!-- Theme style -->
<style>
    .pdfobject-container {
        height: 40rem;
        border: 1rem solid rgba(0, 0, 0, .1);
    }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Clientes prioritarios</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <button type="button" id="create_button" name="button" data-toggle="modal" data-target="#regis_modal" class="btn btn-primary">Agregar nuevo</button>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Lista de prioritarios</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="productos_table" class="table table-bordered table-hover ">
                                    <thead>
                                        <tr>
                                            <th><?php echo ('#') ?></th>
                                            <th><?php echo ('Nombre') ?></th>
                                            <th><?php echo ('Telefono') ?></th>
                                            <th><?php echo ('Correo') ?></th>
                                            <th><?php echo ('Contraseña Temporal') ?></th>
                                            <th><?php echo ('CURP') ?></th>
                                            <th><?php echo ('Acciones') ?></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
</div>


<div class="modal fade" id="client_modal" tabindex="-1" role="dialog" aria-labelledby="my">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel"></h4>
            </div>
            <div class="row">
                <div class="col-md-2">
                </div>
                <div class="col-md-8">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <img class="profile-user-img img-fluid img-circle" src="<?php echo base_url('assets/dist/img/avatar.png') ?>" alt="User profile picture">
                            </div>
                            <h3 class="profile-username text-center" id="nombreC"> </h3>
                            <p class="text-muted text-center" id="company"></p>
                            <ul class="list-group list-group-unbordered mb-3">
                                <li class="list-group-item">
                                    <b>Telefono:</b> <a id="telefonoC"></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Correo electronico: </b> <a id="correoC"></a>
                                </li>
                            </ul>
                            <div class="text-center">
                                <a id="doc" class="text-muted"> </a>

                            </div>

                        </div>
                    </div>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Dirección</h3>
                        </div>
                        <div class="card-body">
                            <strong id="paisC"><i class="fas fa-map-marker-alt mr-1"></i></strong>

                            <p id="direccionC" class="text-muted"> </p>

                            <a id="direc" class="text-muted"> </a>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- Modal -->



<div class="modal fade" id="Agregar1_modal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Añadir dirección</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                <form id="add_dire" autocomplete="off" class="needs-validation" novalidate>
                    (<span class="text-danger">*</span>) Campos requeridos
                    
                        <div class="form-group row">
                            <div class="col-md-4">
                                <label for="c_postal_zip" class="text-black">Código postal<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="c_postal_zip" name="cp" placeholder="Ingrese su código postal" value="<?= $a = $is_address ?  $address->cp : '' ?>">
                            </div>
                            <div class="col-md-4">
                                <label for="c_state" class="text-black">Estado<span class="text-danger">*</span></label>
                                <select name="estado" id="c_state" class="form-control">
                                    <option value="" selected="selected" disabled="disabled">Selecciona un estado</option>
                                    <option value="Guanajuato" <?= $a = $is_address ? ($address->estado == 'Guanajuato' ? 'selected="selected"' : '') : '' ?>>Guanajuato</option>
                                    <option value="Querétaro" <?= $a = $is_address ? ($address->estado == 'Querétaro' ? 'selected="selected"' : '') : '' ?>>Querétaro</option>
                                    <option value="San Luis Potosí" <?= $a = $is_address ? ($address->estado == 'San Luis Potosí' ? 'selected="selected"' : '') : '' ?>>San Luis Potosí</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="c_postal_zip" class="text-black">Delegación / Municipio <span class="text-danger">*</span></label>
                                <select name="municipio" id="c_municipio" class="form-control">
                                    <option value="" selected="selected" disabled="disabled">Selecciona un municipio</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            
                            <div class="col-md-4">
                                <label for="c_localidad" class="text-black">Localidad/colonia<span class="text-danger">*</span></label>
                                <select name="colonia" id="c_localidad" class="form-control">
                                    <option value="" selected="selected" disabled="disabled">Selecciona un localidad</option>
                                </select>
                            </div>
                            <div class="col">
                            <label for="">Calle <span class="text-danger">*</span></label>
                            <input name="calle" id="street_client" class="form-control" placeholder="Ingrese calle" required>
                            <input type="hidden" id="id_cliente" name="id_cliente">
                        </div>

                        </div>
                        <div class="row">
                            <div class="col-4">
                                <label for="">Número Exterior</label>
                                <input name="numero_exterior" id="ext_num" class="form-control" placeholder="Ingrese # exterior" required>
                            </div>
                            <div class="col-4">
                                <label for="">Número Interior</label>
                                <input name="numero_interior" id="int_num" class="form-control" placeholder="Ingrese # interior">
                            </div>

                        </div>
                        <p>Calles de referencia </p>
                        <div class="row">
                            <div class="col">
                                <label for="">Calle #1</label>
                                <input name="calle1" id="street_ref_client" class="form-control" placeholder="Ingrese calle #1 de referencia">
                            </div>
                            <div class="col">
                                <label for="">Calle #2</label>
                                <input name="calle2" id="street_ref2_client" class="form-control" placeholder="Ingrese calle #2 de referencia">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="">Indicaciones<span class="text-danger">*</span></label>
                                <textarea name="indicaciones" id="ind_client" class="form-control" placeholder="Ingrese indicaciones sobre el domicilio"></textarea>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="identificacion_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">

                <h4 class="modal-title" id="myModalLabel">Documento de Identificación Oficial</h4>
            </div>
            <div class="modal-body" id="documento_ver">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar Ventana</button>

            </div>
        </div>
    </div>
</div>
</body>

</html>
<div class="modal fade" id="regis_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel"> Agregar Nuevo cliente </h4>
            </div>
            <form id="clientePri_Form" autocomplete="off" class="needs-validation" novalidate>
                <div class="modal-body">
                    <div class="form-group">

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="inputEmail4">CURP </label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" placeholder="VESGDGHH323MS32" onkeyup="mayus(this);" name="curp_cliente" id="curp" aria-describedby="button-addon2">

                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="button" id="button-addon2"><span class="fas fa-search"></span></button>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <label>Nombre(s) <span class="text-danger">*</span></label>
                                <div id="name">
                                    <input type="text" class="form-control" placeholder=" UPU800825569" name="nombre_cliente" id="client_name">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="">Apellido Paterno <span class="text-danger">*</span></label>
                                <div id="father_name">
                                    <input type="text" class="form-control" placeholder="Smith" name="apellido_paterno_cliente" id="client_father_name" required>
                                    <div class="invalid-feedback">
                                        Ingrese un apellido paterno.
                                    </div>
                                </div>

                            </div>
                            <div class="form-group col-md-6">
                                <label for="">Apellido Materno <span class="text-danger">*</span></label>
                                <div id="mother_name">
                                    <input type="text" class="form-control" placeholder="Ahn" name="apellido_materno_cliente" id="client_mother_name">
                                    <div class="invalid-feedback">
                                        Ingrese un apellido materno.
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="">Teléfono <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" maxlength="10" oninput="if(this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" placeholder="12345678901" name="telefono_cliente" id="client_phone" required>
                                <div class="invalid-feedback">
                                    Ingrese un Teléfono valido.
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="">Correo electrónico <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="example@gmail.com" name="email_cliente" id="client_email">
                                <input type="hidden" name="tipo_cliente" value="2">
                                <div class="invalid-feedback">
                                    Ingrese un correo valido.
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-12" id="campo_file">
                                    <label for="">Documento de identificación oficial <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" id="id_file" name="identificacion_cliente" >
                                    <div class="invalid-feedback">
                                        Campo requerido.
                                    </div>
                                </div>
                            </div>
                            <p class="text-danger">Puede subir imagen o documento pdf (INE, licencia de conducir o otro). El documento debe ser visible.</p>
                        </div>
                        <div class="modal-footer btns">
                            <button type="submit"  class="btn btn-primary">Guardar</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.2.4/pdfobject.min.js" integrity="sha512-mW7siBAOOJTkMl77cTke1Krn+Wz8DJrjMzlKaorrGeGecq0DPUq28KgMrX060xQQOGjcl7MSSep+/1FOprNltw==" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.2.4/pdfobject.js" integrity="sha512-pOkH5W0iYlsujt/wd8KQwGJlc76bfVQ+gN3wNj2jE671otBKfTqSU17mdb74MdGqU2G7ScJqH9BqQ8UvWL0hdg==" crossorigin="anonymous"></script>
<script src="<?= base_url(); ?>/assets/plugins/jquery/jquery.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="<?php echo base_url('assets/js/plugins/iCheck/icheck.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo base_url('assets/js/plugins/sweetalert2/dist/sweetalert2.all.min.js') ?>"></script>
<script src="<?= base_url('assets/scripts/clientesPri.js') ?>"></script>

<script>
    function mayus(e) {
        e.value = e.value.toUpperCase();
    }


    $("#button-addon2").on('click', function() {
        //documentación: https://www.notion.so/CURP-Renapo-API-392135e5a30a4ff59162325c4f76a9ec
        //obtener la curp del cliente
        curp = $("#curp").val();
        //api key o token generado 
        api_key = 'tz1vxlBRBKbiAJynoMWUBZDEBKu2';
        var ajax_load = '<div class="clearfix"><div class="spinner-border text-secondary' +
            'float-left" role="status"><span class="sr-only">Loading...</span></div></div>';
        $("#name").html(ajax_load);
        $("#father_name").html(ajax_load);
        $("#mother_name").html(ajax_load);
        $.ajax({
            method: "GET",
            //URL de la api
            url: "https://us-west4-arsus-production.cloudfunctions.net/curp?curp=" + curp + '&apiKey=' + api_key,
            dataType: "json",
            success: function(response) {

                $("#name").html('<input type="text" class="form-control" readonly placeholder="John" name="nombre_cliente" id="client_name" value="' + response.name + '">');
                $("#father_name").html('<input type="text" class="form-control" readonly placeholder="Smith" name="apellido_paterno_cliente" id="client_father_name" value="' + response.fatherName + '">');
                $("#mother_name").html('<input type="text" class="form-control" readonly placeholder="Ahn" name="apellido_materno_cliente" id="client_mother_name" value="' + response.motherName + '">');
            },
            error: function(error) {
                Swal.fire({
                    position: 'top-center',
                    icon: 'error',
                    title: 'CURP invalida',
                    text: '¡Ingrese una CURP valida!',
                })


                $("#name").html('<input type="text" class="form-control" readonly placeholder="John" name="client_name" id="client_name">');
                $("#father_name").html('<input type="text" class="form-control" readonly placeholder="Smith" name="client_father_name" id="client_father_name">');
                $("#mother_name").html('<input type="text" class="form-control" readonly placeholder="Ahn" name="client_mother_name" id="client_mother_name">');
            }
        });
    })

    $('.value-plus').on('click', function() {
        var divUpd = $(this).parent().find('.value'),
            newVal = parseInt(divUpd.text(), 10) + 1;
        divUpd.text(newVal);
    });

    $('.value-minus').on('click', function() {
        var divUpd = $(this).parent().find('.value'),
            newVal = parseInt(divUpd.text(), 10) - 1;
        if (newVal >= 1) divUpd.text(newVal);
    });

    function ordenarSelect(id_componente) {
        var selectToSort = jQuery('#' + id_componente);
        var optionActual = selectToSort.val();
        selectToSort.html(selectToSort.children('option').sort(function(a, b) {
            return a.text === b.text ? 0 : a.text < b.text ? -1 : 1;
        })).val(optionActual);
    }
</script>

<script>
    // Example starter JavaScript for disabling form submissions if there are invalid fields
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.getElementsByClassName('needs-validation');
            // Loop over them and prevent submission
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
</script>

<!-- <script>
    document.getElementById("file").onchange = function(e) {
  // Creamos el objeto de la clase FileReader
  let reader = new FileReader();

  // Leemos el archivo subido y se lo pasamos a nuestro fileReader
  reader.readAsDataURL(e.target.files[0]);

  // Le decimos que cuando este listo ejecute el código interno
  reader.onload = function(){
    let preview = document.getElementById('preview'),
            image = document.createElement('img');

    image.src = reader.result;

    preview.innerHTML = '';
    preview.append(image);
  };
}
</script> -->

<script src="https://mozilla.github.io/pdf.js/build/pdf.js" type="text/javascript"></script>
<script>
    //se crea un atajo para acceder a PDF.js exports
    var pdfjsLib = window['pdfjs-dist/build/pdf'];
    //la propiedad de recurso d trabajo (workerSrc) es especificado
    pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://mozilla.github.io/pdf.js/build/pdf.worker.js';
    //funcion para obtenr el documento en miniatura
    $("#id_file").on("change", function(e) {
        //guardamos la extensión del archivo
        var ext = $(this).val().split('.').pop();
        //verificamos si existe el elemento con el id pdfViewer
        if ($("#pdfViewer").length > 0) {
            //eliminamos el elemento
            $("#pdfViewer").remove();
        }
        //verificamos si existe el elemento con el id previewImage
        if ($("#previewImage").length > 0) {
            //eliminamos elemento
            $("#previewImage").remove();
        }
        //cambiamos el tamaño del input del archivo, para ajustar la miniatura del documento
        $("#campo_file").removeClass("col-md-12").addClass("col-md-8");
        //si el campo contiene valor
        if ($(this).val() != '') {
            //si ees un documento en formato PDF
            if (ext == "pdf") {
                //creamos una varible llamadaa canvas y almacenamos una etiqueta div y canvas
                //para adjustar la miniatura del archivo
                canvas = '<div class="col-md-2"><canvas id="pdfViewer"></canvas></div>';
                //insertamos el elemento despues del div que corrsponde al input del archivo
                $("#campo_file").after(canvas);
                var file = e.target.files[0]
                //si el archivo es pdf
                if (file.type == "application/pdf") {
                    //creamos objcto de tipo filereader
                    var fileReader = new FileReader();
                    //accedemos al metodo onload para cargar el archivo
                    fileReader.onload = function() {
                        var pdfData = new Uint8Array(this.result);
                        //usamos DocumntInitParmeters objeto para cargar los datos binarios
                        var loadingTask = pdfjsLib.getDocument({
                            data: pdfData
                        });
                        loadingTask.promise.then(function(pdf) {
                            console.log('PDF loaded');

                            // Cargamos la primera pagina
                            var pageNumber = 1;
                            pdf.getPage(pageNumber).then(function(page) {
                                //console.log('Page loaded');
                                //pagina cargada
                                var scale = 0.2;
                                var viewport = page.getViewport({
                                    scale: scale
                                });

                                // Prepaara  el canvas usando las dimensiones de la pagina del PDF
                                var canvas = $("#pdfViewer")[0];
                                var context = canvas.getContext('2d');
                                canvas.height = viewport.height;
                                canvas.width = viewport.width;

                                // Renderiza la pagin del PDF dentro del contexto del canvas
                                var renderContext = {
                                    canvasContext: context,
                                    viewport: viewport
                                };
                                var renderTask = page.render(renderContext);
                                renderTask.promise.then(function() {
                                    //console.log('Page rendered');
                                    //Pagina rendrizadaa
                                });
                            });
                        }, function(reason) {
                            // En caso de error
                            console.error(reason);
                        });
                    };
                    fileReader.readAsArrayBuffer(file);
                }
            } else if (ext == "jpeg" || ext == "jpg" || ext == "png") {
                //si el usuario esta subiendo una imagen
                //console.log("Image");
                //etiquet div para mostrar imagen
                div = '<div class="col-md-2"><div id="previewImage"></div></div>';
                $("#campo_file").after(div);
                //creamos un objecto filereader
                let reader = new FileReader();
                //cargarmos la imagen
                reader.onload = function() {
                    //obtenemos el elemento donde se visualizara la imagen en miniatura
                    let preview = document.getElementById('previewImage'),
                        //creamos el elemento imagen
                        image = document.createElement('img');

                    image.src = reader.result;
                    image.height = "100";
                    image.width = "100";
                    preview.innerHTML = '';
                    //insertamos la imagen en la etiqueta en la cual se visualizara
                    preview.append(image);
                };

                reader.readAsDataURL(e.target.files[0]);
            } else {
                //Si el archivo es incorrecto o no permitido
                $(this).val('');
                //alert("Archivo no permitido, " + 'debe subir un archivo en formato PDF o en Imagen');
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato PDF o en Imagen',
                    icon: 'error'

                });
                $("#campo_file").removeClass("col-md-8").addClass("col-md-12");
            }
        }
    });
</script> -->

<script>
    function ordenarSelect(id_componente) {
        var selectToSort = jQuery('#' + id_componente);
        var optionActual = selectToSort.val();
        selectToSort.html(selectToSort.children('option').sort(function(a, b) {
            return a.text === b.text ? 0 : a.text < b.text ? -1 : 1;
        })).val(optionActual);
    }


    $(document).ready(function() {
        ordenarSelect('c_municipio');
        <?php if ($is_address) { ?>
            var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
            var method_sepomex = 'info_cp/';
            var codigo_postal = $('#c_postal_zip').val();
            var variable_string = '?type=simplified';
            var url = endpoint_sepomex + method_sepomex + codigo_postal + variable_string;
            $.ajax({
                type: "GET",
                url: url,
                dataType: "json",
                success: function(data) {

                    estado = data.response.estado;
                    municipio = data.response.municipio;
                    localidades = data.response.asentamiento;

                    if (estado == 'San Luis Potosí') {
                        $("#c_state").val(estado);
                        get_municipios(estado, municipio);
                        for (let i = 0; i < localidades.length; i++) {
                            const localidad = localidades[i];
                            selected = '';
                            if (localidades.length == 1) {
                                selected = 'selected';
                            } else {
                                if (localidad == localidades[0]) {
                                    selected = 'selected';
                                }
                            }

                            options = '<option value="' + localidad + '"' + selected + '>' + localidad + '</option>';
                            $("#c_localidad").append(options);

                        }
                        ordenarSelect('c_localidad');
                    } else if (estado == 'Guanajuato') {
                        $("#c_state").val(estado);
                        get_municipios(estado, municipio);
                        for (let i = 0; i < localidades.length; i++) {
                            const localidad = localidades[i];
                            selected = '';
                            if (localidades.length == 1) {
                                selected = 'selected';
                            } else {
                                if (localidad == localidades[0]) {
                                    selected = 'selected';
                                }
                            }

                            options = '<option value="' + localidad + '"' + selected + '>' + localidad + '</option>';
                            $("#c_localidad").append(options);

                        }
                        ordenarSelect('c_localidad');
                    } else if (estado == 'Querétaro') {
                        $("#c_state").val(estado);
                        get_municipios(estado, municipio);
                        for (let i = 0; i < localidades.length; i++) {
                            const localidad = localidades[i];
                            selected = '';
                            if (localidades.length == 1) {
                                selected = 'selected';
                            } else {
                                if (localidad == localidades[0]) {
                                    selected = 'selected';
                                }
                            }

                            options = '<option value="' + localidad + '"' + selected + '>' + localidad + '</option>';
                            $("#c_localidad").append(options);

                        }
                        ordenarSelect('c_localidad');
                    } else {
                        //$('.selDiv option:contains("Selection 1")')alert(1)
                        $("#c_postal_zip").val(' ');
                        Swal.fire({
                            title: 'Código postal no valido',
                            text: 'No hay servicio para esa area',
                            icon: 'error'

                        });
                    }
                }
            });
        <?php } ?>
    });
    $("#c_postal_zip").change(function() {

        var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
        var method_sepomex = 'info_cp/';
        var codigo_postal = $('#c_postal_zip').val();
        var variable_string = '?type=simplified';
        var url = endpoint_sepomex + method_sepomex + codigo_postal + variable_string;
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function(data) {

                estado = data.response.estado;
                municipio = data.response.municipio;
                localidades = data.response.asentamiento;
                if (estado == 'San Luis Potosí') {
                    $("#c_state").val(estado);
                    get_municipios(estado, municipio);
                    for (let i = 0; i < localidades.length; i++) {
                        const localidad = localidades[i];
                        selected = '';
                        if (localidades.length == 1) {
                            selected = 'selected';
                        } else {
                            if (localidad == localidades[0]) {
                                selected = 'selected';
                            }
                        }

                        options = '<option value="' + localidad + '"' + selected + '>' + localidad + '</option>';
                        $("#c_localidad").append(options);

                    }
                    ordenarSelect('c_localidad');
                } else if (estado == 'Guanajuato') {
                    $("#c_state").val(estado);
                    get_municipios(estado, municipio);
                    for (let i = 0; i < localidades.length; i++) {
                        const localidad = localidades[i];
                        selected = '';
                        if (localidades.length == 1) {
                            selected = 'selected';
                        } else {
                            if (localidad == localidades[0]) {
                                selected = 'selected';
                            }
                        }

                        options = '<option value="' + localidad + '"' + selected + '>' + localidad + '</option>';
                        $("#c_localidad").append(options);

                    }
                    ordenarSelect('c_localidad');
                } else if (estado == 'Querétaro') {
                    $("#c_state").val(estado);
                    get_municipios(estado, municipio);
                    for (let i = 0; i < localidades.length; i++) {
                        const localidad = localidades[i];
                        selected = '';
                        if (localidades.length == 1) {
                            selected = 'selected';
                        } else {
                            if (localidad == localidades[0]) {
                                selected = 'selected';
                            }
                        }

                        options = '<option value="' + localidad + '"' + selected + '>' + localidad + '</option>';
                        $("#c_localidad").append(options);

                    }
                    ordenarSelect('c_localidad');
                } else {
                    //$('.selDiv option:contains("Selection 1")')alert(1)
                    $("#c_postal_zip").val(' ');
                    Swal.fire({
                        title: 'Código postal no valido',
                        text: 'No hay servicio para esa area',
                        icon: 'error'

                    });
                }

            }
        });

    });

    function get_municipios(estado, m) {
        $("#c_municipio").text('');
        $("#c_municipio").append('<option value="" selected="selected" disabled="disabled">Selecciona un municipio</option>');
        $("#c_localidad").text('');
        $("#c_localidad").append('<option value="" selected="selected" disabled="disabled">Selecciona un localidad</option>');
        var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
        var method_sepomex = 'get_municipio_por_estado/';
        var variable_string = '?type=simplified';
        var url = endpoint_sepomex + method_sepomex + estado + variable_string;
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function(data) {
                // console.log(data.response)
                municipios = data.response.municipios;
                for (let i = 0; i < municipios.length; i++) {
                    //const municipio = normalize(municipios[i]);
                    const municipio = municipios[i];
                    //console.log(municipio);
                    selected = '';
                    if (municipio == m) {
                        selected = 'selected';
                    }
                    options = '<option value="' + municipio + '"' + selected + '>' + municipio + '</option>';
                    $("#c_municipio").append(options);

                }
                ordenarSelect('c_municipio');
            }
        });
    }

    $("#c_state").change(function() {
        // alert($('#c_state').val());
        $("#c_municipio").text('');
        $("#c_municipio").append('<option value="" selected="selected" disabled="disabled">Selecciona un municipio</option>');
        $("#c_localidad").text('');
        $("#c_localidad").append('<option value="" selected="selected" disabled="disabled">Selecciona un localidad</option>');
        var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
        var method_sepomex = 'get_municipio_por_estado/';
        var estado = $('#c_state').val();
        var variable_string = '?type=simplified';
        var url = endpoint_sepomex + method_sepomex + estado + variable_string;
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function(data) {
                // console.log(data.response)
                municipios = data.response.municipios;
                console.log(municipios)
                for (let i = 0; i < municipios.length; i++) {
                    //const municipio = normalize(municipios[i]);
                    const municipio = municipios[i];
                    //console.log(municipio);
                    options = '<option value="' + municipio + '">' + municipio + '</option>';
                    $("#c_municipio").append(options);

                }
                ordenarSelect('c_municipio');
            }
        });

    });
    $("#c_municipio").change(function() {
        // alert($('#c_state').val());
        $("#c_localidad").text('');
        $("#c_localidad").append('<option value="" selected="selected" disabled="disabled">Selecciona un localidad</option>');
        var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
        var method_sepomex = 'get_colonia_por_municipio/';
        var municipio = $('#c_municipio').val();
        var variable_string = '?type=simplified';
        var url = endpoint_sepomex + method_sepomex + municipio + variable_string;
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function(data) {
                console.log(data.response)
                localidades = data.response.colonia;
                for (let i = 0; i < localidades.length; i++) {
                    //const municipio = normalize(municipios[i]);
                    const localidad = localidades[i];
                    //console.log(municipio);
                    options = '<option value="' + localidad + '">' + localidad + '</option>';
                    $("#c_localidad").append(options);

                }
                ordenarSelect('c_localidad');
            }
        });

    });
    $("#c_localidad").change(function() {
        // alert($('#c_state').val());
        //$("#c_postal_zip").text('');
        //$("#c_localidad").append('<option value="" selected="selected" disabled="disabled">Selecciona un localidad</option>');
        var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
        var method_sepomex = 'search_cp_advanced/';
        var estado = $("#c_state").val();
        var municipio = $('#c_municipio').val();
        var localidad = $("#c_localidad").val();
        var variable_string = '?type=simplified';
        var url = endpoint_sepomex + method_sepomex + estado + '?limit=1&municipio=' + municipio + '&colonia=' + localidad;
        console.log(url)
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function(data) {
                codigo_postal = data.response.cp[0];
                $("#c_postal_zip").val(codigo_postal);
            }
        });

    });
    $(document).ready(function() {
        var endpoint_sepomex = "http://api-sepomex.hckdrk.mx/query/";
        var method_sepomex = 'info_cp/';
        var cp = "09810";
        var variable_string = '?type=simplified';
        var url = endpoint_sepomex + method_sepomex + cp + variable_string;
        $.ajax({
            type: "GET",
            url: url,
            dataType: "json",
            success: function(response) {
                console.log(response.response)
            }
        });
        // $.get(url){
        //     .done(function( data ) {
        //         var content = JSON.parse(data);

        //         if((content[0].error){
        //             console.log('Algo salio mal');
        //         }else{
        //             console.log('Todo bien');
        //         }
        // });


    });
</script>