  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <!-- Theme style -->


  <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <section class="content-header">
          <div class="container-fluid">
              <div class="row mb-2">
                  <div class="col-sm-6">
                      <h1>Productos</h1>
                  </div>
                  <div class="col-sm-6">
                      <ol class="breadcrumb float-sm-right">
                          <button type="button" id="create_button" name="button" data-toggle="modal" data-target="#productos_add" class="btn btn-primary">Agregar nuevo</button>
                      </ol>
                  </div>
              </div>
          </div><!-- /.container-fluid -->
      </section>

      <!-- Main content -->
      <section class="content">
          <div class="container-fluid">
              <div class="row">
                  <div class="col-12">
                      <div class="card">
                          <div class="card-header">
                              <h3 class="card-title">Lista de productos</h3>

                          </div>


                          <!-- /.card-header -->
                          <div class="card-body">

                              <table id="example2" class="table table-bordered table-hover">
                                  <thead>
                                      <tr>
                                          <th><?php echo ('#') ?></th>
                                          <th><?php echo ('Imagen') ?></th>
                                          <th><?php echo ('Nombre') ?></th>
                                          <th><?php echo ('Descripcion') ?></th>
                                          <th><?php echo ('Precio por kilo') ?></th>
                                          <th><?php echo ('Stock') ?></th>
                                          <th><?php echo ('Categoria') ?></th>
                                          <th><?php echo ('Peso') ?></th>
                                          <th><?php echo ('Raza') ?></th>
                                          <th><?php echo ('Acciones') ?> </th>
                                      </tr>
                                  </thead>
                                  <?php if (isset($productos)) : ?>
                                      <tbody>
                                          <?php $i = 1;
                                            foreach ($productos as $new) { ?>
                                              <tr class="gc_row">
                                                  <td><?php echo $i ?></td>
                                                  <td><img src="<?=base_url();?>assets/uploads/images/<?php echo $new->imagen ?>" alt="" srcset="" width="80px" height="80px"></td>
                                                  <td><?php echo $new->nombre ?></td>
                                                  <td><?php echo $new->descripcion ?></td>
                                                  <td><?php echo "$ " . $new->precio ?></td>
                                                  <td><?php echo $new->inventario ?></td>
                                                  <td><?php echo $new->nombre_categoria ?></td>
                                                  <td><?php echo $new->peso ?></td>
                                                  <td><?php echo $new->raza ?></td>
                                                  <td >
                                                      
                                                          <a class="btn btn-primary btn-sm" href="<?php echo site_url('productos/edit/' . $new->id); ?>"> <i class="fas fa-edit"></i></a>
                                                          <a class="btn btn-danger btn-sm remove" href="<?php echo site_url('productos/delete/' . $new->id); ?>"> <i style='color:aliceblue' class="fas fa-trash-alt"></i> </a>

                                                  </td>
                                              </tr>
                                          <?php $i++;
                                            } ?>
                                      </tbody>
                                  <?php endif; ?>
                              </table>
                          </div>
                          <!-- /.card-body -->
                      </div>
                      <!-- /.card -->


                      <!-- /.card -->
                  </div>
                  <!-- /.col -->
              </div>
              <!-- /.row -->
          </div>
          <!-- /.container-fluid -->
      </section>
      <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <!-- /.control-sidebar -->
  </div>





  <script src="<?= base_url() ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
  <script src="<?= base_url() ?>assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>


  <script>
      $(document).ready(function() {
          $('#example2').DataTable({
              "language": {
                  "decimal": "",
                  "emptyTable": "No hay información",
                  "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                  "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                  "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                  "infoPostFix": "",
                  "ihousands": ",",
                  "lengthMenu": "Mostrar _MENU_ Entradas",
                  "loadingRecords": "Cargando...",
                  "processing": "Procesando...",
                  "search": "Buscar:",
                  "zeroRecords": "Sin resultados encontrados",
                  "paginate": {
                      "first": "Primero",
                      "last": "Ultimo",
                      "next": "Siguiente",
                      "previous": "Anterior"
                  }
              },


          });
      });
  </script>

  <!-- Modal -->
  <div class="modal fade" id="productos_add" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">

                  <h4 class="modal-title" id="myModalLabel"><?php if (@$productos_update) { ?> Editar producto <?php } else { ?> Agregar producto <?php } ?></h4>
              </div>

              <?php if (@$productos_update) { ?>
                  <?php echo form_open_multipart('productos/edit/' . $productos_id, array("autocomplete" => "off")); ?>
              <?php } else { ?>
                  <?php echo form_open_multipart('productos/add/'); ?>
              <?php } ?>
              <div class="modal-body">
                  <div class="form-group">

                      <div class="col-md-13">
                          <label for="name" style="clear:both;">Nombre</label>
                          <input type="text" name="nombre" placeholder="Nombre del producto" value="<?= isset($productos_update) ? $productos_update->nombre : set_value('nombre'); ?>" class="form-control" required>
                      </div>
                      <div class="col-md-13">
                          <label for="name" style="clear:both;">Descripcion</label>
                          <input type="text" name="descripcion" placeholder="Descripcion" value="<?= isset($productos_update) ? $productos_update->descripcion : set_value('descripcion'); ?>" class="form-control" required>
                      </div>
                      <div class="row">
                          <div class="col-md-7">
                          
                    <label for="exampleInputFile">Imagen</label>
                    
                        <input type="file" class="form-control" name="image" id="exampleInputFile">
                       
                  
                              <!-- <label for="name" style="clear:both;">Imagen</label>
                              <input type="text" name="imagen" placeholder="Imagen" value="<?= isset($productos_update) ? $productos_update->imagen : set_value('imagen'); ?>" class="form-control" required> -->
                          </div>
                          <div class="col-md-5">
                              <label for="name" style="clear:both;">Precio</label>
                              <div class="input-group mb-2">
                                  <div class="input-group-prepend">
                                      <div class="input-group-text">$</div>
                                  </div>
                                  <input type="number" name="precio" placeholder="Precio" value="<?= isset($productos_update) ? $productos_update->precio : set_value('precio'); ?>" class="form-control" required>
                              </div>
                          </div>
                      </div>

                      <div class="row">

                      <div class="col-md-7">
                              <label for="name" style="clear:both;">Categoria</label>
                              <select name="id_categoria" class="form-control chzn">
                                    <option value="">--<?php echo ('Seleccione la categoria'); ?>---</option>
                                    <?php foreach ($categorias as $new) {
                                        $sel = "";
                                          if($productos_update->id_categoria== $new->id){
                                            $sel="selected";
                                        } 
                                        echo '<option value="' . $new->id. '" ' . $sel . '>' . $new->nombre . '</option>';
                                    }

                                    ?>
                                </select>
                          </div>

                          <div class="col-md-5">
                          <label for="name" style="clear:both;">Inventario</label>
                              <div class="input-group mb-2">
                                  
                                  <input type="number" name="inventario" placeholder="Inventario" value="<?= isset($productos_update) ? $productos_update->inventario : set_value('inventario'); ?>" class="form-control" required>
                                  <div class="input-group-prepend">
                                      <div class="input-group-text">Unidades</div>
                                  </div>
                              </div>
                          </div>
                          
                      </div>
                      <div class="row">
                      <div class="col-md-7">
                              <label for="name" style="clear:both;">Raza</label>
                              <input type="text" name="raza" placeholder="Raza" value="<?= isset($productos_update) ? $productos_update->raza : set_value('raza'); ?>" class="form-control" required>
                          </div>

                      <div class="col-md-5">
                              <label for="number" style="clear:both;">Peso aproximado</label>
                              <div class="input-group mb-2">
                                  
                                  <input type="text" name="peso" placeholder="Peso" value="<?= isset($productos_update) ? $productos_update->peso : set_value('peso'); ?>" class="form-control" required>
                                  <div class="input-group-prepend">
                                      <div class="input-group-text">kg</div>
                                  </div>
                              </div>
                          </div>
                          
                          
                      </div>
                  </div>

              </div>
              <div class="modal-footer">
                  <?php if (@$productos_update) { ?>
                      <a type="button" class="btn btn-default" href="<?= base_url() ?>index.php/productos">Cancelar</a>
                  <?php } else { ?>
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                  <?php } ?>
                  <button type="submit" class="btn btn-primary">Guardar</button>
              </div>
              <?php form_close() ?>
          </div>
      </div>
  </div>



  </div>
  <script src="<?= base_url(); ?>/assets/plugins/jquery/jquery.min.js"></script>
  <script>
      $(document).ready(function() {
          <?php
            if (@$productos_update) { ?>
              $('#create_button').trigger('click');
          <?php }
            ?>
      });
      $('#productos_add').on('hidden.bs.modal', function(e) {
          window.location = "<?= base_url() ?>index.php/productos.php";

      })
  </script>
  </body>

  </html>