<script>
    /* Función para cargar buscadores en la tabla y poner encabezados y pies de pagina en español  */
    $(document).ready(function() {
        sortSelect('id_cliente');
        $('#pedidos_table').DataTable({
            ordering: false,
            language: {
                decimal: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                ihousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",
                search: "Buscar:",
                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior",
                }
            },
            initComplete: function() {
                this.api().columns().every(function() {
                    var column = this;

                    _id_column = column.header().id;
                    if (_id_column == 'idx' || _id_column == 'folio' || _id_column == 'nota_ventas' ||
                        _id_column == 'contacto_info' || _id_column == 'detalles_venta') {

                    } else if (_id_column == 'status_ventas') {

                    } else if (_id_column == 'fecha_venta') {

                    } else {
                        var select = $('<select class="form-control"><option value="">Filtrar por: </option></select>')
                            .appendTo($(column.header()))
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + d + '">' + d + '</option>')
                        });
                    }
                });
            }

        })
    });

    /* Función para validar formulario de registro de pedidos */
    $(document).ready(function() {
        $("#pedido_form").validate({
            rules: {
                id_cliente: {
                    required: true
                },
                fecha: {
                    required: true
                },
                hora: {
                    required: true
                },
                id_producto: {
                    required: true
                },
                tipo_unidad: {
                    required: true
                },
                cantidad: {
                    required: true
                }
            },
            messages: {
                id_cliente: {
                    required: 'Campo requerido.'
                },
                fecha: {
                    required: 'Campo requerido.'
                },
                hora: {
                    required: 'Campo requerido.'
                },
                id_producto: {
                    required: 'Campo requerido.'
                },
                tipo_unidad: {
                    required: 'Campo requerido.'
                },
                cantidad: {
                    required: 'Campo requerido.'
                }
            },
            errorElement: 'spam',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.field').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
        });
    });

    /* Función para deshabilitar fechas pasadas en el formulario de registro de un pedido */
    $(function() {
        var dtToday = new Date();

        var month = dtToday.getMonth() + 1;
        var day = dtToday.getDate();
        var year = dtToday.getFullYear();

        if (month < 10)
            month = '0' + month.toString();
        if (day < 10)
            day = '0' + day.toString();

        var maxDate = year + '-' + month + '-' + day;
        $('#fecha').attr('min', maxDate);
    });

    /* Función para ordenar el select de clientes de manera alfabetica */
    function sortSelect(component_id) {
        var selectToSort = jQuery('#' + component_id);
        var currentOption = selectToSort.val();
        selectToSort.html(selectToSort.children('option').sort(function(a, b) {
            return a.text === b.text ? 0 : a.text < b.text ? -1 : 1;
        })).val(currentOption);
    }

    /* Función para registrar un pedido  */
    $(document).on('submit', '#pedido_form', function(event) {

        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL; ?>pedidos/api/pedidos_internos/",
            method: "POST",
            headers: {
                'X-API-KEY': 'REARNL'
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 1500,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                })

                Toast.fire({
                    icon: 'success',
                    title: "Venta registrada con exito",
                    onAfterClose: (toast) => {
                        window.location.reload();
                        $("#pedido_modal").modal('hide');

                    }
                })

            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                alert(response);
                console.log(error)
            }
        });
    });

    /* Función para registrar la aprobación de un pedido  */
    $(document).on('submit', '#aprobar_pedido_form', function(event) {

        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        event.preventDefault();
        order_id = $("#order_id").val();
        $.ajax({
            url: "<?= API_URL; ?>pedidos/api/aprobar_pedido/id/" + order_id,
            method: "POST",
            headers: {
                'X-API-KEY': 'REARNL'
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success: function(_response) {
                /* console.log(response) */
                const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 1500,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                })

                Toast.fire({
                    icon: 'success',
                    title: "Pedido surtido con exito exito",
                    onAfterClose: (toast) => {
                        window.location.reload();
                        $("#surtir_pedido_modal").modal('hide');

                    }
                })

            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                alert(response);
            }
        });
    });

    /* Función para cancelar un pedido */
    function cancel_order(order_id) {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        var settings = {
            "url": "<?= API_URL; ?>pedidos/api/cancelar_pedido/id/" + order_id,
            "method": "PUT",
            "timeout": 0,
            "headers": {
                "x-api-key": "REARNL"
            },
        };

        $.ajax(settings).done(function(response) {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 1500,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            })

            Toast.fire({
                icon: 'success',
                title: "Pedido cancelado exitosamente",
                onAfterClose: (toast) => {
                    window.location.reload();
                }
            })
        });
    }
    /* Variable para almacenar el id del producto seleccionado */
    var product_id = '';

    /* Función para obtener información del pedido mediante el id */
    function get_order_by_id(id) {
        $("#show_loading").html('<div class="loading show"><div class="spin"></div></div>');
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>index.php/pedidos/get_order_by_id/" + id,
            success: function(response) {
                order_details = JSON.parse(response);
                if ($(".extracolumns").length) {

                    $(".extracolumns").remove();
                    numCols = 1;

                }

                $("#nombre_cliente").val(order_details.nombre_completo)
                $("#fecha_pedido").val(order_details.fecha)
                $("#hora_pedido").val(order_details.hora)
                $("#comentario_pedido").val(order_details.notas_venta)
                $("#cantidad_pedido").val(order_details.cantidad_pedido)

                $("#order_id").val(order_details.id_venta)
                product_id = order_details.id_producto;
                $("#unidad_tipo").val(order_details.tipo_unidad)


                if (order_details.id_producto == 8) {

                    var fieldsform = '<div class="form-group col-md-3">' +
                        '<label for="name" style="clear:both;">Producto<span class="text-danger">*</span></label>' +
                        '<select class="form-control" name="id_prod[]" id="id_prod">' +
                        '<option value="">-- Producto --</option>' +
                        <?php
                        foreach ($products as $product) { ?> '<option value="<?= $product->id_producto; ?>"><?= $product->nombre_producto ?></option>' +
                        <?php }
                        ?> '</select>' +
                        '</div>' +
                        '<div class="form-group col-md-3">' +
                        '<label for="">Kilos totales<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control kilos" placeholder="" onkeyup="get_subtotal1()" name="kilos[]" id="kilos" required>' +
                        '</div>' +
                        '<div class="form-group col-md-3">' +
                        '<label for="">Precio por Kg<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="$" onkeyup="get_subtotal1()" name="precio[]" id="precio" required>' +
                        '</div>' +
                        '<div class="form-group col-md-3">' +
                        '<label for="">Subtotal<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="$" name="total[]" id="subtotal" readonly>' +
                        '</div>';
                    $("#addparts").html(fieldsform);
                    if (order_details.tipo_unidad == 'Kg') {
                        $(".kilos").val(order_details.cantidad_pedido)
                    }
                    $("#id_prod").val(order_details.id_producto)
                    $("#div_button").hide();
                    $("#id_prod option").each(function(key, value) {

                        if ($(this).val() != product_id) {
                            $(this).remove();
                        }
                    });
                } else {
                    var formfields = '<div class="form-group col-md-2" id="numRow">' +
                        '<label for="">#</label>' +
                        '<input type="number" class="form-control" placeholder="" value="1" disabled>' +
                        '</div>' +
                        '<div class="form-group col-md-2">' +
                        '<label for="name" style="clear:both;">Producto<span class="text-danger">*</span></label>' +
                        '<select class="form-control id_producto" name="id_prod[]" id="id_prod" >' +
                        '<option value="">-- Producto --</option>' +
                        <?php
                        foreach ($products as $product) { ?> '<option value="<?= $product->id_producto; ?>"><?= $product->nombre_producto ?></option>' +
                        <?php }
                        ?> '</select>' +
                        '</div>' +
                        '<div class="form-group col-md-2" id="kg">' +
                        '<label for="">Kilos totales<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="" onkeyup="get_subtotal1()" name="kilos[]" id="kilos" required>' +
                        '</div>' +
                        '<div class="form-group col-md-2" id="price">' +
                        '<label for="">Precio por Kg<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="$" name="precio[]" onkeyup="get_subtotal1()" id="precio" required>' +
                        '</div>' +
                        '<div class="form-group col-md-2" id="arete">' +
                        '<label for="">Arete<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="" name="arete[]" id="arete_borrego" required>' +
                        '</div>' +
                        '<div class="form-group col-md-2" id="grapa">' +
                        '<label for="">Grapa<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="" name="grapa[]" id="grapa_borrego" required>' +
                        '</div>' +
                        '<div class="form-group col-md-2" id="subt">' +
                        '<label for="">Subtotal<span class="text-danger">*</span></label>' +
                        '<input type="number" class="form-control" placeholder="$" name="total[]" id="subtotal" readonly>' +
                        '</div>' +
                        '<div class="form-group col-md-1" id="btnRemove">' +
                        '</div>';
                    $("#addparts").html(formfields);
                    $("#kilos").val('');
                    $("#precio").val('');
                    $("#arete_borrego").val('');
                    $("#grapa_borrego").val('');
                    $("#subtotal").val('');
                    $(".id_producto").val(order_details.id_producto)
                    $("#div_button").show();

                    $(".id_producto option").each(function(key, value) {

                        if ($(this).val() != product_id) {
                            $(this).remove();
                        }
                    });
                }
                $("#surtir_pedido_modal").modal('show');
                $("#show_loading").html('');
            }
        });
    }
    /* Variable para guardar el número de columnas */
    var numCols = 1;

    /* Fragmento de código para clonar campos del formulario de surtir un pedido */
    $(document).ready(function() {

        var id = 1;

        // get item

        var item = $("#addparts");

        var before = $('#div_button');

        // initalize event click

        $('#addMore').on('click', function() {
            numCols = numCols + 1;

            // clone addparts
            var clone = item.clone(true);
            var btnrem = clone.children("#btnRemove");
            btnrem.html('<label style="color: #fff;">E</label><br><button type="button" class="btn btn-danger btn-sm btnRemove" onclick=removeRow(' + numCols + ') ><i style="color:aliceblue" class="fas fa-minus-square"> </i></button>');
            var kgTag = clone.children("#kg");
            kgTag.html('<label for="">kilos totales <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="" name="kilos[]" onkeyup="get_subtotal(' + numCols + ')" id="kilos' + numCols + '" required>');
            var priceTag = clone.children("#price");
            priceTag.html('<label for="">Precio por Kg <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="$" name="precio[]" onkeyup="get_subtotal(' + numCols + ')"  id="precio' + numCols + '" required>');
            var areteTag = clone.children("#arete");
            areteTag.html('<label for="">Arete <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="" name="arete[]"  id="arete' + numCols + '" required>');
            var grapaTag = clone.children("#grapa");
            grapaTag.html('<label for="">Grapa <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="" name="grapa[]"  id="grapa' + numCols + '" required>');
            var subTag = clone.children("#subt");
            subTag.html('<label for="">SubTotal <span class="text-danger">*</span></label>' +
                '<input type="number" class="form-control" placeholder="$" name="total[]" id="subtotal' + numCols + '" readonly>' +
                '<input type="hidden" name="id_pago" value="1">')
            var numRowTag = clone.children("#numRow");
            numRowTag.html('<label for="">#</label>' + '<input type="number" class="form-control" placeholder="" value="' + (numCols) + '" disabled>');

            // remove id
            clone.attr('id', 'addparts' + numCols);
            // add class duplicate
            clone.attr('class', 'row extracolumns');
            // insert duplicate before button div
            before.before(clone);
            $(".id_producto").val(product_id)

        });

    });

    /* Fragmento de código de función para eliminar una fila del formulario de surtir pedido de borregos */
    function removeRow(rowNum) {
        $("#addparts" + rowNum).remove();
        numCols = numCols - 1;
    }

    /* Fragmento de código de función para mostrar subtotal del pedido */
    function get_subtotal(numCol) {
        kilos = $("#kilos" + numCol).val();
        precio = $('#precio' + numCol).val();
        total = kilos * precio;
        $('#subtotal' + numCol).val(total);
    }

    /* Fragmento de código de función para mostrar subtotal del pedido */
    function get_subtotal1() {
        kilos = $("#kilos").val();
        precio = $('#precio').val();
        total = kilos * precio;
        $('#subtotal').val(total);
    }

    /* Función para resetear formulario de registro de pedido al cerrar modal */
    $('.close_modal').on('click', function(e) {
        e.preventDefault();
        document.getElementById('pedido_form').reset();
    })
</script>