//mostrar productos en jtablet
_url='https://ranchoelarenal.com.mx/apis/index.php/';
$(function () {
  var table_x = $(document)
    .find("#categorias_table")
    .DataTable({
      ajax: {
        url:
          _url+"categorias/api/categorias",
        dataSrc: "data",
        headers: {
          "X-API-KEY": "REARNL",
        },
      },
      columns: [
        { 
          targets: [0],
          render: function (data, type, row, meta) { 
            return meta.row+1;
           }
        },
        { data: "nombre_categoria" },
        { 
          data: "imagen",
          render: function (data, type, row, meta) {
            return (
              '<img alt="" width="100" height="100" src="https://ranchoelarenal.com.mx/apis/uploads/' + data + '"   /> '
            );
          },
        },
        
        {
          data: "id_categoria",
          render: function (data, type, row, meta) {
            return (
              '<a type="button" class="btn btn-primary btn-sm" onclick="get_by_id(' +
              data +
              ')"><i class="fa fa-pen" style="color: #fff;"></i></a> <a type="button" class="btn btn-danger btn-sm" onclick="areyousure(' +
              data +
              ')"><i class="fa fa-trash-alt" style="color: #fff;"></i></a>'
            );
          },
        },
      ],
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        ihousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
    });
});

function areyousure(_id) {
  event.preventDefault();
  //configuración de alerta
  Swal.fire({
    title: '¿Está seguro?',
    text: "¡No podrá recuperar la categoria una vez sea eliminado!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, Eliminarlo!',
    cancelButtonText: "¡No, Cancelar!"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url:
          _url+"categorias/api/categorias/id/" +
          _id,
    
        method: "DELETE",
        headers: {
          "X-API-KEY": "REARNL",
        },
        success: function (_response) {
         // window.location.reload();
          response = _response.message;
          if (_response.status == "error") {
            const Toast = Swal.mixin({
              toast: true,
              position: 'top-end',
              showConfirmButton: false,
              timer: 1500,
              timerProgressBar: true,
              didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
              },
            /*   onClose:()=>{
                window.location.reload();
              } */
            })
            
            Toast.fire({
              icon: 'error',
              title: response,
              onAfterClose: (toast)=>{
                window.location.reload();
              }
            })
          } else {
            const Toast = Swal.mixin({
              toast: true,
              position: 'top-end',
              showConfirmButton: false,
              timer: 1500,
              timerProgressBar: true,
              didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
              },
            /*   onClose:()=>{
                window.location.reload();
              } */
            })
            
            Toast.fire({
              icon: 'success',
              title: response,
              onAfterClose: (toast)=>{
                window.location.reload();
              }
            })
          }
        },
        error: function () {
          $.toast({
            heading: "Error",
            text: "Something wrong has happen!",
            position: "top-center",
            loaderBg: "red",
            icon: "error",
            hideAfter: 1500,
          });
        },
      });




    }
  })


}

//obtiene categorias por id
function get_by_id(id) {
  var id_categoria = id;
  $.ajax({
    url:
      _url+"categorias/api/categorias/id/" +
      id_categoria,
    method: "GET",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      $(document).find("#id_categoria").remove();
      $(".btns").text("");
      $("#myModalLabel").text("");
      $("#myModalLabel").append("Editar Categoria");
      $("#create_button").trigger("click");

      $("#nombre").val(_response.data.nombre_categoria);
      $(".btns").append(
        '<button type="button" onclick="editar(' +
          _response.data.id_categoria +
          ')" class="btn btn-warning">Actualizar</button>'
      );
    },
    error: function (error) {},
  });
}

//Insertar categoria
$(document).on("submit", "#categoriaForm ", function (event) {
  event.preventDefault();
  $.ajax({
    url:
      _url+"categorias/api/categorias/",
    method: "POST",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: new FormData(this),
    processData: false,
    contentType: false,
    cache: false,
    async: false,
    success: function (_response) {
     /*  window.location.reload(); */
      response = _response.message;
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },
        onClose:()=>{
          window.location.reload();
        }
      })
      
      Toast.fire({
        icon: 'success',
        title: response,
        onAfterClose: (toast)=>{
          window.location.reload();
        }
      })
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 15000,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },
        onClose:()=>{
          window.location.reload();
        } 
      })
      
      Toast.fire({
        icon: 'error',
        title: response,
        onAfterClose: (toast)=>{
           window.location.reload();
        }
      })
    },
  });
});

//funcion para editar categorias
function editar(id) {
  $.ajax({
    url:
      _url+"categorias/api/categorias/id/" +
      id,
    method: "PUT",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: $(document).find("#categoriaForm").serialize(),
    success: function (_response) {
      response = _response.message;
     // window.location.reload();
     const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 1500,
      timerProgressBar: true,
      didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
      },
    /*   onClose:()=>{
        window.location.reload();
      } */
    })
    
    Toast.fire({
      icon: 'success',
      title: response,
      onAfterClose: (toast)=>{
        window.location.reload();
      }
    })
      //clearForm('areaForm');
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },
      /*   onClose:()=>{
          window.location.reload();
        } */
      })
      
      Toast.fire({
        icon: 'error',
        title: response,
        onAfterClose: (toast)=>{
          window.location.reload();
        }
      })
    },
  });
}


