//mostrar productos
_url='https://ranchoelarenal.com.mx/apis/index.php/';

$(function () {
  var table_x = $(document)
    .find("#productos_table")
    .DataTable({
      ajax: {
        url: _url+"clientesPri/api/clientePri",
        dataSrc: "data",
        headers: {
          "X-API-KEY": "REARNL",
        },
      },
      columns: [
        {
          targets: [0],
          render: function (data, type, row, meta) { //para iniciar el conteo en la tabla
            return meta.row+1;
           }
        },
        {
          data: "nombre_completo"
        
        },
        {
          data: "telefono_cliente",
          render: function (data, type, row, meta) {
              if(data=='' || data==null || data==0 || data=='9999999999'){
                  return ('---')
              }else{
                  return (data);
              }
          },
        },
        {
          data: "email_cliente",
          render: function (data, type, row, meta) {
              if(data=='' || data==null){
                  return ('---')
              }else{
                  return (data);
              }
          },
        },
        {
          data: "pass_temp"
         
        },
        {
          data: "curp_cliente",
          render: function (data, type, row, meta) {
              if(data=='' || data==null){
                  return ('---')
              }else{
                  return (data);
              }
          },
        },
        {
          data: "id_cliente1",
          render: function (data, type, row, meta) {
            return (
              '<a type="button" class="btn btn-default btn-sm" onclick="get_by_id(' +
              data +
              ')"><i class="fa fa-eye"></i></a> <a type="button" class="btn btn-danger btn-sm" style="color: #fff;" onclick="areyousure(' +
              data +
              ')"><i class="fa fa-trash-alt"></i></a> <a type="button" title="Ver todos los pedidos" class="btn btn-info btn-sm" style="color: #fff;" onclick="ver(' +
              data +
              ')"><i class="fa fa-list-alt"></i></a><a type="button" title="Bloquear cliente" class="btn btn-warning btn-sm" style="color: #fff;" onclick="bloquear(' +
              data +
              ')"><i class="fa fa-ban"></i></a>'
            );
          },
        },
      ],
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        ihousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
    });
});
function bloquear(_id) {
  event.preventDefault();
  //configuración de alerta
  Swal.fire({
    title: '¿Está seguro de bloquear a este cliente?',
    text: "¡El cliente no podra ingresar a la pagina miestras este bloqueado!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, Bloquearlo!',
    cancelButtonText: "¡No, Cancelar!"
  }).then((result) => {
    if (result.isConfirmed) {
      /* $.ajax({
        url: "http://localhost/apis/index.php/clientesPri/api/clientePri/id/" +
          _id,
        method: "DELETE",
        headers: {
          "X-API-KEY": "REARNL",
        },
        success: function (_response) {
          window.location.reload();
          response = JSON.stringify(_response.message);
        },
        error: function () {
          $.toast({
          });
        },
      }); */
      $.ajax({
        url:_url+"clientesPri/api/bloquear/id/" +
        _id,
        method: "PUT",
        headers: {
          "X-API-KEY": "REARNL",
        },
        data: $(document).find("#bloquear_form").serialize(),
    
        success: function (_response) {
          response = JSON.stringify(_response.message);
    
          const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 1500,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            },
    
          })
    
          Toast.fire({
            icon: 'success',
            title: "EL cliente se ha bloquedo correctamente",
            onAfterClose: (toast) => {
              window.location.reload();
    
             
    
            }
          })
        
         
    
        },
    
    
        error: function (error) {
          response = JSON.stringify(error.responseText);
          alert(response);
        },
      });

    }
  })
}


function areyousure(_id) {
  event.preventDefault();
  //configuración de alerta
  Swal.fire({
    title: '¿Está seguro?',
    text: "¡No podrá recuperar el registro de este cliente  una vez sea eliminado!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, Eliminarlo!',
    cancelButtonText: "¡No, Cancelar!"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url:_url+"clientesPri/api/clientePri/id/" +
          _id,
        method: "DELETE",
        headers: {
          "X-API-KEY": "REARNL",
        },
        success: function (_response) {
          window.location.reload();
          response = JSON.stringify(_response.message);
        },
        error: function () {
          $.toast({
          });
        },
      });
    }
  })
}
//obtiene categorias por id
function get_by_id(_id) {
  var id_producto = _id;
  /* console.log("sss"+id_producto); */
  $.ajax({
    url: _url+"clientesPri/api/clie/id/" +
      id_producto,
    method: "GET",
    headers: {
      "X-API-KEY": "REARNL",
    },

   

    success: function (_response) {
      $(document).find("#id_cliente1").remove();
      $(".btns").text("");
      $("#my").text("");
      $("#my").append("Cliente");
      $("#client_modal").modal("show");
      $name=(_response.data.nombre_cliente+'  '+_response.data.apellido_paterno_cliente+'  '+_response.data.apellido_materno_cliente)
      $ids=(_response.data.identificacion_cliente);
      $("#doc").html('<a type="button" style="color:aliceblue" class="btn btn-success" onclick="verDoc('+_response.data.id_cliente1+')"><i class="  far fa-address-card mr-1"> Documentacion oficial</i></a>');
      $("#nombreC").html($name);
      $("#telefonoC").html(_response.data.telefono_cliente);
      $("#correoC").html(_response.data.email_cliente);
      
      $dir =(_response.data.municipio+' '+_response.data.estado);
      $dir1 =(_response.data.calle+' #'+_response.data.numero_exterior+', '+_response.data.colonia);
      if(_response.data.estado==null){
        $("#paisC").html('<a type="button" style="color:aliceblue" class="btn btn-success" onclick="addDire('+_response.data.id_cliente1+')"><i class="fas fa-map-marker-alt mr-1"> Agregar una dirección</i></a>')
        $("#direccionC").html("");
      }else{
        $("#paisC").html($dir)
        $("#direccionC").html($dir1);
      }

      direc=("Ubicada entre "+_response.data.calle1+" y "+_response.data.calle2);
      /* console.log(_response.data.calle1) */
      if(_response.data.calle1==null){
        $("#direc").html("")
      }else{
        $("#direc").html(direc)
      }
    },
    error: function (error) {},
  });
}
//funcion para editar categorias
function editar(id) {
  var form_data = new FormData(document.getElementById("productosForm"));
  $.ajax({
    url: _url+"productos/api/productos1/id/" +
      id,
    method: "POST",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: form_data,
    processData: false,
    contentType: false,
    cache: false,
    async: false,
    success: function (_response) {
      response = JSON.stringify(_response.message);
      window.location.reload();
      //clearForm('areaForm');
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
    },
  });
}
//Insertar  cliente prioritaario
$(document).on('submit', '#clientePri_Form', function (event) {
  event.preventDefault();
  $.ajax({
    url: _url+"clientesPri/api/clientePri/",
    method: "POST",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    // data: $('#productosForm').serialize(),
    data: new FormData(this),
    processData: false,
    contentType: false,
    cache: false,
    async: false,
    success: function (_response) {
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },

      })
      Toast.fire({
        icon: 'success',
        title: "Se ha agragado un nuevo cliente exitosamente",
        onAfterClose: (toast) => {
          window.location.reload();
        }
      })
     },
     error: function (error) {
       response = JSON.stringify(error.responseText);
       const Toast = Swal.mixin({
         toast: true,
         position: 'top-end',
         showConfirmButton: false,
         timer: 15000,
         timerProgressBar: true,
         didOpen: (toast) => {
           toast.addEventListener('mouseenter', Swal.stopTimer)
           toast.addEventListener('mouseleave', Swal.resumeTimer)
         },
         onClose:()=>{
           window.location.reload();
         }
       })
     },
  });
});

function ver(_id) {
  window.location =_url+"clientes_prioritarios/view/" + "?id=" + _id;
}

//Eliminar productos
function eliminar(_id) {
  $.ajax({
    url: _url+"productos/api/productos/id/" +
      _id,
    method: "DELETE",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      window.location.reload();
      response = JSON.stringify(_response.message);
      if (_response.status == "error") {
        $.toast({
          heading: "Error",
          text: response,
          position: "top-center",
          loaderBg: "red",
          icon: "error",
          hideAfter: 3500,
        });
      } else {
        $.toast({
          heading: "Success",
          text: response,
          position: "top-center",
          loaderBg: "green",
          icon: "success",
          hideAfter: 1500,
          stack: 6,
          afterHidden: function () {
            window.location =
              _url+"productos/api/productos/";
          },
        });
      }
    },
    error: function () {
      $.toast({
        heading: "Error",
        text: "Something wrong has happen!",
        position: "top-center",
        loaderBg: "red",
        icon: "error",
        hideAfter: 1500,
      });
    },
  });
}



function addDire(_id) {

  $("#client_modal").modal("hide");
  $("#Agregar1_modal").modal("show");
 
  var id_producto = _id;

  $("#id_cliente").val(id_producto);
  $(document).on('submit', '#add_dire', function (event) {
    event.preventDefault();
    $.ajax({
      url: _url+"direccion/api/direccion/",
      method: "POST",
      headers: {
        'X-API-KEY': 'REARNL'
      },
      // data: $('#productosForm').serialize(),
      data: new FormData(this),
      processData: false,
      contentType: false,
      cache: false,
      async: false,
      success: function (_response) {
        const Toast = Swal.mixin({
          toast: true,
          position: 'top-end',
          showConfirmButton: false,
          timer: 1500,
          timerProgressBar: true,
          didOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
          },
          /*   onClose:()=>{
              window.location.reload();
            } */
        })
        Toast.fire({
          icon: 'success',
          title: "Se ha agragado la direccion exitosamente",
          onAfterClose: (toast) => {
            window.location.reload();

           

          }
        })
  
      },
      error: function (error) {
        response = JSON.stringify(error.responseText);
        alert(response);
      }
    });
  });

}


//Llenar el select con  los datos de las razas registradas en la BD 
$(function () {
  $.ajax({
   url: _url+"raza/api/raza/",
    method: "GET",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    success: function (response) {
      $.each(response.data, function (i, data) {
        $('#raza').append("<option value='" + data.id_cliente + "'>" + data.nombre_raza + "</option>");
      });
    }
  })
});

//Llenar el select con  los datos de las categorias registradas en la BD 
$(function () {
  $.ajax({
   url: _url+"categorias/api/categorias/",
    method: "GET",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    success: function (response) {
      $.each(response.data, function (i, data) {
        $('#categoria').append("<option value='" + data.id_categoria + "'>" + data.nombre_categoria + "</option>");
      });
    }
  })
});


$("#button-addon2").on('click',function() {
  //documentación: https://www.notion.so/CURP-Renapo-API-392135e5a30a4ff59162325c4f76a9ec
  //obtener la curp del cliente
  curp = $("#curp").val();
  //api key o token generado 
  api_key = 'tz1vxlBRBKbiAJynoMWUBZDEBKu2';
  var ajax_load = '<div class="clearfix"><div class="spinner-border text-secondary' +
    'float-left" role="status"><span class="sr-only">Loading...</span></div></div>';
  $("#name").html(ajax_load);
  $("#father_name").html(ajax_load);
  $("#mother_name").html(ajax_load);
  $.ajax({
    method: "GET",
    //URL de la api
    url: "https://us-west4-arsus-production.cloudfunctions.net/curp?curp=" + curp + '&apiKey=' + api_key,
    dataType: "json",
    success: function(response) {

      $("#name").html('<input type="text" class="form-control" readonly placeholder="John" name="nombre_cliente" id="client_name" value="' + response.name + '">');
      $("#father_name").html('<input type="text" class="form-control" readonly placeholder="Smith" name="apellido_paterno_cliente" id="client_father_name" value="' + response.fatherName + '">');
      $("#mother_name").html('<input type="text" class="form-control" readonly placeholder="Ahn" name="apellido_materno_cliente" id="client_mother_name" value="' + response.motherName + '">');
    },
    error: function(error) {
      Swal.fire({
        position: 'top-center',
        icon: 'error',
        title: 'CURP invalida',
        text: '¡Ingrese una CURP valida!',
      })


      $("#name").html('<input type="text" class="form-control" readonly placeholder="John" name="client_name" id="client_name">');
      $("#father_name").html('<input type="text" class="form-control" readonly placeholder="Smith" name="client_father_name" id="client_father_name">');
      $("#mother_name").html('<input type="text" class="form-control" readonly placeholder="Ahn" name="client_mother_name" id="client_mother_name">');
    }
  });
})

function verDoc(_documentos) { 


  $("#client_modal").modal("hide");
  $("#identificacion_modal").modal("show");

  
  
  $.ajax({
   url: _url+"clientesPri/api/clie/id/" +
    _documentos,
    method: "GET",
    headers: {
      "X-API-KEY": "REARNL",
    },

   

    success: function (_response) {
      
      dir =(_response.data.identificacion_cliente);
      var ext = dir.split('.').pop();
  if (ext == 'pdf') {
    var options = {
      fallbackLink: "<p>Este navegador no soporta PDF en linea. Por favor descarga el PDF para poder visualizarlo <a href='[url]'>Descargar PDF</a></p>"
    };
    PDFObject.embed('http://localhost/apis/uploads/'+dir, "#documento_ver", options);
    
   

  } else {
    let preview_image = document.getElementById('documento_ver'),
      image = document.createElement('img');
    image.src = 'http://localhost/apis/uploads/'+dir;
    image.style.height = "17rem";
    preview_image.append(image);

  }
     
    },
    error: function (error) {},
  });

 


  /* var ext = id_doc.split('.').pop();
  if (ext == 'pdf') {
    var options = {
      fallbackLink: "<p>Este navegador no soporta PDF en linea. Por favor descarga el PDF para poder visualizarlo <a href='[url]'>Descargar PDF</a></p>"
    };
    PDFObject.embed('http://localhost/apis/uploads/'+id_doc, "#documento_ver", options);
  } else {
    let preview_image = document.getElementById('documento_ver'),
      image = document.createElement('img');

    image.src = 'http://localhost/apis/uploads/'+id_doc;
    image.style.height = "25rem";
    preview_image.append(image);

  } */

}
