_url='https://ranchoelarenal.com.mx/apis/index.php/';
$(function () {
  var table_x = $(document)
    .find("#precios_table")
    .DataTable({
      ajax: {
        url: _url+"precio/api/precio",
        dataSrc: "data",
        headers: {
          "X-API-KEY": "REARNL",
        },
      },
      columns: [
        {data: "id_precio"},
        {
          data: "nombre_categoria"
        },
        {
          data: "nombre_raza"
        },
        {
          data: "tamano"
          
        },
        {
          data: "precio",
          render: function (data, type, row, meta) {
            return (
              '$ ' + data 
            );
          },
        },


        {
          data: "id_precio",
          render: function (data, type, row, meta) {
            return (
              '<a type="button" class="btn btn-primary" onclick="get_by_id(' +
              data +
              ')"><i class="fa fa-pen"></i></a> <a type="button" class="btn btn-danger" onclick="areyousure(' +
              data +
              ')"><i class="fa fa-trash-alt"></i></a>'
            );
          },
        },
      ],
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        ihousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
    });
});


//alerta de confirmación de eliminar contacto
function areyousure(_id) {
  event.preventDefault();
  //configuración de alerta
  Swal.fire({
    title: '¿Está seguro?',
    text: "¡No podrá recuperar el Precio una vez sea eliminado!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, Eliminarlo!',
    cancelButtonText: "¡No, Cancelar!"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: _url+"precio/api/precio/id/" +
          _id,

        method: "DELETE",
        headers: {
          "X-API-KEY": "REARNL",
        },
        success: function (_response) {
          window.location.reload();
          response = JSON.stringify(_response.message);
          if (_response.status == "error") {

          } else {

          }
        },

      });
    }
  })


}

function ver(_id) {
  window.location = "https://ranchoelarenal.com.mx/admin/index.php/pedidos/view/" + _id;
}



function get_by_id(id) {
  var id_precio = id;
  $.ajax({
    url: _url+"precio/api/precio/id/" +
      id_precio,
    method: "GET",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      $(document).find("#id_precio").remove();
      $(".btns").text("");
      $("#myModalLabel").text("");
      $("#myModalLabel").append("Editar Precio");
      $("#create_button").trigger("click");

      $("#precio").val(_response.data.precio);
      $("#tamano").val(_response.data.tamano);
      $("#id_categoria").val(_response.data.id_categoria);
      $("#descripcion").val(_response.data.descripcion);
      $("#id_raza").val(_response.data.id_raza);

      $(".btns").append(
        '<button type="button" onclick="editar(' +
        _response.data.id_precio +
        ')" class="btn btn-warning">Actualizar</button>'
      );
    },
    error: function (error) {},
  });
}
//Insertar categoria
$(document).on("submit", "#precioForm ", function (event) {
  event.preventDefault();
  $.ajax({
    url: _url+"precio/api/precio/id/",
    method: "POST",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: $("#precioForm").serialize(),
    success: function (_response) {
      window.location.reload();
      response = JSON.stringify(_response.message);
      Swal.fire({
        osition: 'top-end',
        icon: 'success',
        title: 'El precio se ha egregado correctamente',
        showConfirmButton: false,
        timer: 4000
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.replace("<?php echo site_url('precios/delete/'); ?>" + "/" + id_precio);
        }
    })
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
    },
  });
});
//funcion para editar categorias
function editar(id) {
  $.ajax({
    url: _url+"precio/api/precio/id/" +
      id,
    method: "PUT",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: $(document).find("#precioForm").serialize(),
    success: function (_response) {
      response = JSON.stringify(_response.message);
      window.location.reload();
      //clearForm('areaForm');
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
    },
  });
}
//Eliminar categoria
/* function eliminar(_id) {
  
  $.ajax({
    url:
      "http://localhost/apis/index.php/precio/api/precio/id/" +
      _id,

    method: "DELETE",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      window.location.reload();
      response = JSON.stringify(_response.message);
      if (_response.status == "error") {
        $.toast({
          heading: "Error",
          text: response,
          position: "top-center",
          loaderBg: "red",
          icon: "error",
          hideAfter: 3500,
        });
      } else {
        $.toast({
          heading: "Success",
          text: response,
          position: "top-center",
          loaderBg: "green",
          icon: "success",
          hideAfter: 1500,
          stack: 6,
          afterHidden: function () {
            window.location =
              "http://localhost/apis/index.php/productos/api/productos/";
          },
        });
      }
    },
    error: function () {
      $.toast({
        heading: "Error",
        text: "Something wrong has happen!",
        position: "top-center",
        loaderBg: "red",
        icon: "error",
        hideAfter: 1500,
      });
    },
  });
} */


$(function () {
  $.ajax({
    url: _url+"raza/api/raza/",
    method: "GET",
    headers: {
      'X-API-KEY': 'REARNL'
    },

    success: function (response) {

      $.each(response.data, function (i, data) {
        //console.log(data)

        $('#id_raza').append("<option value='" + data.id_raza + "'>" + data.nombre_raza + "</option>");

      });
    }

  })
});


$(function () {
  $.ajax({
    url: _url+"categorias/api/categorias/",
    method: "GET",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    success: function (response) {
      $.each(response.data, function (i, data) {
        $('#id_categoria').append("<option value='" + data.id_categoria + "'>" + data.nombre_categoria + "</option>");

      });
    }

  })
});
