//mostrar productos
_url="https://ranchoelarenal.com.mx/apis/index.php/";
$(function () {
  var table_x = $(document)
    .find("#productos_table")
    .DataTable({
      ajax: {
        url: _url+"productos/api/productos/",
        dataSrc: "data",
        headers: {
          "X-API-KEY": "REARNL",
        },
      },
      columns: [{
          targets: [0],
          render: function (data, type, row, meta) { 
            return meta.row+1;
            
           }
           
        },
        {
          data: "imagen",
          render: function (data, type, row, meta) {
            return (
              '<img alt="" width="100" height="100" src="https://ranchoelarenal.com.mx/apis/uploads/' + data + '"   /> '
            );
          },
        },
        {
          data: "nombre_producto"
        },
        {
          data: "descripcion",
          render: function (data, type, row, meta) {
              if(data=='' || data==null){
                return (
              '---' 
            );      
              }else{
                  return (
               data 
            );
              }
            
          },
        },
        {
          data: "precio",
          render: function (data, type, row, meta) {
            return (
              '$ ' + data 
            );
          },
        },
        {
          data: "inventario"
        },
        {
          data: "nombre_categoria"
        },
        {
          data: "raza"
        },
        {
          data: "id_producto",
          render: function (data, type, row, meta) {
            return (
              '<a type="button" class="btn btn-primary btn-sm" onclick="get_by_id(' +
              data +
              ')"><i class="fa fa-pen" style="color: #fff;"></i></a> <a type="button" class="btn btn-danger btn-sm" onclick="areyousure(' +
              data +
              ')"><i class="fa fa-trash-alt" style="color: #fff;"></i></a>'+
              '<a type="button" class="btn btn-secondary btn-sm" onclick="updatePhoto('+data+')"><i class="fa fa-image" style="color: #fff;"></i></a>'
            );
          },
        },
      ],
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        ihousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
    });
});
function areyousure(_id) {
  event.preventDefault();
  //configuración de alerta
  Swal.fire({
    title: '¿Está seguro?',
    text: "¡No podrá recuperar el registro de este animal  una vez sea eliminado!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, Eliminarlo!',
    cancelButtonText: "¡No, Cancelar!"
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: _url+"productos/api/productos/id/" +
          _id,
        method: "DELETE",
        headers: {
          "X-API-KEY": "REARNL",
        },
        success: function (_response) {
       
          response = _response.message;
          const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 1500,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            },
          /*   onClose:()=>{
              window.location.reload();
            } */
          })
          
          Toast.fire({
            icon: 'success',
            title: "Producto eliminado exitosamente",
            onAfterClose: (toast)=>{
              window.location.reload();
            }
          })
        },
        error: function (error) {
          response = error.message;
          const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 1500,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.addEventListener('mouseenter', Swal.stopTimer)
              toast.addEventListener('mouseleave', Swal.resumeTimer)
            },
          /*   onClose:()=>{
              window.location.reload();
            } */
          })
          
          Toast.fire({
            icon: 'error',
            title: response,
            onAfterClose: (toast)=>{
              window.location.reload();
            }
          })
        },
      });
    }
  })
}
//obtiene categorias por id
function get_by_id(id) {
  var id_producto = id;
  $.ajax({
    url: _url+"productos/api/productos/id/" +
      id_producto,
    method: "GET",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      $(document).find("#id_producto").remove();
      $(".btns").text("");
      $("#myModalLabel").text("");
      $("#myModalLabel").append("Editar Producto");
      $("#create_button").trigger("click");
      $("#nombre").val(_response.data.nombre_producto);
      $("#descripcion").val(_response.data.descripcion);
      $("#precio").val(_response.data.precio);
      $("#inventario").val(_response.data.inventario);
      $("#categoria").val(_response.data.id_categoria);
      $("#raza").val(_response.data.raza);
      $(".btns").append(
        '<button type="button" onclick="editar(' +
        _response.data.id_producto +
        ')" class="btn btn-warning">Actualizar</button>'
      );
    },
    error: function (error) {},
  });
}
//funcion para editar categorias
function editar(id) {
  var form_data = new FormData(document.getElementById("productosForm"));
  $.ajax({
    url: _url+"productos/api/productos1/id/" +
      id,
    method: "POST",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: form_data,
    processData: false,
    contentType: false,
    cache: false,
    async: false,
    success: function (_response) {
      response = _response.message;
    
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },
      /*   onClose:()=>{
          window.location.reload();
        } */
      })
      
      Toast.fire({
        icon: 'success',
        title: "Producto actualizado exitosamente",
        onAfterClose: (toast)=>{
          window.location.reload();
        }
      })
      //clearForm('areaForm');
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
     /*  console.log(response) */
    },
  });
}
//Insertar producto
$(document).on('submit', '#productosForm', function (event) {
  event.preventDefault();
  $.ajax({
    url: _url+"productos/api/productos/",
    method: "POST",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    // data: $('#productosForm').serialize(),
    data: new FormData(this),
    processData: false,
    contentType: false,
    cache: false,
    async: false,
    success: function (_response) {
      /* window.location.reload();
      response = JSON.stringify(_response.message); */
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },
      /*   onClose:()=>{
          window.location.reload();
        } */
      })
      
      Toast.fire({
        icon: 'success',
        title: "Producto registrado exitosamente",
        onAfterClose: (toast)=>{
          window.location.reload();
        }
      })
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
    }
  });
});

//Eliminar productos
/* function eliminar(_id) {
  $.ajax({
    url: "http://localhost/apis/index.php/productos/api/productos/id/" +
      _id,
    method: "DELETE",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      window.location.reload();
      response = JSON.stringify(_response.message);
      if (_response.status == "error") {
        $.toast({
          heading: "Error",
          text: response,
          position: "top-center",
          loaderBg: "red",
          icon: "error",
          hideAfter: 3500,
        });
      } else {
        $.toast({
          heading: "Success",
          text: response,
          position: "top-center",
          loaderBg: "green",
          icon: "success",
          hideAfter: 1500,
          stack: 6,
          afterHidden: function () {
            window.location =
              "http://localhost/apis/index.php/productos/api/productos/";
          },
        });
      }
    },
    error: function () {
      $.toast({
        heading: "Error",
        text: "Something wrong has happen!",
        position: "top-center",
        loaderBg: "red",
        icon: "error",
        hideAfter: 1500,
      });
    },
  });
}
 */
//Llenar el select con  los datos de las razas registradas en la BD 
$(function () {
  $.ajax({
    url: _url+"raza/api/raza/",
    method: "GET",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    success: function (response) {
      $.each(response.data, function (i, data) {
        /* console.log(data) */
        $('#raza').append("<option value='" + data.nombre_raza + "'>" + data.nombre_raza + "</option>");
      });
    }
  })
});

//Llenar el select con  los datos de las categorias registradas en la BD 
$(function () {
  $.ajax({
    url: _url+"categorias/api/categorias/",
    method: "GET",
    headers: {
      'X-API-KEY': 'REARNL'
    },
    success: function (response) {
      $.each(response.data, function (i, data) {
        /* console.log(data) */
        $('#categoria').append("<option value='" + data.id_categoria + "'>" + data.nombre_categoria + "</option>");
      });
    }
  })
});
function updatePhoto(id){
  //alert(id)
  $("#updatePhotoModal").modal("show");
  //updatePhotoForm
  $(".btn-update-photo").html('<button type="button" class="btn btn-primary" onclick="editarFoto('+id+')">Actualizar</button>');
  
}
function editarFoto(id) { 
  var form_data = new FormData(document.getElementById("updatePhotoForm"));
  $.ajax({
    url: _url+"productos/api/actualizar_foto/id/" +
      id,
    method: "POST",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: form_data,
    processData: false,
    contentType: false,
    cache: false,
    async: false,
    success: function (_response) {
      response = _response.message;
    
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500,
        timerProgressBar: true,
        didOpen: (toast) => {
          toast.addEventListener('mouseenter', Swal.stopTimer)
          toast.addEventListener('mouseleave', Swal.resumeTimer)
        },
      /*   onClose:()=>{
          window.location.reload();
        } */
      })
      
      Toast.fire({
        icon: 'success',
        title: "Producto actualizado exitosamente",
        onAfterClose: (toast)=>{
          window.location.reload();
        }
      })
      //clearForm('areaForm');
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
     /*  console.log(response) */
    },
  });
 }

 