_url='https://ranchoelarenal.com.mx/apis/index.php/';
//mostrar productos en jtablet
$(function () {
  var table_x = $(document)
    .find("#categorias_table")
    .DataTable({
      ajax: {
        url:
          _url+"raza/api/raza/",
        dataSrc: "data",
        headers: {
          "X-API-KEY": "REARNL",
        },
      },
      columns: [
    
        { data: "id_raza" },
        { data: "nombre_raza" },
       
        { data: "comentarios" },
        {
          data: "id_raza",
          render: function (data, type, row, meta) {
            return (
              '<a style="color: #fff;" type="button" class="btn btn-primary" onclick="get_by_id(' +
              data +
              ')"><i class="fa fa-pen"></i></a> <a style="color: #fff;" type="button" class="btn btn-danger" onclick="areyousure(' +
              data +
              ')"><i class="fa fa-trash-alt"></i></a>'
            );
          },
        },
      ],
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        ihousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
    });
});


function areyousure(_id) {
  event.preventDefault();
  //configuración de alerta
  Swal.fire({
      title: '¿Está seguro?',
      text: "¡No podrá recuperar la raza una vez sea eliminada!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: '¡Si, Eliminarlo!',
      cancelButtonText: "¡No, Cancelar!"
  }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url:
            _url+"raza/api/raza/id/" +
            _id,
      
          method: "DELETE",
          headers: {
            "X-API-KEY": "REARNL",
          },
          success: function (_response) {
            window.location.reload();
            response = JSON.stringify(_response.message);
          
          },
          error: function () {
           
          },
        });
      }
  })


}

//obtiene categorias por id
function get_by_id(id) {
  var id_raza = id;
  $.ajax({
    url:
      _url+"raza/api/raza/id/" +
      id_raza,
    method: "GET",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      $(document).find("#id_raza").remove();
      $(".btns").text("");
      $("#myModalLabel").text("");
      $("#myModalLabel").append("Editar raza");
      $("#create_button").trigger("click");

      $("#nombre_raza").val(_response.data.nombre_raza);
     /*  $("#descripcion").val(_response.data.descripcion); */
      $("#comentarios").val(_response.data.comentarios);
      $(".btns").append(
        '<button type="button" onclick="editar(' +
          _response.data.id_raza +
          ')" class="btn btn-warning">Actualizar</button>'
      );
    },
    error: function (error) {},
  });
}

//Insertar categoria
$(document).on("submit", "#razaForm ", function (event) {
  event.preventDefault();
  $.ajax({
    url:
      _url+"raza/api/raza/",
    method: "POST",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: $("#razaForm").serialize(),
    success: function (_response) {
      window.location.reload();
      response = JSON.stringify(_response.message);
      Swal.fire({
        osition: 'top-end',
        icon: 'success',
        title: 'El precio se ha egregado correctamente',
        showConfirmButton: false,
        timer: 12000
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.replace("<?php echo site_url('precios/delete/'); ?>" + "/" + id_precio);
        }
    })
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
    },
  });
});

//funcion para editar categorias
function editar(id) {
  $.ajax({
    url:
      _url+"raza/api/raza/id/" +
      id,
    method: "PUT",
    headers: {
      "X-API-KEY": "REARNL",
    },
    data: $(document).find("#razaForm").serialize(),
    success: function (_response) {
      response = JSON.stringify(_response.message);
      window.location.reload();
      //clearForm('areaForm');
    },
    error: function (error) {
      response = JSON.stringify(error.responseText);
      alert(response);
    },
  });
}

//Eliminar categoria
function eliminar(_id) {
 
  $.ajax({
    url:
      _url+"raza/api/raza/id/" +
      _id,

    method: "DELETE",
    headers: {
      "X-API-KEY": "REARNL",
    },
    success: function (_response) {
      window.location.reload();
      response = JSON.stringify(_response.message);
      if (_response.status == "error") {
        $.toast({
          heading: "Error",
          text: response,
          position: "top-center",
          loaderBg: "red",
          icon: "error",
          hideAfter: 3500,
        });
      } else {
        $.toast({
          heading: "Success",
          text: response,
          position: "top-center",
          loaderBg: "green",
          icon: "success",
          hideAfter: 1500,
          stack: 6,
          afterHidden: function () {
            window.location =
              _url+"productos/api/productos/";
          },
        });
      }
    },
    error: function () {
      $.toast({
        heading: "Error",
        text: "Something wrong has happen!",
        position: "top-center",
        loaderBg: "red",
        icon: "error",
        hideAfter: 1500,
      });
    },
  });
}
