
_url='https://ranchoelarenal.com.mx/apis/index.php/';

//mostrar productos
$(function () {
    var table_x = $(document)
      .find("#tabla_pedidos")

      .DataTable({
        
        ajax: {
         url: _url+"pedidos/api/ventasFin/",
          dataSrc: "data",
          headers: {
            "X-API-KEY": "REARNL",
          },
        },
        columns: [ 
        { targets: [0],
          render: function (data, type, row, meta) { 
            return meta.row+1;
            
           }},
        {data: "folio_venta"},
          { data: "nombre_completo" },
          { data:"total",

          render: function (data, type, row, meta) {
            return (
              '$ ' + new Intl.NumberFormat('en-US').format(data) 
            );
          },


         },
          { data: "fecha" },
          { data: "status",
          render: function (data, type, row, meta) {
            return (
              '<span class="badge bg-success">Venta exitosa</span>'
            );
          },
        
        },
          
        
          {
            data: "id_venta",
            render: function (data, type, row, meta) {
              return (
                '<a type="button" class="btn btn-default" onclick="ver(' +
                data +
                ')"><i class="fa fa-eye"></i></a>'
              );
            },
          },
        ],
        
        language: {
          decimal: "",
          emptyTable: "No hay información",
          info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
          infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
          infoFiltered: "(Filtrado de _MAX_ total entradas)",
          infoPostFix: "",
          ihousands: ",",
          lengthMenu: "Mostrar _MENU_ Entradas",
          loadingRecords: "Cargando...",
          processing: "Procesando...",
          search: "Buscar:",
          zeroRecords: "Sin resultados encontrados",
          paginate: {
            first: "Primero",
            last: "Ultimo",
            next: "Siguiente",
            previous: "Anterior",
          },
        },


      });


  });
    


    /*TERMINA AQUI*/
    /*INICIA*/
    let response = "";
    //inicia
    $(document).on('submit', '#areaForm', function(event) {
        event.preventDefault();
        $.ajax({
            url: _url+"animales/api/animales/",
            method: "POST",
            headers: {
                'X-API-KEY': 'QWERTY'
            },
            data: $('#areaForm').serialize(),
            success: function(_response) {
                response = JSON.stringify(_response.message);
                $.toast({
                    heading: 'Success',
                    text: response,
                    position: 'top-right',
                    loaderBg: '#74C627',
                    icon: 'success',
                    hideAfter: 1500,
                    stack: false,
               
                });
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $.toast({
                    heading: 'Error',
                    text: response,
                    position: 'top-center',
                    loaderBg: 'red',
                    textColor: 'fff',
                    textAlign: 'left',
                    icon: 'error',
                    showHideTransition: 'slice',
                    hideAfter: 4000,
                    stack: 10

                });

            }
        });
    });


    $(document).on('click', '.btn-update', function(event) {
        event.preventDefault();
        var _id = $(document).find('#id_animal').val();
        $.ajax({
           url: _url+"animales/api/animales/id" + $(document).find('#id_amimal').val(),
            method: "PUT",
            headers: {
                'X-API-KEY': 'QWERTY'
            },
            data: $(document).find("#areaForm").serialize(),
            success: function(_response) {
                response = JSON.stringify(_response.message);
                $.toast({
                    heading: 'Success',
                    text: response,
                    position: 'top-center',
                    loaderBg: '#74C627',
                    icon: 'success',
                    hideAfter: 1500,
                    stack: false,
              
                });
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                $.toast({
                    heading: 'Error',
                    text: response,
                    position: 'top-center',
                    loaderBg: 'red',
                    textColor: 'fff',
                    textAlign: 'left',
                    icon: 'error',
                    showHideTransition: 'slice',
                    hideAfter: 4000,
                    stack: 10

                });

            }
        });
    });

    

    function eliminar_animal(_id) {
        $.ajax({
            url: "https://ranchoelarenal.com.mx/apis/index.php/animales/api/animales/id/" + _id,
            method: "DELETE",
            headers: {
                'X-API-KEY': 'QWERTY'
            },
            success: function(_response) {
                response = JSON.stringify(_response.message);
                if (_response.status == "error") {
                    $.toast({
                        heading: 'Error',
                        text: response,
                        position: 'top-center',
                        loaderBg: 'red',
                        icon: 'error',
                        hideAfter: 3500
                    });
                } else {
                    $.toast({
                        heading: 'Success',
                        text: response,
                        position: 'top-center',
                        loaderBg: 'green',
                        icon: 'success',
                        hideAfter: 1500,
                        stack: 6,
                        
                    });

                }
            },
            error: function() {
                $.toast({
                    heading: 'Error',
                    text: 'Something wrong has happen!',
                    position: 'top-center',
                    loaderBg: 'red',
                    icon: 'error',
                    hideAfter: 1500
                });

            }
        })
    }

    function ver(_id) {
        window.location = "https://ranchoelarenal.com.mx/admin/index.php/ventas/view/" + "?id=" + _id;
    }

