<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->model('AlmacenModelo');
        /*   $this->load->library('ciqrcode'); */
    }

    function almacenes_get()
    {
        $page = $this->get('page');
        $limit = $this->get('limit');
        $id = $this->get('id');

        if (count($this->get()) > 3) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('almacenes', array('almacenId' => $id), TRUE);
            } else {
                $response = $this->AlmacenModelo->obtenerAlmacenes($page, $limit);
                // $this->DAO->selectEntity('almacenes', array('almacenStatus'=>1));
            }
        }
        $this->response($response, $response['status_code']);
    }



    function almacenes_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "almacenNombre" => "El campo nombre es requerido y unico",

                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('almacenNombre', 'nombre', 'required|is_unique[almacenes.almacenNombre]');
            $this->form_validation->set_message('is_unique', 'El campo {field} debe ser unico.');
            $this->form_validation->set_message('required', 'El campo {field} es requerido.');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "almacenNombre" => $data["almacenNombre"],
                    "almacenUsuarioRegistro" => (@$data["almacenUsuarioRegistro"]) ? $data["almacenUsuarioRegistro"] : '',
                    "almacenFechaRegistro" => $currentDate,
                    "almacenFechaActualizacion" => $currentDate,
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('almacenes', $data, null, true);
                if ($dataResponse['status'] == "success" && $dataResponse['key']) {
                    $almacenContenido = array(
                        "almacenID" => $dataResponse["key"],
                        "contenidoFechaRegistro" => $currentDate,
                        "contenidoFechaActualizacion" => $currentDate
                    );
                    $contenidoResponse = $this->DAO->saveOrUpdateItem('contenido_almacen', $almacenContenido, null, true);
                    if ($contenidoResponse['status'] == "success") {
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Almacen registrado exitosamente",
                            "data" => null,
                        );
                    } else {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" =>  $contenidoResponse['message'],
                            "data" => null,
                        );
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }

    //actualizar ls datos en la bd
    function almacenes_put()
    {
        $data = $this->put();
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('almacenes', array('almacenId' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 15) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "almacenNombre" => "El nombre es requerido",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "almacenNombre" =>  "El nombre es requerido",
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('almacenNombre', 'nombre', 'required');
                    $this->form_validation->set_message('required', 'El {field} es requerido.');
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "almacenNombre" => $data["almacenNombre"],
                            "almacenUsuarioActualizacion" => (@$data["almacenUsuarioActualizacion"]) ? $data["almacenUsuarioActualizacion"] : '',
                            "almacenFechaActualizacion" => $currentDate,
                        );

                        $response = $this->DAO->updateData('almacenes', $data, array('almacenId' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Id requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function almacenesDelete_put()
    {
        $id = $this->get('id');
        $warehouseData = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('almacenes', array('almacenId' => $id), TRUE);
            if ($dataExists['data']) {
                $movimientosData = $this->DAO->selectEntity('movimientos', array('almacenId' => $id), FALSE);
                if ($movimientosData['data']) {
                    date_default_timezone_set('America/Mexico_City');
                    $currentDate = date('Y-m-d H:i:s');
                    $data = array(
                        "almacenStatus" => 0,
                        "almacenUsuarioActualizacion" => (@$warehouseData["almacenUsuarioActualizacion"]) ? $warehouseData["almacenUsuarioActualizacion"] : '',
                        'almacenFechaActualizacion' => $currentDate

                    );
                    $response = $this->DAO->updateData('almacenes', $data, array('almacenId' => $id));
                } else {
                    $deleteContenido = $this->DAO->deleteData('contenido_almacen', array('almacenId' => $id));
                    if ($deleteContenido['status'] == "success") {
                        $response = $this->DAO->deleteData('almacenes', array('almacenId' => $id));
                    } else {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => $deleteContenido['message'],
                            "validations" => null,
                            "data" => null
                        );
                    }
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El almacen especificado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id del almacen no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
}
