<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->library('ciqrcode');
    }

    //obtner los categorias
    function categorias_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener una categoria específico, o vacío para obtener todas las categorias"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('categorias', array('id_categoria' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('categorias');
            }
        }
        $this->response($response, $response['status_code']);
    }

    function categorias_inactivas_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener una categoria específico, o vacío para obtener todas las categorias"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('categorias', array('id_categoria' => $id, 'status' => 0), TRUE);
            } else {
                $response = $this->DAO->selectEntity('categorias', array('status' => 0));
            }
        }
        $this->response($response, $response['status_code']);
    }
    function activar_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('categorias', array('id_categoria' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 1,
                    "categoria_edit" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('categorias', $data, array('id_categoria' => $id));
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'La categoria fue activada exitosamente',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de categoria no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    /* eliminado fisico categorias */
    function eliminar_categoria_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('categorias', array('id_categoria' => $id), TRUE);
            if ($dataExists['data']) {
                $categoryExists = $this->DAO->selectEntity('productos', array('id_categoria' => $id), TRUE);
                if ($categoryExists['data']) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "No se puede eliminar la categoria seleccionada porque hay productos que petenecen a dicha categoria",
                        "validations" => null,
                        "data" => null
                    );
                } else {

                    $this->DAO->deleteData('categorias', array('id_categoria' => $id));
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => "Categoria eliminada exitosamente",
                        "validations" => null,
                        "data" => null
                    );
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "La categoria seleccionado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Ningun id fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    //agregar categorias
    function categorias_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "nombre" => "Requerido"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('nombre', 'nombre', 'required');
            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "nombre_categoria" => $this->post('nombre'),
                    "categoria_create" => $currentDate,
                    "categoria_edit" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('categorias', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Categoria registrada exitosamente",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }

    //actualizar ls datos en la bd
    function categorias_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('categorias', array('id_categoria' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 4) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "nombre" => "Requerido"
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "nombre" => "Requerido"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('nombre', 'nombre', 'required');
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "nombre_categoria" => $this->put('nombre'),
                            "categoria_edit" => $currentDate
                        );

                        $this->DAO->saveOrUpdateItem('categorias', $data, array('id_categoria' => $id));
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Categoria actualizada exitosamente",
                            "validations" => array(
                                "id" => "Requerido",
                            ),
                            "data" => null
                        );
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    //selecciona un producto para eliminar
    function categorias_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('categorias', array('id_categoria' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 0,
                    "categoria_edit" => $currentDate,
                );
                $this->DAO->updateData('categorias', $data, array('id_categoria' => $id));
                $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" => "Categoria eliminada exitosamente",
                    "validations" => null,
                    "data" => null
                );
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El id de categoria no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Ningun id fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
}
