<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }
    function clientes_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un cliente en específico, o vacío para obtener todos los clientes"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_clientes', array('id_cliente1' => $id), TRUE);
            } else {
                $query = $this->db->query('SELECT * FROM vw_clientes ORDER BY nombre_completo ASC');
                $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" => "Data loaded, successful",
                    "validations" => null,
                    "data" => $query->result()
                );
            }
        }
        $this->response($response, $response['status_code']);
    }


    function clientes_inactivos_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un cliente en específico, o vacío para obtener todos los clientes"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_clientes', array('id_cliente1' => $id, 'status' => 0), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_clientes', array('status' => 0));
            }
        }
        $this->response($response, $response['status_code']);
    }

    //agregar identificación oficial de cliente
    function identificacion_cliente_post()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                //$doc_name = $dataExists['data']->identificacion_cliente;
                $doc_name = 'ID-' . time();
                $config['upload_path'] = 'uploads';
                $config['allowed_types'] = '*';
                $config['max_size'] = '0';
                $config['overwrite'] = TRUE;
                $config['file_name'] = $doc_name;
                $this->load->library('upload', $config);
                if ($this->upload->do_upload("doc_identificacion_cliente")) {
                    $doc_data = array('upload_data' => $this->upload->data());
                    $doc = $doc_data['upload_data']['file_name'];
                } else {
                    $doc = '';
                }
                $cliente = array(
                    "identificacion_cliente" => $doc,
                    "updated_date" => $currentDate
                );
                $clientResponse = $this->DAO->updateData('clientes', $cliente, array('id_cliente' => $id));
                if ($clientResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Documento de identificación subido con exito.",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $clientResponse['message'],
                        "data" => null,
                    );
                }
            } else {
                $response = array(
                    'status' => 'error',
                    'status_code' => 'El cliente no existe, ingrese un id correcto.',
                    'validations' => array(
                        'id' => 'Required'
                    ),
                    'data' => null
                );
            }
        } else {
            $response = array(
                'status' => 'error',
                'status_code' => 'Id no fue enviado.',
                'validations' => array(
                    'id' => 'Required'
                ),
                'data' => null
            );
        }

        $this->response($response, $response['status_code']);
    }
    function bloquear_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 2,
                    "updated_date" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'El cliente fue bloqueado exitosamente',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de cliente no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function desbloquear_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 1,
                    "updated_date" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'El cliente fue desbloqueado exitosamente',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de cliente no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function activar_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 1,
                    "updated_date" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'El cliente fue activado exitosamente',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de cliente no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function eliminar_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "status" => 0,
                    "updated_date" => $currentDate
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'El cliente fue eliminado exitosamente',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id de cliente no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    /* eliminado fisico cliente */
    function eliminar_cliente_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                $saleExists = $this->DAO->selectEntity('ventas', array('id_cliente' => $id), TRUE);
                if ($saleExists['data']) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "No se puede eliminar el cliente seleccionado porque tiene ventas realizadas",
                        "validations" => null,
                        "data" => null
                    );
                } else {
                    $this->DAO->deleteData('clientes', array('id_cliente' => $id));
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => "Cliente eliminado exitosamente",
                        "validations" => null,
                        "data" => null
                    );
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El cliente seleccionado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Ningun id fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    public function verificar_email_post()
    {
        $token_psw = md5(uniqid());
        $email = $this->post('client_email');
        $response = $this->DAO->selectEntity('clientes', array('email_cliente' => $email, 'status' => 1), TRUE);
        if ($response['data']) {
            $id = $response['data']->id_cliente;
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "El correo existe.",
                "validations" => null,
                "data" => $response['data']->id_cliente
            );
            $data = array(
                'token_psw' => $token_psw,
                'status_psw' => 1
            );
            $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
            $config = array(
                'protocol' => "smtp",
                'smtp_host' => "smtp.gmail.com",
                'smtp_port' => 465,
                'smtp_crypto' => "ssl",
                'smtp_user' => "pruebasqrosystem@gmail.com",
                'smtp_pass' => "qrosystem123",
                'newline' => "\r\n",
                'mailtype' => "html",
                'charset' => "utf-8",
                'priority' => '1',
                'wordwrap' => TRUE,
                'validate' => FALSE

            );
            $this->load->library('email', $config);
            $this->email->set_newline("\r\n");
            $this->email->set_header('Rancho el Arenal', 'Rancho el Arenal');
            $this->email->from("pruebasqrosystem@gmail.com", "Rancho el Arenal");
            $this->email->to($email);
            $this->email->subject('Solicitud de cambio de contraseña Rancho el Arenal');
            $data = array('id_cliente' => $id, 'status' => 1, 'token' => $token_psw);
            $body = $this->load->view('change_password', $data, TRUE);
            $this->email->message($body);

            $this->email->send();
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 200,
                "message" => "Cuenta no valida.",
                "validations" => null,
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function valid_email_post()
    {
        $email = $this->post('client_email');

        if ($email) {
            $response = $this->DAO->selectEntity('clientes', array('email_cliente' => $email), TRUE);
            if ($response['data']) {
                $response = array(
                    "status" => "error",
                    "status_code" => 200,
                    "message" => "Este correo ya esta registrado",
                    "validations" => null,
                    "data" => null
                );
            } else {
                $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" => "Correo electrónico disponible",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "No se envio parametro correctamente",
                "validations" => array(
                    "client_email" => "Ingrese email a validar"
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function verify_token_post()
    {
        $id_cliente = $this->post('client_id');
        $status_psw = $this->post('status_psw');
        $token_psw = $this->post('token_psw');
        $response = $this->DAO->selectEntity('clientes', array(
            'id_cliente' => $id_cliente,
            'status_psw' => $status_psw, 'token_psw' => $token_psw
        ), TRUE);
        if ($response['data']) {
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Si existe",
                "validations" => null,
                "data" => null
            );
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 200,
                "message" => "No existe",
                "validations" => null,
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function change_psw_post()
    {
        $id_cliente = $this->post('client_id');
        $psw = $this->post('password');
        if ($id_cliente != '' && $psw != '') {
            $this->load->library('bcrypt');
            $data = array(
                'token_psw' => md5(uniqid()),
                'status_psw' => '0',
                'password_cliente' => $this->bcrypt->hash_password($psw)
            );
            $response = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id_cliente));
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 200,
                "message" => "Error interno",
                "validations" => null,
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function clientes_post()
    {
        $data = $this->post();

        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "curp" => "Campo requerido.",
                    "client_name" => "Campo requerido.",
                    "client_father_name" => "Campo requerido.",
                    "client_mother_name" => "Campo requerido.",
                    "client_phone" => "Campo requerido.",
                    "client_email" => "Campo requerido.",
                    "client_password" => "Campo requerido.",
                    "client_confirm_password" => "Campo requerido."
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('client_name', 'Nombre', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                $this->load->library('bcrypt');
                //$token=random_string('alnum', 8);
                $token = md5(uniqid());
                $email = $this->post('client_email');


                $data = array(
                    "curp_cliente" => $this->post('curp'),
                    "nombre_cliente" => $this->post('client_name'),
                    "apellido_paterno_cliente" => $this->post('client_father_name'),
                    "apellido_materno_cliente" => $this->post('client_mother_name'),
                    "telefono_cliente" => $this->post('client_phone'),
                    "email_cliente" => $this->post('client_email'),
                    "password_cliente" => $this->bcrypt->hash_password($this->post('client_password')),
                    "token_verificacion" => $token
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('clientes', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $config = array(
                        'protocol' => "smtp",
                        'smtp_host' => "smtp.gmail.com",
                        'smtp_port' => 465,
                        'smtp_crypto' => "ssl",
                        'smtp_user' => "pruebasqrosystem@gmail.com",
                        'smtp_pass' => "qrosystem123",
                        'newline' => "\r\n",
                        'mailtype' => "html",
                        'charset' => "utf-8",
                        'priority' => '1',
                        'wordwrap' => TRUE,
                        'validate' => FALSE

                    );
                    $this->load->library('email', $config);
                    $this->email->set_newline("\r\n");
                    $this->email->set_header('Carrito de compras', 'Rancho el Arenal');
                    $this->email->from("pruebasqrosystem@gmail.com", "Rancho el Arenal");
                    $this->email->to($email);
                    $this->email->subject('Verifica tu correo electrónico en Rancho el Arenal');
                    $data = array('id' => $dataResponse['key'], 'token' => $token);
                    $body = $this->load->view('send_mail', $data, TRUE);
                    $this->email->message($body);

                    $this->email->send();

                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => 'Registro exitoso',
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }


        $this->response($response, $response['status_code']);
    }

    function clientes_put()
    {
        $id = $this->get('id');

        if ($id) {
            $dataExist = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), true);
            if ($dataExist['data']) {
                if (count($this->put()) > 10) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "curp" => "Campo requerido.",
                            "client_name" => "Campo requerido.",
                            "client_father_name" => "Campo requerido.",
                            "client_mother_name" => "Campo requerido.",
                            "client_phone" => "Campo requerido."
                        ),
                        "data" => null
                    );
                } else {
                    $data = array(
                        "curp_cliente" => $this->put('curp'),
                        "nombre_cliente" => $this->put('client_name'),
                        "apellido_paterno_cliente" => $this->put('client_father_name'),
                        "apellido_materno_cliente" => $this->put('client_mother_name'),
                        "telefono_cliente" => $this->put('client_phone')
                    );
                    $dataVerify = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
                    if ($dataVerify['status'] == 'success') {
                        $clientExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), true);
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Cuenta actualizada correctamente",
                            "validations" => "",
                            /* "data"=>$clientExists['data']->email_cliente */
                            "data" => array(
                                'email' => $clientExists['data']->email_cliente,
                                'id' => $clientExists['data']->id_cliente,
                                'phone' => $clientExists['data']->telefono_cliente,
                                'curp' => $clientExists['data']->curp_cliente,
                                'name' => $clientExists['data']->nombre_cliente,
                                'father_lastname' => $clientExists['data']->apellido_paterno_cliente,
                                'mother_lastname' => $clientExists['data']->apellido_materno_cliente,
                                //'photo'=>$userExists->photo
                                'fullname' => $clientExists['data']->nombre_cliente . ' ' . $clientExists['data']->apellido_paterno_cliente . ' ' . $clientExists['data']->apellido_materno_cliente
                            )
                        );
                    }
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El cliente no existe. ",
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "El cliente no existe. ",
                "validations" => array(),
                "data" => ""
            );
        }

        $this->response($response, $response['status_code']);
    }

    function verificar_cuenta_put()
    {
        $id = $this->get('id');
        $token = $this->put('token');

        if ($id && $token) {
            $dataExist = $this->DAO->selectEntity('clientes', array('id_cliente' => $id, 'token_verificacion' => $token), true);
            if ($dataExist['data']) {
                if (count($this->put()) > 5) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(),
                        "data" => null
                    );
                } else {
                    $data = array(
                        'token_verificacion' => '',
                        'status' => 1
                    );
                    $dataVerify = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
                    if ($dataVerify['status'] == 'success') {
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" => "Cuenta verificada correctamente",
                            "validations" => "",
                            "data" => ""
                        );
                    }
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El link es invalido o ha expirado.",
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Enlace no valido.",
                "validations" => array(),
                "data" => ""
            );
        }

        $this->response($response, $response['status_code']);
    }

    function clientes_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array('status' => 0, 'updated_date' => $currentDate);
                $response = $this->DAO->updateData('clientes', $data, array('id_cliente' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El cliente ingresado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "El id no fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
}
