<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function clientes_prioritarios_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 8) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No se recibieron datos' : 'Se recibieron demasiados datos',
        "data" => count($data),
        "validations" => array(
          "curp_cliente" => "Campo opcional.",
          "nombre_cliente" => "Campo requerido, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
          "apellido_paterno_cliente" => "Campo requerido, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
          "apellido_materno_cliente" => "Campo opcional, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
          "telefono_cliente" => "Campo opcional, exactamente 10 digitos en longitud.",
          "email_cliente" => "Campo opcional, ingresar email valido.",
          "identificacion_cliente" => "Campo opcional.",
          "direccion_cliente" => "Campo opcional."

        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('nombre_cliente', 'nombre_cliente', 'required');
      $this->form_validation->set_rules('apellido_paterno_cliente', 'apellido_paterno_cliente', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
        $pass = array();
        $alphaLength = strlen($alphabet) - 1;
        for ($i = 0; $i < 8; $i++) {
          $n = rand(0, $alphaLength);
          $pass[] = $alphabet[$n];
        }
        $passwod_temp = implode($pass);

        $file = 'ID-' . time() . $this->input->post('curp');
        $config['upload_path'] = 'uploads';
        $config['allowed_types'] = '*';
        $config['max_size'] = '0';
        $config['overwrite'] = TRUE;
        $config['file_name'] = $file;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload("identificacion_cliente")) {
          $doc_data = array('upload_data' => $this->upload->data());
          $imagen = $doc_data['upload_data']['file_name'];
        } else {
          $imagen = '';
        }
        $this->load->library('bcrypt');
        $cliente = array(
          "tipo_cliente" => 2,
          "curp_cliente" => $this->post('curp_cliente'),
          "nombre_cliente" => $this->post('nombre_cliente'),
          "identificacion_cliente" => $imagen,
          "apellido_paterno_cliente" => $this->post('apellido_paterno_cliente'),
          "apellido_materno_cliente" => $this->post('apellido_materno_cliente'),
          "telefono_cliente" => $this->post('telefono_cliente'),
          "email_cliente" => $this->post('email_cliente'),
          "pass_temp" => $passwod_temp,
          "password_cliente" => $this->bcrypt->hash_password($passwod_temp),
          "direccion_cliente" =>  $this->post('direccion_cliente'),
          "status" => 1,
          "created_date" => $currentDate,
          "updated_date" => $currentDate
        );
        $clientResponse = $this->DAO->saveOrUpdateItem('clientes', $cliente, null, true);
        if ($clientResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "Client created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $clientResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }
  
  
  


  function clientes_prioritarios_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 20) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "curp_cliente" => "Campo opcional.",
              "nombre_cliente" => "Campo requerido, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
              "apellido_paterno_cliente" => "Campo requerido, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
              "telefono_cliente" => "Campo opcional, exactamente 10 digitos en longitud.",
              "email_cliente" => "Campo opcional, ingresar email valido.",
              "direccion_cliente" => "Campo opcional."
             
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "curp_cliente" => "Campo opcional.",
              "nombre_cliente" => "Campo requerido, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
              "apellido_paterno_cliente" => "Campo requerido, minimo 3 caracteres de longitud y maximo 100 caracteres de longitud.",
              "telefono_cliente" => "Campo opcional, exactamente 10 digitos en longitud.",
              "email_cliente" => "Campo opcional, ingresar email valido.",
              "direccion_cliente" => "Campo opcional."
            ),
            "data" => null
          );
        } else {

          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('nombre_cliente', 'nombre_cliente', 'required');
         
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');

            $data = array(
              "tipo_cliente" => 2,
              "curp_cliente" => $this->put('curp_cliente'),
              "nombre_cliente" => $this->put('nombre_cliente'),
              "apellido_paterno_cliente" => $this->put('apellido_paterno_cliente'),
              "apellido_materno_cliente" => $this->put('apellido_materno_cliente'),
              "telefono_cliente" => $this->put('telefono_cliente'),
              "email_cliente" => $this->put('email_cliente'),
              "direccion_cliente" =>  $this->put('direccion_cliente'),
              "status" => 1,
              "updated_date" => $currentDate
            );

            $response = $this->DAO->saveOrUpdateItem('clientes', $data, array('id_cliente' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

}
