<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->model('GraphsQueries');
        $this->load->model('DashboardModelo');
    }

    function count_entities_get()
    {
        $query_ventas = $this->db->query("SELECT 
                                        COUNT(CASE WHEN is_order=1 AND status=1 THEN 1 END) AS total_pedidos, 
                                        COUNT(CASE WHEN is_order=2 AND status=3 THEN 1 END) AS total_ventas FROM ventas")->row();
        $query_clientes = $this->db->query("SELECT COUNT(id_cliente) as total_clientes FROM clientes WHERE status=1")->row();
        $query_productos = $this->db->query("SELECT COUNT(id_producto) as total_productos FROM productos WHERE status=1")->row();

        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => array(
                'total_ventas' => $query_ventas->total_ventas,
                'total_pedidos' => $query_ventas->total_pedidos,
                'total_clientes' => $query_clientes->total_clientes,
                'total_productos' => $query_productos->total_productos
            )
        );
        $this->response($response, $response['status_code']);
    }

    function years_list_get()
    {

        //SELECT id_producto, COUNT(id_producto) FROM `vw_vens` WHERE is_order=2 AND status=3 GROUP BY id_producto

        $query = $this->db->query("SELECT YEAR(fecha) as year FROM `ventas` GROUP by year ORDER BY year ASC");
        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );
        $this->response($response, $response['status_code']);
    }
    
    
    
    function getMarketPriceFishByYearProduct_get()
    {
        $idProdu = $this->get('id');
        $response = $this->GraphsQueries->getMarketPriceFishByYearForProduct($idProdu);
        $this->response($response, $response['status_code']);
    }
    
    
    /* SELECT SUM(total) as total FROM vw_ventasDetalles */
    function totalVentasPorProductos_get()
    {
        $query = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto, SUM(total) as total_venta FROM `vw_ventasDetalles` GROUP BY nombre_producto");
        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );
        $this->response($response, $response['status_code']);
    }

    function productosVentas_get()
    {
        $query = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
        FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto GROUP BY v.id_producto ORDER BY numero_ventas DESC");
        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );
        $this->response($response, $response['status_code']);
    }
    function clientesFrecuentes_get()
    {
        $query = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );
        $this->response($response, $response['status_code']);
    }
    function clientesFrecuentesPorCantidadMonetaria_get()
    {
        $query = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );
        $this->response($response, $response['status_code']);
    }
    function totalVentasPorMesGeneral_get()
    {
        $query = $this->db->query("SELECT YEAR(fecha_venta) AS year,
        SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
        SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
        SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
        SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
        SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
        SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
        SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
        SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
        SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
        SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
        SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
        SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
        FROM vw_ventasDetalles GROUP BY year");
        $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );
        $this->response($response, $response['status_code']);
    }
    function customQuerySales1_get()
    {
        $year = $this->get('year');
        $month = $this->get('month');
        $category = $this->get('category');
        $product = $this->get('product');
        $client = $this->get('client');
        //it works y
        if ($year != 'all' && $month == 'all' && $category == 'all' && $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, null, null, null, null);
            //it works m
        } else if ($year == 'all' && $month != 'all' && $category == 'all' && $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, $month, null, null, null);
            //it works c
        } else if ($year == 'all' && $month == 'all' && $category != 'all' && $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, null, $category, null, null);
            //it works p
        } else if ($year == 'all' && $month == 'all' && $category == 'all' && $product != 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, null, null, $product, null);
            //it works cc
        } else if ($year == 'all' && $month == 'all' && $category == 'all' && $product == 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, null, null, null, $client);
            //it works y-m
        } else if ($year != 'all' && $month != 'all' && $category == 'all' && $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, $month, null, null, null);
            //it works
        } else if ($year != 'all' && $month != 'all' && $category != 'all' && $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, $month, $category, null, null);
            //it works
        } else if ($year != 'all' && $month != 'all' && $category != 'all' && $product != 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, $month, $category, $product, null);
            //it works
        } else if ($year != 'all' && $month != 'all' && $category != 'all' && $product != 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, $month, $category, $product, $client);
            //it works
        } else if ($year != 'all' && $month == 'all' && $category != 'all' && $product != 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales($year,null, $category, $product, $client);
            //it works
        }else if ($year != 'all' && $month == 'all'  &&  $category != 'all' && $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, null, $category, null, null);
            //it works
        } else if ($year != 'all'  && $month == 'all' && $category == 'all' && $product != 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, null, null, $product, null);
            //it works
        } else if ($year != 'all'  && $month == 'all' && $category == 'all' && $product == 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales($year, null, null, null, $client);
            //it works
        } else if ($year == 'all' && $month != 'all' && $category != 'all' &&  $product == 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, $month, $category, null, null);
            //it works
        } else if ($year == 'all' && $month != 'all' && $category != 'all' && $product != 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, $month, $category, $product, null);
            //it works
        } else if ($year == 'all' && $month != 'all' && $category != 'all' && $product != 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, $month, $category, $product, $client);
            //it works
        } else if ($year == 'all' && $month != 'all' && $category == 'all' && $product != 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, $month, null, $product, null);
            //it works
        } else if ($year == 'all' && $month != 'all' && $category == 'all' && $product == 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, $month, null, null, $client);
            //it works
        } else if ($year == 'all' && $month == 'all' && $category != 'all' && $product != 'all' && $client == 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, null, $category, $product, null);
        } else if ($year == 'all' && $month == 'all' && $category != 'all' && $product == 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, null, $category, null, $client);
        } else if ($year == 'all' && $month == 'all' && $category != 'all' && $product != 'all' && $client != 'all') {
            $response = $this->GraphsQueries->customQuerySales(null, null, $category, $product, $client);
        }
        $this->response($response, $response['status_code']);
    }

    /* 
    ventas por mes por cliente
    SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto, YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre,
            cliente
            FROM vw_ventasDetalles WHERE YEAR(fecha_venta)='2020' AND id_cliente=24 GROUP BY id_producto;
    
    */
    function customQuerySales_get()
    {
        $year = $this->get('year');
        $month = $this->get('month');
        $category = $this->get('category');
        $product = $this->get('product');

        if ($year != 'all' && $month == 'all' && $category == 'all' && $product == 'all') {
            $querySales = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto, YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
            FROM vw_ventasDetalles WHERE YEAR(fecha_venta)='$year' GROUP BY id_producto");
            $querySalesByProduct = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto,
             SUM(total) as total_venta FROM `vw_ventasDetalles` WHERE YEAR(fecha_venta)='$year'
            GROUP BY nombre_producto");
            $queryProductsSales = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
            FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto AND YEAR(fecha_venta)='$year' GROUP BY v.id_producto  ORDER BY numero_ventas DESC");
            $queryFrequentCustomers = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE YEAR(fecha_venta)='$year' GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
            $queryFrequentCustomersByQtyCash = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE YEAR(fecha_venta)='$year' GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => array(
                    'sales' => $querySales->result(),
                    'salesByProduct' => $querySalesByProduct->result(),
                    'productsSales' => $queryProductsSales->result(),
                    'frecuentCustomers' => $queryFrequentCustomers->result(),
                    'frecuentCustomersByQtyCash' => $queryFrequentCustomersByQtyCash->result(),
                )
            );
        } else if ($year == 'all' && $month != 'all' && $category == 'all' && $product == 'all') {
            $querySales = $this->db->query("SELECT YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
            FROM vw_ventasDetalles WHERE MONTH(fecha_venta)='$month' GROUP BY year");
            $querySalesByProduct = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto,
             SUM(total) as total_venta FROM `vw_ventasDetalles` WHERE MONTH(fecha_venta)='$month'
            GROUP BY nombre_producto");
            $queryProductsSales = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
            FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto AND MONTH(fecha_venta)='$month'  GROUP BY v.id_producto  ORDER BY numero_ventas DESC");
            $queryFrequentCustomers = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE MONTH(fecha_venta)='$month' GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
            $queryFrequentCustomersByQtyCash = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE MONTH(fecha_venta)='$month' GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => array(
                    'sales' => $querySales->result(),
                    'salesByProduct' => $querySalesByProduct->result(),
                    'productsSales' => $queryProductsSales->result(),
                    'frecuentCustomers' => $queryFrequentCustomers->result(),
                    'frecuentCustomersByQtyCash' => $queryFrequentCustomersByQtyCash->result(),
                )
            );
        } else if ($year == 'all' && $month == 'all' && $category != 'all' && $product == 'all') {
            $querySales = $this->db->query("SELECT categoria, YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
            FROM vw_ventasDetalles WHERE id_categoria='$category' GROUP BY year");
            $querySalesByProduct = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto,
             SUM(total) as total_venta FROM `vw_ventasDetalles` WHERE id_categoria='$category'
            GROUP BY nombre_producto");
            $queryProductsSales = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
            FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto AND p.id_categoria='$category' GROUP BY v.id_producto  ORDER BY numero_ventas DESC");
            $queryFrequentCustomers = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE id_categoria='$category' GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
            $queryFrequentCustomersByQtyCash = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE id_categoria='$category' GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => array(
                    'sales' => $querySales->result(),
                    'salesByProduct' => $querySalesByProduct->result(),
                    'productsSales' => $queryProductsSales->result(),
                    'frecuentCustomers' => $queryFrequentCustomers->result(),
                    'frecuentCustomersByQtyCash' => $queryFrequentCustomersByQtyCash->result(),
                )
            );
        } else if ($year == 'all' && $month == 'all' && $category == 'all' && $product != 'all') {
            $querySales = $this->db->query("SELECT categoria, YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
            FROM vw_ventasDetalles WHERE id_categoria='$category' GROUP BY year");
            $querySalesByProduct = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto,
             SUM(total) as total_venta FROM `vw_ventasDetalles` WHERE id_producto='$product'
            GROUP BY nombre_producto");
            $queryProductsSales = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
            FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto AND p.id_producto='$product' GROUP BY v.id_producto  ORDER BY numero_ventas DESC");
            $queryFrequentCustomers = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE id_producto='$product' GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
            $queryFrequentCustomersByQtyCash = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE id_producto='$product' GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => array(
                    'sales' => $querySales->result(),
                    'salesByProduct' => $querySalesByProduct->result(),
                    'productsSales' => $queryProductsSales->result(),
                    'frecuentCustomers' => $queryFrequentCustomers->result(),
                    'frecuentCustomersByQtyCash' => $queryFrequentCustomersByQtyCash->result(),
                )
            );
        } else if ($year != 'all' && $month != 'all' && $category != 'all' && $product != 'all') {
            $querySales = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto, YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
            FROM vw_ventasDetalles WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product' GROUP BY id_producto");
            $querySalesByProduct = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto,
             SUM(total) as total_venta FROM `vw_ventasDetalles` WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product' 
            GROUP BY nombre_producto");
            $queryProductsSales = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
            FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto AND YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product' GROUP BY v.id_producto  ORDER BY numero_ventas DESC");
            $queryFrequentCustomers = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product'  GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
            $queryFrequentCustomersByQtyCash = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product' GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => array(
                    'sales' => $querySales->result(),
                    'salesByProduct' => $querySalesByProduct->result(),
                    'productsSales' => $queryProductsSales->result(),
                    'frecuentCustomers' => $queryFrequentCustomers->result(),
                    'frecuentCustomersByQtyCash' => $queryFrequentCustomersByQtyCash->result(),
                )
            );
        } else if ($year != 'all' && $month != 'all' && $category == 'all' && $product == 'all') {
            $querySales = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto, YEAR(fecha_venta) AS year,
            SUM(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
            SUM(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
            SUM(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
            SUM(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
            SUM(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
            SUM(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
            SUM(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
            SUM(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
            SUM(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
            SUM(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
            SUM(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
            FROM vw_ventasDetalles WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' GROUP BY id_producto");
            $querySalesByProduct = $this->db->query("SELECT CONCAT(nombre_producto, ' ', raza) as nombre_producto,
             SUM(total) as total_venta FROM `vw_ventasDetalles` WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' 
            GROUP BY nombre_producto");
            $queryProductsSales = $this->db->query("SELECT COUNT(v.id_venta) numero_ventas, v.categoria, v.nombre_producto, v.raza, SUM(v.total) as total_venta, p.imagen 
            FROM vw_ventasDetalles as v, productos as p WHERE v.id_producto=p.id_producto AND YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' GROUP BY v.id_producto  ORDER BY numero_ventas DESC");
            $queryFrequentCustomers = $this->db->query("SELECT COUNT(id_venta) numero_compras, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product'  GROUP BY id_cliente ORDER BY numero_compras DESC LIMIT 6");
            $queryFrequentCustomersByQtyCash = $this->db->query("SELECT SUM(total) total_compra, categoria, nombre_producto, raza, cliente FROM vw_ventasDetalles 
            WHERE YEAR(fecha_venta)='$year' AND MONTH(fecha_venta)='$month' AND is_categoria='$category' AND id_producto='$product' GROUP BY id_cliente ORDER BY total_compra DESC LIMIT 6");
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => array(
                    'sales' => $querySales->result(),
                    'salesByProduct' => $querySalesByProduct->result(),
                    'productsSales' => $queryProductsSales->result(),
                    'frecuentCustomers' => $queryFrequentCustomers->result(),
                    'frecuentCustomersByQtyCash' => $queryFrequentCustomersByQtyCash->result(),
                )
            );
        }
        $this->response($response, $response['status_code']);
    }
    /* SELECT YEAR(fecha_venta) AS year,
MAX(CASE WHEN (MONTH(fecha_venta)=1) THEN total else 0 END) as total_enero,
MAX(CASE WHEN (MONTH(fecha_venta)=2) THEN total else 0 END) as total_febrero,
MAX(CASE WHEN (MONTH(fecha_venta)=3) THEN total else 0 END) as total_marzo,
MAX(CASE WHEN (MONTH(fecha_venta)=4) THEN total else 0 END) as total_abril,
MAX(CASE WHEN (MONTH(fecha_venta)=5) THEN total else 0 END) as total_mayo,
MAX(CASE WHEN (MONTH(fecha_venta)=6) THEN total else 0 END) as total_junio,
MAX(CASE WHEN (MONTH(fecha_venta)=7) THEN total else 0 END) as total_julio,
MAX(CASE WHEN (MONTH(fecha_venta)=8) THEN total else 0 END) as total_agosto,
MAX(CASE WHEN (MONTH(fecha_venta)=9) THEN total else 0 END) as total_septiembre,
MAX(CASE WHEN (MONTH(fecha_venta)=10) THEN total else 0 END) as total_octubre,
MAX(CASE WHEN (MONTH(fecha_venta)=11) THEN total else 0 END) as total_noviembre,
MAX(CASE WHEN (MONTH(fecha_venta)=12) THEN total else 0 END) as total_diciembre
FROM vw_ventasDetalles GROUP BY year */

    /* select COUNT(id_venta) numero_ventas, categoria, nombre_producto, raza, SUM(total) as total_venta FROM vw_ventasDetalles GROUP BY id_producto ORDER BY numero_ventas DESC
 */
    /* select COUNT(id_venta) numero_compras, cliente FROM vw_ventasDetalles GROUP BY id_cliente ORDER BY numero_compras DESC
 */
 
 function getMarketPriceFishByYear_get()
    {
        $response = $this->GraphsQueries->getMarketPriceFishByYear();
        $this->response($response, $response['status_code']);
    }
    function movimientos_get()
    {
        $page = $this->get('page');
        $limit = $this->get('limit');
        $id = $this->get('id');
        if (count($this->get()) > 3) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_transferencias', array('movimientoId' => $id), TRUE);
            } else {
                $response = $this->DashboardModelo->obtenerMovimientosTodo($page, $limit);
            }
        }
        $this->response($response, $response['status_code']);
    }


    function traspasosGrafico_get()
    {
        $page = $this->get('page');
        $limit = $this->get('limit');
        $id = $this->get('id');
        if (count($this->get()) > 3) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_traspaso', array('movimientoId' => $id), TRUE);
            } else {
                $response = $this->DashboardModelo->obtenerTraspasosGrafico($page, $limit);
            }
        }
        $this->response($response, $response['status_code']);
    }
}
