<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }

    //Metodo para obtener direccion por cliente
    function direccion_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar id de cliente para obtener la direccion"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('direcciones', array('id_cliente' => $id), TRUE);
            }
        }
        $this->response($response, $response['status_code']);
    }

    //agregar nueva direccion direccion
    function direccion_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 20) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "id_cliente"=>"Requerido",
                    "cp" => "Opcional",
                    "estado"=> "Requerido",
                    "estado"=>"Requerido",
                    "colonia"=>"Requerido",
                    "calle"=>"Requerido",
                    "numero_exterior"=>"Opcional",
                    "numero_interior"=>"Opcional",
                    "calle1"=>"Opcional",
                    "calle2"=>"Opcional",
                    "indicaciones"=>"Opcional",
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('id_cliente', 'id_cliente', 'required');
            $this->form_validation->set_rules('estado', 'Estado', 'required');
            $this->form_validation->set_rules('municipio', 'Municipio', 'required');
            $this->form_validation->set_rules('colonia', 'Colonia', 'required');
            $this->form_validation->set_rules('calle', 'Calle', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
              /*  $data = array(
                    "nombre_categoria" => $this->post('nombre')
                );*/
                $data = array(
                    "id_cliente" => $this->post('id_cliente'),
                    "cp" => $this->post('cp'),
                    "estado"=> $this->post('estado'),
                    "municipio"=>$this->post('municipio'),
                    "colonia"=>$this->post('colonia'),
                    "calle"=>$this->post('calle'),
                    "numero_exterior"=>$this->post('numero_exterior'),
                    "numero_interior"=>$this->post('numero_interior'),
                    "calle1"=>$this->post('calle1'),
                    "calle2"=>$this->post('calle2'),
                    "indicaciones"=>$this->post('indicaciones'),
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('direcciones', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Dirección registrada exitosamente",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }

    //actualizar ls datos en la bd
    function direccion_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('direcciones', array('id_cliente' => $id), TRUE);
            if ($dataExists) {
                if (count($this->put()) > 20) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "cp" => "Opcional",
                            "estado"=> "Requerido",
                            "municipio"=>"Requerido",
                            "colonia"=>"Requerido",
                            "calle"=>"Requerido",
                            "numero_exterior"=>"Opcional",
                            "numero_interior"=>"Opcional",
                            "calle1"=>"Opcional",
                            "calle2"=>"Opcional",
                            "indicaciones"=>"Opcional",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "cp" => "Opcional",
                            "estado"=> "Requerido",
                            "municipio"=>"Requerido",
                            "colonia"=>"Requerido",
                            "calle"=>"Requerido",
                            "numero_exterior"=>"Opcional",
                            "numero_interior"=>"Opcional",
                            "calle1"=>"Opcional",
                            "calle2"=>"Opcional",
                            "indicaciones"=>"Opcional",
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('estado', 'Estado', 'required');
                    $this->form_validation->set_rules('municipio', 'Municipio', 'required');
                    $this->form_validation->set_rules('colonia', 'Colonia', 'required');
                    $this->form_validation->set_rules('calle', 'Calle', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                      /*  $data = array(
                            "nombre_categoria" => $this->put('nombre')
                        );*/
                        $data = array(
                            "cp" => $this->put('cp'),
                            "estado"=> $this->put('estado'),
                            "municipio"=>$this->put('municipio'),
                            "colonia"=>$this->put('colonia'),
                            "calle"=>$this->put('calle'),
                            "numero_exterior"=>$this->put('numero_exterior'),
                            "numero_interior"=>$this->put('numero_interior'),
                            "calle1"=>$this->put('calle1'),
                            "calle2"=>$this->put('calle2'),
                            "indicaciones"=>$this->put('indicaciones'),
                        );

                       $this->DAO->saveOrUpdateItem('direcciones', $data, array('id_cliente' => $id));
                       $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" => "Direccion actualizada exitosamente",
                        "validations" => array(
                            "id" => "Requerido",
                        ),
                        "data" => null
                    );
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    //selecciona un producto para eliminar
    function direccion_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('direcciones', array('id_cliente' => $id), TRUE);
            if ($dataExists['data']) {
                $this->DAO->deleteData('direcciones', array('id_cliente' => $id));
                $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" => "Direccion eliminada exitosamente",
                    "validations" => null,
                    "data" => null
                );
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "La direccion no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Ningun id fue enviado",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

}
