<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->model('MovimientoModelo');
    }

    function movimientos_get()
    {
        $page = $this->get('page');
        $limit = $this->get('limit');
        $id = $this->get('id');
        if (count($this->get()) > 3) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un producto específico, o vacío para obtener todos los productos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('movimientos', array('movimientoId' => $id), TRUE);
            } else {
                $response = $this->MovimientoModelo->obtenerMovimientos($page, $limit);
            }
        }
        $this->response($response, $response['status_code']);
    }

    /* {
    "movimientoTipo": "Entrada",
    "movimientoFecha": "2022-02-28",
    "almacenId": 25,
    "movimientoCantidad": 10,
    "movimientoNotas": "Esto es un registro desde insomnia"
  } */
    function movimientos_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "movimientoTipo" => "El campo tipo es requerido.",
                    "movimientoFecha" => "El campo fecha es requerido.",
                    "almacenId" => "El campo almacen es requerido.",
                    "movimientoCantidad" => "El campo cantidad es requerido.",
                    "movimientoNotas" => "El campo notas es opcional"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('movimientoTipo', 'tipo', 'required|callback_tipo_valid');
            $this->form_validation->set_rules('movimientoFecha', 'fecha', 'required');
            $this->form_validation->set_rules('almacenId', 'almacen', 'required|callback_almacen_exists');
            $this->form_validation->set_rules('movimientoCantidad', 'cantidad', 'required|callback_cantidad_valid');
            $this->form_validation->set_message('required', 'El campo {field} es requerido.');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $almacenId = $data["almacenId"];
                $cantidadMovimiento = $data["movimientoCantidad"];
                $productoId = 10;
                $tipoMovimiento = $data["movimientoTipo"];
                $contenidoAlmacen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacenId), TRUE);
                if ($contenidoAlmacen['data']) {
                    $cantidad_almacen = $contenidoAlmacen['data']->contenidoCantidad;
                    if ($tipoMovimiento == 'Salida' && $cantidadMovimiento > $cantidad_almacen) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "data" => null,
                            "validations" => array(
                                "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar registro de una salida, por favor verifique la cantidad",
                            )
                        );
                    } else {
                        $dataNewMovimiento = array(
                            "movimientoTipo" => $tipoMovimiento,
                            "movimientoFecha" => $data["movimientoFecha"],
                            "almacenId" => $almacenId,
                            "productoId" => $productoId,
                            "movimientoCantidad" => $cantidadMovimiento,
                            "movimientoNotas" => (@$data["movimientoNotas"]) ? $data["movimientoNotas"] : '',
                            "movimientoUsuarioRegistro" => (@$data["movimientoUsuarioRegistro"]) ? $data["movimientoUsuarioRegistro"] : '',
                            "movimientoFechaRegistro" => $currentDate,
                            "movimientoFechaActualizacion" => $currentDate,
                        );
                        $dataResponse = $this->DAO->saveOrUpdateItem('movimientos', $dataNewMovimiento, null, true);
                        if ($dataResponse['status'] == 'success' && $dataResponse['key']) {
                            $id_movimiento = $dataResponse['key'];
                            $dataDetalles = array(
                                'movimiento_id' => $id_movimiento,
                                'detalleCantidad' => $this->post('movimientoCantidad'),
                                'detallesFechaRegistro' => $currentDate,
                                'detallesFechaActualizacion' => $currentDate
                            );
                            $detallesResponse = $this->DAO->saveOrUpdateItem('detalles_movimientos', $dataDetalles, null, true);
                            if ($detallesResponse['status'] == 'success') {
                                if ($tipoMovimiento == 'Entrada') {
                                    $totalCantidad = $cantidad_almacen + $cantidadMovimiento;
                                } else {
                                    $totalCantidad = $cantidad_almacen - $cantidadMovimiento;
                                }
                                $dataContenido = array(
                                    "productoID" => $productoId,
                                    "contenidoCantidad" => $totalCantidad,
                                    "contenidoFechaActualizacion" => $currentDate
                                );
                                $responseContenido = $this->DAO->updateData('contenido_almacen', $dataContenido, array('almacenID' => $almacenId));
                                if ($responseContenido['status'] == 'success') {
                                    $response = array(
                                        "status" => "success",
                                        "status_code" => 200,
                                        "message" =>  "Movimiento registrado exitosamente",
                                        "data" => null,
                                    );
                                } else {
                                    $response = array(
                                        "status" => "error",
                                        "status_code" => 409,
                                        "message" =>  $responseContenido['message'],
                                        "data" => null,
                                    );
                                }
                            } else {
                                $response = array(
                                    "status" => "error",
                                    "status_code" => 409,
                                    "message" =>  $detallesResponse['message'],
                                    "data" => null,
                                );
                            }

                            //last else
                        } else {
                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" =>  $dataResponse['message'],
                                "data" => null,
                            );
                        }
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "El almacen ingresado no existe",
                        "validations" => array(
                            "almacenId" => "Ingrese un almacen valido",
                        ),
                        "data" => null
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }

    function movimientos_put()
    {
        $data = $this->put();
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('movimientos', array('movimientoId' => $id), TRUE);
            if ($dataExists['data']) {
                $cantidad_editar = $dataExists['data']->movimientoCantidad;
                $almacen_editar = $dataExists['data']->almacenId;
                $tipo_editar = $dataExists['data']->movimientoTipo;
                if (count($this->put()) > 40) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "movimientoTipo" => "El campo tipo es requerido.",
                            "movimientoFecha" => "El campo fecha es requerido.",
                            "almacenId" => "El campo almacen es requerido.",
                            "movimientoCantidad" => "El campo cantidad es requerido.",
                            "movimientoNotas" => "El campo notas es opcional"
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningun dato fue enviado",
                        "validations" => array(
                            "movimientoTipo" => "El campo tipo es requerido.",
                            "movimientoFecha" => "El campo fecha es requerido.",
                            "almacenId" => "El campo almacen es requerido.",
                            "movimientoCantidad" => "El campo cantidad es requerido.",
                            "movimientoNotas" => "El campo notas es opcional"
                        ),
                        "data" => null
                    );
                } else {
                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('movimientoTipo', 'tipo', 'required|callback_tipo_valid');
                    $this->form_validation->set_rules('movimientoFecha', 'fecha', 'required');
                    $this->form_validation->set_rules('almacenId', 'almacen', 'required|callback_almacen_exists');
                    $this->form_validation->set_rules('movimientoCantidad', 'cantidad', 'required|callback_cantidad_valid');
                    $this->form_validation->set_message('required', 'El campo {field} es requerido.');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {

                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $tipo_movimiento = $data["movimientoTipo"];
                        $almacen_movimiento = $data["almacenId"];
                        $cantidad_movimiento = $data["movimientoCantidad"];
                        if ($almacen_editar == $almacen_movimiento) {
                            $contenidoEditarAlmacen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacen_editar), TRUE);
                            if ($contenidoEditarAlmacen['data']) {
                                $cantidad_almacen = $contenidoEditarAlmacen['data']->contenidoCantidad;
                                if ($tipo_editar == 'Entrada') {
                                    $cantidadAlmacen = $cantidad_almacen - $cantidad_editar;
                                    $totalNuevaCantidad = $cantidadAlmacen + $cantidad_movimiento;
                                } else {
                                    $cantidadAlmacen = $cantidad_almacen + $cantidad_editar;
                                    if ($cantidad_movimiento > $cantidadAlmacen) {
                                        $response = array(
                                            "status" => "error",
                                            "status_code" => 409,
                                            "message" => "Validaciones fallidas",
                                            "data" => null,
                                            "validations" => array(
                                                "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar la actualización de una salida, por favor verifique la cantidad",
                                            )
                                        );
                                    } else {
                                        $totalNuevaCantidad = $cantidadAlmacen - $cantidad_movimiento;
                                    }
                                }
                                if (@$totalNuevaCantidad) {
                                    $dataMovimiento = array(
                                        "movimientoTipo" => $tipo_movimiento,
                                        "almacenId" => $almacen_movimiento,
                                        "movimientoCantidad" => $cantidad_movimiento,
                                        "movimientoFecha" => $data["movimientoFecha"],
                                        "movimientoNotas" => (@$data["movimientoNotas"]) ? $data["movimientoNotas"] : '',
                                        "movimientoUsuarioActualizacion" => (@$data["movimientoUsuarioActualizacion"]) ? $data["movimientoUsuarioActualizacion"] : '',
                                        "movimientoFechaActualizacion" => $currentDate,

                                    );
                                    $dataResponse = $this->DAO->updateData('movimientos', $dataMovimiento, array('movimientoId' => $id));
                                    if ($dataResponse['status'] == 'success') {
                                        $dataDetalles = array(
                                            'detalleCantidad' => $cantidad_movimiento,
                                            'detallesFechaActualizacion' => $currentDate
                                        );
                                        $detallesResponse = $this->DAO->updateData('detalles_movimientos', $dataDetalles, array('movimiento_id' => $id));
                                        if ($detallesResponse['status'] == 'success') {
                                            $dataContenido = array(
                                                "contenidoCantidad" => $cantidadAlmacen,
                                                "contenidoFechaActualizacion" => $currentDate
                                            );
                                            $responseContenido = $this->DAO->updateData('contenido_almacen', $dataContenido, array('almacenID' => $almacen_editar));
                                            if ($responseContenido['status'] == 'success') {

                                                $dataNuevoContenido = array(
                                                    "contenidoCantidad" => $totalNuevaCantidad,
                                                    "contenidoFechaActualizacion" => $currentDate
                                                );
                                                $responseNuevoContenido = $this->DAO->updateData('contenido_almacen', $dataNuevoContenido, array('almacenID' => $almacen_movimiento));
                                                if ($responseNuevoContenido['status'] == 'success') {
                                                    $response = array(
                                                        "status" => "success",
                                                        "status_code" => 200,
                                                        "message" =>  "Movimiento registrado exitosamente",
                                                        "data" => null,
                                                    );
                                                } else {
                                                    $response = array(
                                                        "status" => "error",
                                                        "status_code" => 409,
                                                        "message" =>  $responseNuevoContenido['message'],
                                                        "data" => null,
                                                    );
                                                }
                                            } else {
                                                $response = array(
                                                    "status" => "error",
                                                    "status_code" => 409,
                                                    "message" =>  $responseContenido['message'],
                                                    "data" => null,
                                                );
                                            }
                                        } else {
                                            $response = array(
                                                "status" => "error",
                                                "status_code" => 409,
                                                "message" =>  $detallesResponse['message'],
                                                "data" => null,
                                            );
                                        }
                                    } else {
                                        $response = array(
                                            "status" => "error",
                                            "status_code" => 409,
                                            "message" =>  $dataResponse['message'],
                                            "data" => null,
                                        );
                                    }
                                } else {
                                    $response = array(
                                        "status" => "error",
                                        "status_code" => 409,
                                        "message" => "Validaciones fallidas",
                                        "data" => null,
                                        "validations" => array(
                                            "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar la actualización de una salida, por favor verifique la cantidad",
                                        )
                                    );
                                }
                              /*   if ($cantidadAlmacen) {
                                    if ($tipo_movimiento == 'Entrada') {
                                        $totalNuevaCantidad = $cantidadAlmacen + $cantidad_movimiento;
                                    } else {
                                        if ($cantidad_movimiento > $cantidadAlmacen) {
                                            $response = array(
                                                "status" => "error",
                                                "status_code" => 409,
                                                "message" => "Validaciones fallidas",
                                                "data" => null,
                                                "validations" => array(
                                                    "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar la actualización de una salida, por favor verifique la cantidad",
                                                )
                                            );
                                        } else {
                                            $totalNuevaCantidad = $cantidadAlmacen - $cantidad_movimiento;
                                        }
                                    }

                                  
                                    if (@$totalNuevaCantidad) {
                                        $dataMovimiento = array(
                                            "movimientoTipo" => $tipo_movimiento,
                                            "almacenId" => $almacen_movimiento,
                                            "movimientoCantidad" => $cantidad_movimiento,
                                            "movimientoFecha" => $data["movimientoFecha"],
                                            "movimientoNotas" => (@$data["movimientoNotas"]) ? $data["movimientoNotas"] : '',
                                            "movimientoUsuarioActualizacion" => (@$data["movimientoUsuarioActualizacion"]) ? $data["movimientoUsuarioActualizacion"] : '',
                                            "movimientoFechaActualizacion" => $currentDate,

                                        );
                                        $dataResponse = $this->DAO->updateData('movimientos', $dataMovimiento, array('movimientoId' => $id));
                                        if ($dataResponse['status'] == 'success') {
                                            $dataDetalles = array(
                                                'detalleCantidad' => $cantidad_movimiento,
                                                'detallesFechaActualizacion' => $currentDate
                                            );
                                            $detallesResponse = $this->DAO->updateData('detalles_movimientos', $dataDetalles, array('movimiento_id' => $id));
                                            if ($detallesResponse['status'] == 'success') {
                                                $dataContenido = array(
                                                    "contenidoCantidad" => $cantidadAlmacen,
                                                    "contenidoFechaActualizacion" => $currentDate
                                                );
                                                $responseContenido = $this->DAO->updateData('contenido_almacen', $dataContenido, array('almacenID' => $almacen_editar));
                                                if ($responseContenido['status'] == 'success') {

                                                    $dataNuevoContenido = array(
                                                        "contenidoCantidad" => $totalNuevaCantidad,
                                                        "contenidoFechaActualizacion" => $currentDate
                                                    );
                                                    $responseNuevoContenido = $this->DAO->updateData('contenido_almacen', $dataNuevoContenido, array('almacenID' => $almacen_movimiento));
                                                    if ($responseNuevoContenido['status'] == 'success') {
                                                        $response = array(
                                                            "status" => "success",
                                                            "status_code" => 200,
                                                            "message" =>  "Movimiento registrado exitosamente",
                                                            "data" => null,
                                                        );
                                                    } else {
                                                        $response = array(
                                                            "status" => "error",
                                                            "status_code" => 409,
                                                            "message" =>  $responseNuevoContenido['message'],
                                                            "data" => null,
                                                        );
                                                    }
                                                } else {
                                                    $response = array(
                                                        "status" => "error",
                                                        "status_code" => 409,
                                                        "message" =>  $responseContenido['message'],
                                                        "data" => null,
                                                    );
                                                }
                                            } else {
                                                $response = array(
                                                    "status" => "error",
                                                    "status_code" => 409,
                                                    "message" =>  $detallesResponse['message'],
                                                    "data" => null,
                                                );
                                            }
                                        } else {
                                            $response = array(
                                                "status" => "error",
                                                "status_code" => 409,
                                                "message" =>  $dataResponse['message'],
                                                "data" => null,
                                            );
                                        }
                                    } else {
                                        $response = array(
                                            "status" => "error",
                                            "status_code" => 409,
                                            "message" => "Validaciones fallidas",
                                            "data" => null,
                                            "validations" => array(
                                                "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar la actualización de una salida, por favor verifique la cantidad",
                                            )
                                        );
                                    }


                                }else{
                                    $response = array(
                                        "status" => "error",
                                        "status_code" => 409,
                                        "message" => "El almacen ingresado no existexx",
                                        "validations" => array(
                                            "almacenId" => "Ingrese un almacen valido",
                                        ),
                                        "data" => null
                                    );
                                } */
                            } else {
                                $response = array(
                                    "status" => "error",
                                    "status_code" => 409,
                                    "message" => "El almacen ingresado no existe",
                                    "validations" => array(
                                        "almacenId" => "Ingrese un almacen valido",
                                    ),
                                    "data" => null
                                );
                            }
                            /* ---- */
                        } else {
                            $contenidoNuevoAlmacen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacen_movimiento), TRUE);
                            if ($contenidoNuevoAlmacen['data']) {
                                $cantidadAlmacen = $contenidoNuevoAlmacen['data']->contenidoCantidad;
                                if ($tipo_movimiento == 'Salida' && $cantidad_movimiento > $cantidadAlmacen) {
                                    $response = array(
                                        "status" => "error",
                                        "status_code" => 409,
                                        "message" => "Validaciones fallidas",
                                        "data" => null,
                                        "validations" => array(
                                            "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar la actualización de una salida, por favor verifique la cantidad",
                                        )
                                    );
                                } else {
                                    /* aqui codigo */
                                    $dataMovimiento = array(
                                        "movimientoTipo" => $tipo_movimiento,
                                        "almacenId" => $almacen_movimiento,
                                        "movimientoCantidad" => $cantidad_movimiento,
                                        "movimientoFecha" => $data["movimientoFecha"],
                                        "movimientoNotas" => (@$data["movimientoNotas"]) ? $data["movimientoNotas"] : '',
                                        "movimientoUsuarioActualizacion" => (@$data["movimientoUsuarioActualizacion"]) ? $data["movimientoUsuarioActualizacion"] : '',
                                        "movimientoFechaActualizacion" => $currentDate,

                                    );
                                    $dataResponse = $this->DAO->updateData('movimientos', $dataMovimiento, array('movimientoId' => $id));
                                    if ($dataResponse['status'] == 'success') {
                                        $dataDetalles = array(
                                            'detalleCantidad' => $cantidad_movimiento,
                                            'detallesFechaActualizacion' => $currentDate
                                        );
                                        $detallesResponse = $this->DAO->updateData('detalles_movimientos', $dataDetalles, array('movimiento_id' => $id));
                                        if ($detallesResponse['status'] == 'success') {
                                            /* obtenemos la información del antiguo almacen */
                                            $contenidoEditarAlmacen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacen_editar), TRUE);
                                            if ($contenidoEditarAlmacen['data']) {
                                                /* obtenemos cantidad del antiguo almacen */
                                                $cantidad_almacen = $contenidoEditarAlmacen['data']->contenidoCantidad;
                                                if ($tipo_editar == 'Entrada') {
                                                    $totalCantidad = $cantidad_almacen - $cantidad_editar;
                                                } else {
                                                    $totalCantidad = $cantidad_almacen + $cantidad_editar;
                                                }
                                                $dataContenido = array(
                                                    "contenidoCantidad" => $totalCantidad,
                                                    "contenidoFechaActualizacion" => $currentDate
                                                );
                                                $responseContenido = $this->DAO->updateData('contenido_almacen', $dataContenido, array('almacenID' => $almacen_editar));
                                                if ($responseContenido['status'] == 'success') {
                                                    $contenidoNuevoAlmacen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacen_movimiento), TRUE);
                                                    $cantidadAlmacen = $contenidoNuevoAlmacen['data']->contenidoCantidad;
                                                    if ($tipo_movimiento == 'Entrada') {
                                                        $totalNuevaCantidad = $cantidadAlmacen + $cantidad_movimiento;
                                                    } else {

                                                        $totalNuevaCantidad = $cantidadAlmacen - $cantidad_movimiento;
                                                    }
                                                    if (@$totalNuevaCantidad) {
                                                        $dataNuevoContenido = array(
                                                            "contenidoCantidad" => $totalNuevaCantidad,
                                                            "contenidoFechaActualizacion" => $currentDate
                                                        );
                                                        $responseNuevoContenido = $this->DAO->updateData('contenido_almacen', $dataNuevoContenido, array('almacenID' => $almacen_movimiento));
                                                        if ($responseNuevoContenido['status'] == 'success') {
                                                            $response = array(
                                                                "status" => "success",
                                                                "status_code" => 200,
                                                                "message" =>  "Movimiento registrado exitosamente",
                                                                "data" => null,
                                                            );
                                                        } else {
                                                            $response = array(
                                                                "status" => "error",
                                                                "status_code" => 409,
                                                                "message" =>  $responseNuevoContenido['message'],
                                                                "data" => null,
                                                            );
                                                        }
                                                    } else {
                                                        $response = array(
                                                            "status" => "error",
                                                            "status_code" => 409,
                                                            "message" => "Validaciones fallidas",
                                                            "data" => null,
                                                            "validations" => array(
                                                                "movimientoCantidad" => "No existe suficiente cantidad en el almacen para realizar registro de una salida, por favor verifique la cantidad",
                                                            )
                                                        );
                                                    }
                                                } else {
                                                    $response = array(
                                                        "status" => "error",
                                                        "status_code" => 409,
                                                        "message" =>  $responseContenido['message'],
                                                        "data" => null,
                                                    );
                                                }


                                                /* otro else */
                                            } else {
                                                $response = array(
                                                    "status" => "error",
                                                    "status_code" => 409,
                                                    "message" =>  $contenidoEditarAlmacen['message'],
                                                    "data" => $contenidoEditarAlmacen['data'],
                                                );
                                            }
                                        } else {
                                            $response = array(
                                                "status" => "error",
                                                "status_code" => 409,
                                                "message" =>  $detallesResponse['message'],
                                                "data" => null,
                                            );
                                        }

                                        //last else
                                    } else {
                                        $response = array(
                                            "status" => "error",
                                            "status_code" => 409,
                                            "message" =>  $dataResponse['message'],
                                            "data" => null,
                                        );
                                    }
                                    /* termina */
                                }
                            } else {
                                $response = array(
                                    "status" => "error",
                                    "status_code" => 409,
                                    "message" => "El almacen ingresado no existe",
                                    "validations" => array(
                                        "almacenId" => "Ingrese un almacen valido",
                                    ),
                                    "data" => null
                                );
                            }
                        }
                    }
                    /* ultimo else */
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "No hay datos del movimiento ingresado",
                    "validations" => array(
                        "id" => "Required",
                    ),
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Required",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function movimientosDelete_put()
    {
        $id = $this->get('id');
        $transactionData = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('movimientos', array('movimientoId' => $id), TRUE);
            if ($dataExists['data']) {
                $cantidad = $dataExists['data']->movimientoCantidad;
                $almacen = $dataExists['data']->almacenId;
                $tipo = $dataExists['data']->movimientoTipo;
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "movimientoStatus" => 0,
                    "movimientoUsuarioActualizacion"=>(@$transactionData["movimientoUsuarioActualizacion"]) ? $transactionData["movimientoUsuarioActualizacion"] : '',
                    "movimientoFechaActualizacion" => $currentDate,
                );
                $dataResponse = $this->DAO->updateData('movimientos', $data, array('movimientoId' => $id));
                if ($dataResponse['status'] == 'success') {
                    $contenidoAlmacen = $this->DAO->selectEntity('contenido_almacen', array('almacenID' => $almacen), TRUE);
                    if ($contenidoAlmacen['data']) {
                        $cantidad_almacen = $contenidoAlmacen['data']->contenidoCantidad;
                        if ($tipo == 'Entrada') {
                            $totalCantidad = $cantidad_almacen - $cantidad;
                        } else {

                            $totalCantidad = $cantidad_almacen + $cantidad;
                        }
                        $dataContenido = array(
                            "contenidoCantidad" => $totalCantidad,
                            "contenidoFechaActualizacion" => $currentDate
                        );
                        $responseContenido = $this->DAO->updateData('contenido_almacen', $dataContenido, array('almacenID' => $almacen));
                        if ($responseContenido['status'] == 'success') {
                            $response = array(
                                "status" => "success",
                                "status_code" => 200,
                                "message" => "El movimiento ha sido desactivado exitosamente",
                                "validations" => null,
                                "data" => null
                            );
                        } else {
                            $response = array(
                                "status" => "error",
                                "status_code" => 409,
                                "message" =>  $responseContenido['message'],
                                "data" => null,
                            );
                        }
                    } else {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" =>  $contenidoAlmacen['message'],
                            "data" => null,
                        );
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El movimiento especificado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id del movimiento no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    /* CUSTOMS VALIDATIONS */
    function almacen_exists($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $almacenExists = $this->DAO->selectEntity('almacenes', array('almacenId' => $str), TRUE);
            if ($almacenExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('almacen_exists', 'El campo {field} no existe, por favor ingrese un almacen que se encuentre registrado.');
                return FALSE;
            }
        }
    }

    function tipo_valid($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {

            if ($str == 'Entrada' || $str == 'Salida') {
                return TRUE;
            } else {
                $this->form_validation->set_message('tipo_valid', 'El campo {field} debe ser Entrada ó Salida.');
                return FALSE;
            }
        }
    }

    function cantidad_valid($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {

            if ($str > 0) {
                return TRUE;
            } else {
                $this->form_validation->set_message('cantidad_valid', 'El campo {field} debe ser mayor a 0.');
                return FALSE;
            }
        }
    }
}
