<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  /* Función para obtener los pedidos */
  function pedidos_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => " Se enviaron demasiados parámetros",
        "validations" => array(
          "id" => "Enviar Id (Obtener) para obtener un pedido específico, o vacío para obtener todos los pedidos"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_pedidos', array('id_venta' => $id, 'is_order' => 1, 'status' => 1), true);
      } else {
        $response = $this->DAO->selectEntity('vw_pedidos', array('is_order' => 1, 'status' => 1), FALSE);
      }
    }
    $this->response($response, $response['status_code']);
  }

  function pedidos_cancelados_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => " Se enviaron demasiados parámetros",
        "validations" => array(
          "id" => "Enviar Id (Obtener) para obtener un pedido específico, o vacío para obtener todos los pedidos"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_vens', array('id_venta' => $id, 'is_order' => 1, 'status' => 5), true);
      } else {
        $response = $this->DAO->selectEntity('vw_vens', array('is_order' => 1, 'status' => 5), FALSE);
      }
    }
    $this->response($response, $response['status_code']);
  }
    public function generarFolio()
    {
        $query_id = $this->db->query("SELECT RIGHT(folio_venta, 7) as folio FROM ventas ORDER BY folio_venta DESC LIMIT 1")->row();
        if ($query_id) {
            $folio = $query_id->folio + 1;
        } else {
            $folio = 1;
        }
        $year = date('y');
        $day = date('d');
        $month = date('m');
        $f_id = str_pad($folio, 7, "0", STR_PAD_LEFT);
        $folio = "V$day$month$year-$f_id";
        return $folio;
    }
  /* Función para registrar un pedido interno */
  function pedidos_internos_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 11) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No se recibieron datos' : 'Se recibieron demasiados datos',
        "data" => count($data),
        "validations" => array(
          "id_cliente" => "Campo requerido.",
          "fecha" => "Campo requerido.",
          "hora" => "Campo requerido.",
          "id_producto" => "Campo requerido.",
          "tipo_unidad" => "Campo requerido.",
          "cantidad" => "Campo requerido.",
          "comentarios" => "Campo opcional."
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('id_cliente', 'id_cliente', 'required|callback_client_exists');
      $this->form_validation->set_rules('fecha', 'fecha', 'required');
      $this->form_validation->set_rules('hora', 'hora', 'required');
      $this->form_validation->set_rules('cantidad', 'cantidad', 'required');
      $this->form_validation->set_rules('id_producto', 'id_producto', 'required|callback_product_exists');
      $this->form_validation->set_rules('tipo_unidad', 'tipo_unidad', 'required|callback_type_valid');
      $this->form_validation->set_message('required', '{field} es requerido.');

      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "Validaciones fallidas",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');

        $ventas = array(
          "folio_venta" => $this->generarFolio(),
          "id_cliente" => $this->post('id_cliente'),
          "id_producto" => $this->post('id_producto'),
          "cantidad_pedido" => $this->post('cantidad'),
          "tipo_unidad" => $this->post('tipo_unidad'),
          "tipo_venta" => 2,
          "is_order" => 1,
          "fecha" => $this->post('fecha'),
          "hora" => $this->post('hora'),
          "status" => 1,
          "notas_venta" => $this->post('comentarios'),
          "id_pago" => 1,
          "ventas_create" => $currentDate,
          "ventas_update" => $currentDate
        );
        $ventasResponse = $this->DAO->saveOrUpdateItem('ventas', $ventas, null, true);
        if ($ventasResponse['status'] == 'success') {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "Pedido registrado exitosamente",
            "data" => $data,
            "validations" => null
          );
        }
        $this->response($response, $response['status_code']);
      }
    }
  }

  /* Función para aprobar un pedido interno */
  function aprobar_pedido_post()
  {
    $id = $this->get('id');
    $data = $this->post();
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
      if ($dataExists['data']) {

        if (count($data) == 0 || count($data) > 11) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => count($data) == 0 ? 'No se recibieron datos' : 'Se recibieron demasiados datos',
            "data" => count($data),
            "validations" => array(
              "fecha_pedido" => "Campo requerido.",
              "hora_pedido" => "Campo requerido."
            )
          );
        } else {
          $this->form_validation->set_data($data);
          $this->form_validation->set_rules('fecha_pedido', 'fecha_pedido', 'required');
          $this->form_validation->set_rules('hora_pedido', 'hora_pedido', 'required');
          $this->form_validation->set_message('required', '{field} es requerido.');

          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validaciones fallidas",
              "data" => null,
              "validations" => $this->form_validation->error_array()
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $total = 0;
            $subtotal = $this->post('total');
            $id_producto = $dataExists['data']->id_producto;
            foreach ($subtotal as $s) {
              $total = $total + $s;
            }
            $ventas = array(
              "is_order" => 2,
              "fecha" => $this->post('fecha_pedido'),
              "hora" => $this->post('hora_pedido'),
              "status" => 3,
              "total" => $total,
              "notas_venta" => $this->post('comentarios_pedido'),
              "ventas_update" => $currentDate
            );
            $ventasResponse = $this->DAO->updateData('ventas', $ventas, array('id_venta' => $id), true);
            if ($ventasResponse['status'] == 'success') {
              foreach ($data['kilos'] as $i => $val) {
                if ($id_producto == 8) {
                  $dataPV = array(
                    'id_venta' => $id,
                    'id_producto' => $id_producto,
                    'cantidad' => $data['kilos'][$i],
                    "precio" => $data['precio'][$i],
                    'tipo' => 'kg',
                    'tamaño' => '',
                    'subtotal' => $data['total'][$i],
                    'productoVenta_create' => $currentDate,
                    'productoVenta_update' => $currentDate
                  );
                } else {
                  $dataPV = array(
                    'id_venta' => $id,
                    'id_producto' => $data['id_prod'][$i],
                    'cantidad' => $data['kilos'][$i],
                    "precio" => $data['precio'][$i],
                    "grapa" => $data['grapa'][$i],
                    "arete" => $data['arete'][$i],
                    "corral" => $data['corral'][$i],
                    'tipo' => 'kg',
                    'tamaño' => '',
                    'subtotal' => $data['total'][$i],
                    'productoVenta_create' => $currentDate,
                    'productoVenta_update' => $currentDate
                  );
                }
                $pvResponse = $this->DAO->insertData('productos_venta', $dataPV, null, true);
              }
              if ($pvResponse['status'] == 'success') {
                $response = array(
                  "status" => "success",
                  "status_code" => 200,
                  "message" =>  "Venta created successfully",
                  "data" => $data,
                );
              }
            } else {
              $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" =>  $ventasResponse['message'],
                "data" => null,
              );
            }
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  /* Función para cancelar un pedido interno */
  function cancelar_pedido_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id, 'is_order' => 1), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $data = array(
          "comentario_cancelacion" => $this->put('comentario'),
          "status" => 5,
          "ventas_update" => $currentDate
        );
        $response = $this->DAO->saveOrUpdateItem('ventas', $data, array('id_venta' => $id, 'is_order' => 1));
        if ($response['status'] == 'success') {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "El pedido fue cancelado exitosamente",
            "validations" => null,
            "data" => null
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Error al cancelar el pedido",
            "validations" => null,
            "data" => null
          );
        }
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "El pedido no se encuentra, selecciona otro pedido",
          "validations" => array(
            "id" => "Requerido"
          ),
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Demasiados datos fueron enviados o ningún dato fue enviado",
        "validations" => array(
          "id" => "Requerido",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function pedidos_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ventas', array('id_venta' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 10) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "fecha" => "Este dato es requerido",
              "total" => "Este dato es requerido",
              "status" => "Este dato es requerido",
              "id_usuario" => "ESte dato no ha sido registrado previamente"
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "fecha" => "Este dato es requerido",
              "total" => "Este dato es requerido",
              "status" => "Este dato es requerido",
              "id_usuario" => "ESte dato no ha sido registrado previamente"
            ),
            "data" => null
          );
        } else {

          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('fecha', 'fecha', 'required');
          $this->form_validation->set_rules('total', 'total', 'required');
          $this->form_validation->set_rules('status', 'status', 'required');
          $this->form_validation->set_rules('id_usuario', 'id_usuario', 'required|callback_brand_exists');

          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validaciones fallidas",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $data = array(
              "fecha" => $this->put('fecha'),
              "total" => $this->put('total'),
              /*"current_stock"=>$this->put('stock'),*/
              "status" => $this->put('status'),
              "id_usuario" => $this->put('id_usuario')

            );
            $response = $this->DAO->saveOrUpdateItem('ventas', $data, array('id_venta' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  /**exta validations**/

  function client_exists($str)
  {
    if (strlen($str) == 0) {
      return true;
    }
    if (strlen($str) >= 1  && strlen($str) <= 45) {
      $clientExists = $this->DAO->selectEntity('clientes', array('id_cliente' => $str), TRUE);
      if ($clientExists['data']) {
        return TRUE;
      } else {
        $this->form_validation->set_message('client_exists', '{field} no existe, por favor ingrese un cliente que se encuentre registrado.');
        return FALSE;
      }
    }
  }

  function product_exists($str)
  {
    if (strlen($str) == 0) {
      return true;
    }
    if (strlen($str) >= 1  && strlen($str) <= 45) {
      $productExists = $this->DAO->selectEntity('productos', array('id_producto' => $str), TRUE);
      if ($productExists['data']) {
        return TRUE;
      } else {
        $this->form_validation->set_message('product_exists', '{field} no existe, por favor ingrese un producto que se encuentre registrado.');
        return FALSE;
      }
    }
  }

  function type_valid($str)
  {
    if ($str) {
      if ($str == 'Kg' || $str == 'Pz') {
        return true;
      } else {
        $this->form_validation->set_message('type_valid', '{field} debe ser Kg para kilogramos o Pz para piezas');
        return false;
      }
    } else {
      $this->form_validation->set_message('type_valid', '{field} debe ser Kg para kilogramos o Pz para piezas');
      return false;
    }
  }
}
