<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        //$this->load->model('AlmacenModelo');
    }

    function modulos_get()
    {
        $id = $this->get('id');

        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un módulo en específico, o vacío para obtener todos los modulos"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('modulos_app', array('moduloId' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('modulos_app', array('moduloStatus'=>1), FALSE);
            }
        }
        $this->response($response, $response['status_code']);
    }



    function modulos_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "moduloNombre" => "El campo nombre es requerido y unico",
                    //"moduloUsuarioRegistro" => "El campo usuario de registro es requerido."
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('moduloNombre', 'nombre', 'required|is_unique[modulos_app.moduloNombre]');
            //$this->form_validation->set_rules('moduloUsuarioRegistro', 'usuario de registro', 'required');
            $this->form_validation->set_message('is_unique', 'El campo {field} debe ser unico.');
            $this->form_validation->set_message('required', 'El campo {field} es requerido.');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $data = array(
                    "moduloNombre" => $data["moduloNombre"],
                    "moduloUsuarioRegistro" => (@$data["moduloUsuarioRegistro"]) ? $data["moduloUsuarioRegistro"] : '',
                    "moduloFechaRegistro" => $currentDate,
                    "moduloFechaActualizacion" => $currentDate,
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('modulos_app', $data, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Módulo registrado exitosamente",
                            "data" => null,
                        );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }

    //actualizar ls datos en la bd
    function modulos_put()
    {
        $data = $this->put();
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('modulos_app', array('moduloId' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 15) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "moduloNombre" => "El nombre es requerido",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningún dato fue enviado",
                        "validations" => array(
                            "moduloNombre" =>  "El nombre es requerido.",
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('moduloNombre', 'nombre', 'required');
                    $this->form_validation->set_message('required', 'El {field} es requerido.');
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "moduloNombre" => $data["moduloNombre"],
                            "moduloUsuarioActualizacion" => (@$data["moduloUsuarioActualizacion"]) ? $data["moduloUsuarioActualizacion"] : '',
                            "moduloFechaActualizacion" => $currentDate,
                        );

                        $response = $this->DAO->updateData('modulos_app', $data, array('moduloId' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Id requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function modulosDelete_put()
    {
        $id = $this->get('id');
        $moduloData = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('modulos_app', array('moduloId' => $id), TRUE);
            if ($dataExists['data']) {
                $modulosData = $this->DAO->selectEntity('modulos_app', array('moduloId' => $id), FALSE);
                if ($modulosData['data']) {
                    date_default_timezone_set('America/Mexico_City');
                    $currentDate = date('Y-m-d H:i:s');
                    $data = array(
                        "moduloStatus" => 0,
                        "moduloUsuarioActualizacion" => (@$moduloData["moduloUsuarioActualizacion"]) ? $moduloData["moduloUsuarioActualizacion"] : '',
                        'moduloFechaActualizacion' => $currentDate

                    );
                    $response = $this->DAO->updateData('modulos_app', $data, array('moduloId' => $id));
                } 
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El módulo especificado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id del módulo no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
}
