<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        //$this->load->model('AlmacenModelo');
    }

    function permisos_usuarios_get()
    {
        $id = $this->get('id');
        $userId=$this->get('userId');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => " Se enviaron demasiados parámetros",
                "validations" => array(
                    "id" => "Enviar Id (Obtener) para obtener un permiso en específico, o vacío para obtener todos los permisos"
                ),
                "data" => null
            );
        } else {
            if ($id){
                $response = $this->DAO->selectEntity('vw_permisosUsuarios', array('permisoId' => $id), TRUE);
            }else if($userId){
                $response = $this->DAO->selectEntity('vw_permisosUsuarios', array('usuarioID' => $userId), FALSE);
            } else {
                $response = $this->DAO->selectEntity('vw_permisosUsuarios', NULL, FALSE);
            }
        }
        $this->response($response, $response['status_code']);
    }


    function permisos_usuarios_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 15) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No se recibieron datos' : 'Demasiados datos fueron enviados',
                "data" => count($data),
                "validations" => array(
                    "usuarioID" => "El campo usuario es requerido",
                    "permissions" => "El campo permisos es requerido"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('usuarioID', 'usuario', 'required');
            $this->form_validation->set_message('is_unique', 'El campo {field} debe ser unico.');
            $this->form_validation->set_message('required', 'El campo {field} es requerido.');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "Validaciones fallidas",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $userPermissionExists=$this->DAO->selectEntity('usuarios_permisos', array('usuarioID' => $data['usuarioID']), FALSE);
                if(@$userPermissionExists['data']){
                    $userPermissionExistsList=[];
                    
                    foreach($userPermissionExists['data'] as $rowPermission){
                        $userPermissionExistsList[]=$rowPermission->permisoId;
                        if(!in_array($rowPermission->permisoId, $data['permissions'])){
                            //$test[]=$rowPermission->permisoId;
                            $this->DAO->deleteData('usuarios_permisos', array('usuarioPermisoId' => $rowPermission->usuarioPermisoId));
                        }
                    }
                    
                    foreach($data['permissions'] as $row){  
                        if(!in_array($row, $userPermissionExistsList)){
                            //$test1[]=$row;
                            $permissionUser[]=array(
                                'permisoId'=>$row,
                                'usuarioID'=>$data['usuarioID'],
                                'permisoFechaRegistro'=>$currentDate,
                                'permisoFechaActualizacion'=>$currentDate,
                                'permisoUsuarioActualizacion'=>$data['usuarioPermisoUsuarioRegistro']
                            );
                        }/* else{
                            if()
                            $test[]=$row;
                        } */
                    }
                    
                    /* foreach($userPermissionExistsList as $row){

                    } */
                    /* $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $test1,
                        "data" => $test,
                    ); */
                    
                }else{
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  "ENTRO AQUÍ 2",
                        "data" => null,
                    );
                    foreach($data['permissions'] as $row){
                        $permissionUser[]=array(
                            'permisoId'=>$row,
                            'usuarioID'=>$data['usuarioID'],
                            'permisoFechaRegistro'=>$currentDate,
                            'permisoFechaActualizacion'=>$currentDate,
                            'permisoUsuarioRegistro'=>$data['usuarioPermisoUsuarioRegistro']
                        );
                    }

                }
                if(@$permissionUser){
                    $dataResponse = $this->DAO->saveOrUpdateBatchItems('usuarios_permisos', $permissionUser);
                
                if ($dataResponse['status'] == "success") {
                    $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Permiso registrado exitosamente",
                            "data" => null,
                        );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => $permissionUser,
                    );
                }
                }else{
                     $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Permiso registrado exitosamente",
                            "data" => null,
                        );

                }
                
            }
        }
        $this->response($response, $response['status_code']);
    }

    //actualizar ls datos en la bd
    function permisos_put()
    {
        $data = $this->put();
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('permisos', array('permisoId' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($this->put()) > 15) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Demasiados datos fueron enviados",
                        "validations" => array(
                            "permisoCodigo" => "El campo código es requerido",
                            "permisoNombre" => "El campo nombre es requerido",
                            "moduloId" => "El campo modulo es requerido",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Ningún dato fue enviado",
                        "validations" => array(
                            "permisoCodigo" => "El campo código es requerido",
                            "permisoNombre" => "El campo nombre es requerido",
                            "moduloId" => "El campo modulo es requerido",
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('permisoCodigo', 'código', 'required');
                    $this->form_validation->set_rules('permisoNombre', 'nombre', 'required');
                    $this->form_validation->set_rules('moduloId', 'módulo', 'required|callback_modulo_exists');
                    $this->form_validation->set_message('required', 'El campo {field} es requerido.');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validaciones fallidas",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "permisoCodigo" => $data["permisoCodigo"],
                            "permisoNombre" => $data["permisoNombre"],
                            "moduloId" => $data["moduloId"],
                            "permisoUsuarioActualizacion" => (@$data["permisoUsuarioActualizacion"]) ? $data["permisoUsuarioActualizacion"] : '',
                            "permisoFechaActualizacion" => $currentDate,
                        );

                        $response = $this->DAO->updateData('permisos', $data, array('permisoId' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Id requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function permisosDelete_put()
    {
        $id = $this->get('id');
        $permisoData = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('permisos', array('permisoId' => $id), TRUE);
            if ($dataExists['data']) {
                $permisosData = $this->DAO->selectEntity('permisos', array('permisoId' => $id), FALSE);
                if ($permisosData['data']) {
                    date_default_timezone_set('America/Mexico_City');
                    $currentDate = date('Y-m-d H:i:s');
                    $data = array(
                        "permisoStatus" => 0,
                        "permisoUsuarioActualizacion" => (@$permisoData["permisoUsuarioActualizacion"]) ? $permisoData["permisoUsuarioActualizacion"] : '',
                        'permisoFechaActualizacion' => $currentDate

                    );
                    $response = $this->DAO->updateData('permisos', $data, array('permisoId' => $id));
                } 
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "El permiso especificado no existe",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id del permiso no fue enviado o demasiados datos fueron enviados",
                "validations" => array(
                    "id" => "Campo requerido",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function modulo_exists($str)
    {
        if (strlen($str) == 0) {
            return true;
        }
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $moduloExists = $this->DAO->selectEntity('modulos_app', array('moduloId' => $str), TRUE);
            if ($moduloExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('modulo_exists', '{field} no existe, por favor ingrese un módulo que se encuentre registrado.');
                return FALSE;
            }
        }
    }
}
